/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.testability.transformer;

import org.evosuite.instrumentation.TransformationStatistics;
import org.evosuite.instrumentation.testability.BooleanTestabilityTransformation;
import org.evosuite.instrumentation.testability.DescriptorMapping;
import org.evosuite.instrumentation.testability.transformer.MethodNodeTransformer;
import org.evosuite.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.FieldInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.InsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodNode;
import org.evosuite.shaded.org.objectweb.asm.tree.VarInsnNode;

public class BooleanDefinitionTransformer
extends MethodNodeTransformer {
    private final BooleanTestabilityTransformation booleanTestabilityTransformation;

    public BooleanDefinitionTransformer(BooleanTestabilityTransformation booleanTestabilityTransformation) {
        this.booleanTestabilityTransformation = booleanTestabilityTransformation;
    }

    @Override
    protected AbstractInsnNode transformInsnNode(MethodNode mn, InsnNode insnNode) {
        BooleanTestabilityTransformation.logger.info("Checking transformation of InsnNode ");
        if (insnNode.getOpcode() == 3 && this.booleanTestabilityTransformation.isBooleanAssignment(insnNode, mn)) {
            TransformationStatistics.insertedGet();
            this.booleanTestabilityTransformation.insertGet(insnNode, mn.instructions);
        } else if (insnNode.getOpcode() == 4 && this.booleanTestabilityTransformation.isBooleanAssignment(insnNode, mn)) {
            TransformationStatistics.insertedGet();
            this.booleanTestabilityTransformation.insertGet(insnNode, mn.instructions);
        }
        return insnNode;
    }

    @Override
    protected AbstractInsnNode transformVarInsnNode(MethodNode mn, VarInsnNode varNode) {
        if (this.booleanTestabilityTransformation.isBooleanVariable(varNode.var, mn) && varNode.getNext() instanceof VarInsnNode) {
            VarInsnNode vn2 = (VarInsnNode)varNode.getNext();
            if (varNode.var == vn2.var) {
                this.booleanTestabilityTransformation.insertGet(varNode, mn.instructions);
            }
        }
        return varNode;
    }

    @Override
    protected AbstractInsnNode transformFieldInsnNode(MethodNode mn, FieldInsnNode fieldNode) {
        if (DescriptorMapping.getInstance().isTransformedOrBooleanField(this.booleanTestabilityTransformation.className, fieldNode.name, fieldNode.desc) && fieldNode.getNext() instanceof FieldInsnNode) {
            FieldInsnNode other = (FieldInsnNode)fieldNode.getNext();
            if (fieldNode.owner.equals(other.owner) && fieldNode.name.equals(other.name) && fieldNode.desc.equals(other.desc)) {
                if (fieldNode.getOpcode() == 180 && other.getOpcode() == 181) {
                    this.booleanTestabilityTransformation.insertGetBefore(other, mn.instructions);
                } else if (fieldNode.getOpcode() == 178 && other.getOpcode() == 179) {
                    this.booleanTestabilityTransformation.insertGetBefore(other, mn.instructions);
                }
            }
        }
        return fieldNode;
    }
}

