/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.testability;

import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.evosuite.Properties;
import org.evosuite.instrumentation.RegexDistance;
import org.evosuite.instrumentation.testability.BooleanHelper;
import org.evosuite.seeding.ConstantPoolManager;

public class StringHelper {
    public static int editDistance(String s, String t) {
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static int StringEquals(String first, Object second) {
        if (first == null) {
            throw new NullPointerException("StringEquals is not supposed to work on a null caller");
        }
        if (second == null) {
            return -2147483645;
        }
        if (first.equals(second)) {
            return 0x7FFFFFFD;
        }
        ConstantPoolManager.getInstance().addDynamicConstant(first);
        ConstantPoolManager.getInstance().addDynamicConstant(second);
        double distance = -StringHelper.getDistanceBasedOnLeftAlignmentCharacterDistance(first, second.toString());
        double d2 = distance / (1.0 + Math.abs(distance));
        return (int)Math.round(2.147483645E9 * d2);
    }

    public static double StringEqualsCharacterDistance(String first, Object second) {
        if (first == null) {
            throw new IllegalArgumentException("StringEquals is not supposed to work on a null caller");
        }
        if (second == null) {
            return -2.147483645E9;
        }
        if (first.equals(second)) {
            return 2.147483645E9;
        }
        return -StringHelper.getDistanceBasedOnLeftAlignmentCharacterDistance(first, second.toString());
    }

    public static int StringMatches(String str, String regex) {
        int distance = RegexDistance.getDistance(str, regex);
        if (Properties.DYNAMIC_POOL > 0.0) {
            if (distance > 0) {
                String instance = RegexDistance.getRegexInstance(regex);
                ConstantPoolManager.getInstance().addDynamicConstant(instance);
            } else {
                String instance = RegexDistance.getNonMatchingRegexInstance(regex);
                ConstantPoolManager.getInstance().addDynamicConstant(instance);
            }
        }
        if (distance > 0) {
            return -distance;
        }
        return 0x7FFFFFFD;
    }

    public static int StringMatchRegex(String regex, CharSequence input) {
        int distance = RegexDistance.getDistance(input.toString(), regex);
        if (Properties.DYNAMIC_POOL > 0.0) {
            if (distance > 0) {
                String instance = RegexDistance.getRegexInstance(regex);
                ConstantPoolManager.getInstance().addDynamicConstant(instance);
            } else {
                String instance = RegexDistance.getNonMatchingRegexInstance(regex);
                ConstantPoolManager.getInstance().addDynamicConstant(instance);
            }
        }
        if (distance > 0) {
            return -distance;
        }
        return 0x7FFFFFFD;
    }

    public static int StringMatchRegex(Matcher matcher) {
        Pattern pattern = matcher.pattern();
        String regex = pattern.pattern();
        try {
            Field textField = Matcher.class.getDeclaredField("text");
            textField.setAccessible(true);
            CharSequence input = (CharSequence)textField.get(matcher);
            int distance = RegexDistance.getDistance(input.toString(), regex);
            if (Properties.DYNAMIC_POOL > 0.0) {
                if (distance > 0) {
                    String instance = RegexDistance.getRegexInstance(regex);
                    ConstantPoolManager.getInstance().addDynamicConstant(instance);
                } else {
                    String instance = RegexDistance.getNonMatchingRegexInstance(regex);
                    ConstantPoolManager.getInstance().addDynamicConstant(instance);
                }
            }
            if (distance > 0) {
                return -distance;
            }
            return 0x7FFFFFFD;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return matcher.matches() ? 1 : -1;
        }
    }

    protected static int getDistanceBasedOnLeftAlignment(String a, String b) {
        int differences = 0;
        int min = Math.min(a.length(), b.length());
        int max = Math.max(a.length(), b.length());
        differences += max - min;
        for (int i = 0; i < min; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            ++differences;
        }
        return differences;
    }

    public static double getDistanceBasedOnLeftAlignmentCharacterDistance(String a, String b) {
        if (a == b) {
            return 2.147483645E9;
        }
        if (a == null && b != null) {
            return b.length() + 1;
        }
        if (a != null && b == null) {
            return a.length() + 1;
        }
        double differences = 0.0;
        int min = Math.min(a.length(), b.length());
        int max = Math.max(a.length(), b.length());
        differences += (double)(max - min);
        for (int i = 0; i < min; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            differences += BooleanHelper.normalize(Math.abs(a.charAt(i) - b.charAt(i)));
        }
        return differences;
    }

    public static int StringEqualsIgnoreCase(String first, String second) {
        if (first == null) {
            throw new NullPointerException("StringEquals is not supposed to work on a null caller");
        }
        if (second == null) {
            return -2147483645;
        }
        if (first.equalsIgnoreCase(second)) {
            return 0x7FFFFFFD;
        }
        return StringHelper.StringEquals(first.toLowerCase(), second.toLowerCase());
    }

    public static int StringStartsWith(String value, String prefix, int start) {
        int len = Math.min(prefix.length(), value.length());
        ConstantPoolManager.getInstance().addDynamicConstant(prefix + value);
        return StringHelper.StringEquals(value.substring(start, Math.min(start + len, value.length())), prefix);
    }

    public static int StringEndsWith(String value, String suffix) {
        int len = Math.min(suffix.length(), value.length());
        String val1 = value.substring(value.length() - len);
        ConstantPoolManager.getInstance().addDynamicConstant(value + suffix);
        return StringHelper.StringEquals(val1, suffix);
    }

    public static int StringIsEmpty(String value) {
        int len = value.length();
        if (len == 0) {
            return 0x7FFFFFFD;
        }
        return -len;
    }

    public static int StringRegionMatches(String value, boolean ignoreCase, int thisStart, String string, int start, int length) {
        if (value == null || string == null) {
            throw new NullPointerException();
        }
        if (start < 0 || string.length() - start < length) {
            return -2147483645;
        }
        if (thisStart < 0 || value.length() - thisStart < length) {
            return -2147483645;
        }
        if (length <= 0) {
            return 0x7FFFFFFD;
        }
        if (ignoreCase && value.regionMatches(ignoreCase, thisStart, string, start, length)) {
            return 0x7FFFFFFD;
        }
        String s1 = value;
        String s2 = string;
        if (ignoreCase) {
            s1 = s1.toLowerCase();
            s2 = s2.toLowerCase();
        }
        if (Properties.DYNAMIC_POOL > 0.0) {
            String sub1 = s1.substring(thisStart, length + thisStart);
            String sub2 = s2.substring(start, length + start);
            String sn1 = s1.substring(0, thisStart) + sub2 + s1.substring(thisStart + length);
            String sn2 = s2.substring(0, start) + sub1 + s2.substring(start + length);
            ConstantPoolManager.getInstance().addDynamicConstant(sn1);
            ConstantPoolManager.getInstance().addDynamicConstant(sn2);
        }
        return StringHelper.StringEquals(s1.substring(thisStart, Math.min(length + thisStart, s1.length())), s2.substring(start, Math.min(length + start, s2.length())));
    }

    public static int StringRegionMatches(String value, int thisStart, String string, int start, int length) {
        return StringHelper.StringRegionMatches(value, false, thisStart, string, start, length);
    }
}

