/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.testability;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.evosuite.Properties;
import org.evosuite.seeding.ConstantPoolManager;

public class BooleanHelper {
    public static final int K = 0x7FFFFFFD;
    public static final int TRUE = 0x7FFFFFFD;
    public static final int FALSE = -2147483645;
    static Map<Integer, Integer> lastDistance = new HashMap<Integer, Integer>();
    private static Stack<Object> parametersObject = new Stack();
    private static Stack<Boolean> parametersBoolean = new Stack();
    private static Stack<Character> parametersChar = new Stack();
    private static Stack<Byte> parametersByte = new Stack();
    private static Stack<Short> parametersShort = new Stack();
    private static Stack<Integer> parametersInteger = new Stack();
    private static Stack<Float> parametersFloat = new Stack();
    private static Stack<Long> parametersLong = new Stack();
    private static Stack<Double> parametersDouble = new Stack();

    public static void clearStack() {
        lastDistance.clear();
    }

    public static int objectEquals(Object obj1, Object obj2) {
        return obj1.equals(obj2) ? 0x7FFFFFFD : -2147483645;
    }

    public static void pushPredicate(int distance, int branchId) {
        lastDistance.put(branchId, Math.abs(distance));
    }

    public static int getDistance(int branchId, int approximationLevel, int value) {
        double val;
        int d;
        int distance = Integer.MAX_VALUE;
        if (branchId > 0 && lastDistance.containsKey(branchId)) {
            distance = lastDistance.get(branchId);
        }
        if ((d = (int)Math.ceil(2.147483645E9 * (val = (1.0 + BooleanHelper.normalize(distance)) / Math.pow(2.0, approximationLevel)))) == 0) {
            d = 1;
        }
        if (value <= 0) {
            d = -d;
        }
        return d;
    }

    public static double normalize(int distance) {
        double k = Properties.MAX_INT;
        double d = distance;
        return d / (d + 0.5 * k);
    }

    public static int doubleSubG(double d1, double d2) {
        if (d1 == d2) {
            ConstantPoolManager.getInstance().addDynamicConstant(d1);
            return 0;
        }
        if (Double.isNaN(d1) || Double.isNaN(d2)) {
            return 1;
        }
        return BooleanHelper.doubleSubHelper(d1, d2);
    }

    public static int doubleSubL(double d1, double d2) {
        if (d1 == d2) {
            ConstantPoolManager.getInstance().addDynamicConstant(d1);
            return 0;
        }
        if (Double.isNaN(d1) || Double.isNaN(d2)) {
            return -1;
        }
        return BooleanHelper.doubleSubHelper(d1, d2);
    }

    private static int doubleSubHelper(double d1, double d2) {
        if (Double.isInfinite(d1) || Double.isInfinite(d2)) {
            return Double.compare(d1, d2);
        }
        double diff = d1 - d2;
        double diff2 = diff / (1.0 + Math.abs(diff));
        int d3 = (int)(diff2 < 0.0 ? Math.floor(2.147483647E9 * diff2) : Math.ceil(2.147483647E9 * diff2));
        if (d3 == 0) {
            d3 = (int)Math.signum(diff);
        }
        ConstantPoolManager.getInstance().addDynamicConstant(d1);
        ConstantPoolManager.getInstance().addDynamicConstant(d2);
        return d3;
    }

    public static int floatSubG(float f1, float f2) {
        if (f1 == f2) {
            ConstantPoolManager.getInstance().addDynamicConstant(Float.valueOf(f1));
            return 0;
        }
        if (Float.isNaN(f1) || Float.isNaN(f2)) {
            return 1;
        }
        return BooleanHelper.floatSubHelper(f1, f2);
    }

    public static int floatSubL(float f1, float f2) {
        if (f1 == f2) {
            ConstantPoolManager.getInstance().addDynamicConstant(Float.valueOf(f1));
            return 0;
        }
        if (Float.isNaN(f1) || Float.isNaN(f2)) {
            return -1;
        }
        return BooleanHelper.floatSubHelper(f1, f2);
    }

    private static int floatSubHelper(float f1, float f2) {
        if (Float.isInfinite(f1) || Float.isInfinite(f2)) {
            return Float.compare(f1, f2);
        }
        double diff = (double)f1 - (double)f2;
        double diff2 = Math.signum(diff) * Math.abs(diff) / (1.0 + Math.abs(diff));
        int d3 = (int)Math.ceil(2.147483647E9 * diff2);
        if (d3 == 0) {
            d3 = (int)Math.signum(diff);
        }
        ConstantPoolManager.getInstance().addDynamicConstant(Float.valueOf(f1));
        ConstantPoolManager.getInstance().addDynamicConstant(Float.valueOf(f2));
        return d3;
    }

    public static int intSub(int a, int b) {
        long sub = (long)a - (long)b;
        if (sub < -2147483645L) {
            return -2147483645;
        }
        if (sub > 0x7FFFFFFDL) {
            return 0x7FFFFFFD;
        }
        return (int)sub;
    }

    public static int longSub(long l1, long l2) {
        if (l1 == l2) {
            ConstantPoolManager.getInstance().addDynamicConstant(l1);
            return 0;
        }
        double diff = (double)l1 - (double)l2;
        double diff2 = Math.signum(diff) * Math.abs(diff) / (1.0 + Math.abs(diff));
        int d3 = (int)Math.ceil(2.147483647E9 * diff2);
        ConstantPoolManager.getInstance().addDynamicConstant(l1);
        ConstantPoolManager.getInstance().addDynamicConstant(l2);
        return d3;
    }

    @Deprecated
    public static int fromDouble(double d) {
        if (d == 0.0) {
            return 0;
        }
        double d2 = Math.signum(d) * Math.abs(d) / (1.0 + Math.abs(d));
        int d3 = (int)Math.round(2.147483647E9 * d2);
        return d3;
    }

    @Deprecated
    public static int fromFloat(float d) {
        if (d == 0.0f) {
            return 0;
        }
        float d2 = Math.signum(d) * Math.abs(d) / (1.0f + Math.abs(d));
        int d3 = Math.round(2.1474836E9f * d2);
        return d3;
    }

    @Deprecated
    public static int fromLong(long d) {
        if (d == 0L) {
            return 0;
        }
        double d2 = Math.signum(d) * (float)Math.abs(d) / (float)(1L + Math.abs(d));
        int d3 = (int)Math.round(2.147483647E9 * d2);
        return d3;
    }

    public static int booleanToInt(boolean b) {
        if (b) {
            return 0x7FFFFFFD;
        }
        return -2147483645;
    }

    public static boolean intToBoolean(int x) {
        return x > 0;
    }

    public static int min(int a, int b, int c) {
        if (a < b) {
            return Math.min(a, c);
        }
        return Math.min(b, c);
    }

    public static int compareBoolean(int a, int b) {
        if (a > 0 && b > 0 || a <= 0 && b <= 0) {
            return Math.abs(a - b);
        }
        return -1 * Math.abs(a - b);
    }

    public static int editDistance_old(String s, String t) {
        int j;
        int i;
        int k = 127;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 127;
                d[i][j] = BooleanHelper.min(d[i - 1][j] + k, d[i][j - 1] + k, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    public static int instanceOf(Object o, Class<?> c) {
        if (o == null) {
            return -2147483645;
        }
        return c.isAssignableFrom(o.getClass()) ? 0x7FFFFFFD : -2147483645;
    }

    public static int isNull(Object o, int opcode) {
        if (opcode == 198) {
            return o == null ? 0x7FFFFFFD : -2147483645;
        }
        return o != null ? 0x7FFFFFFD : -2147483645;
    }

    public static int IOR(int a, int b) {
        int ret = 0;
        if (a > 0 || b > 0) {
            ret = a;
            if (b > 0 && b < a) {
                ret = b;
            }
        } else {
            ret = a;
            if (b > a) {
                ret = b;
            }
        }
        return ret;
    }

    public static int IAND(int a, int b) {
        return Math.min(a, b);
    }

    public static int IXOR(int a, int b) {
        int ret = 0;
        ret = a > 0 && b <= 0 ? a : (b > 0 && a <= 0 ? b : -Math.abs(a - b));
        return ret;
    }

    public static int isEqual(Object o1, Object o2, int opcode) {
        if (opcode == 165) {
            return o1 == o2 ? 0x7FFFFFFD : -2147483645;
        }
        return o1 != o2 ? 0x7FFFFFFD : -2147483645;
    }

    public static boolean popParameterBooleanFromInt() {
        int i = parametersInteger.pop();
        boolean result = i > 0;
        return result;
    }

    public static int popParameterIntFromBoolean() {
        boolean i = parametersBoolean.pop();
        if (i) {
            return 0x7FFFFFFD;
        }
        return -2147483645;
    }

    public static boolean popParameterBoolean() {
        return parametersBoolean.pop();
    }

    public static char popParameterChar() {
        return parametersChar.pop().charValue();
    }

    public static byte popParameterByte() {
        return parametersByte.pop();
    }

    public static short popParameterShort() {
        return parametersShort.pop();
    }

    public static int popParameterInt() {
        return parametersInteger.pop();
    }

    public static float popParameterFloat() {
        return parametersFloat.pop().floatValue();
    }

    public static long popParameterLong() {
        return parametersLong.pop();
    }

    public static double popParameterDouble() {
        return parametersDouble.pop();
    }

    public static Object popParameterObject() {
        return parametersObject.pop();
    }

    public static Object popParameter(Object o) {
        return parametersObject.pop();
    }

    public static void pushParameter(boolean o) {
        parametersBoolean.push(o);
    }

    public static void pushParameter(char o) {
        parametersChar.push(Character.valueOf(o));
    }

    public static void pushParameter(byte o) {
        parametersByte.push(o);
    }

    public static void pushParameter(short o) {
        parametersShort.push(o);
    }

    public static void pushParameter(int o) {
        parametersInteger.push(o);
    }

    public static void pushParameter(float o) {
        parametersFloat.push(Float.valueOf(o));
    }

    public static void pushParameter(long o) {
        parametersLong.push(o);
    }

    public static void pushParameter(double o) {
        parametersDouble.push(o);
    }

    public static void pushParameter(Object o) {
        parametersObject.push(o);
    }
}

