/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.mutation;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.instrumentation.mutation.MutationOperator;
import org.evosuite.shaded.org.objectweb.asm.tree.JumpInsnNode;
import org.evosuite.shaded.org.objectweb.asm.tree.LabelNode;
import org.evosuite.shaded.org.objectweb.asm.tree.MethodNode;
import org.evosuite.shaded.org.objectweb.asm.tree.analysis.Frame;

public class NegateCondition
implements MutationOperator {
    private static Map<Integer, Integer> opcodeMap = new HashMap<Integer, Integer>();
    public static final String NAME = "NegateCondition";

    @Override
    public List<Mutation> apply(MethodNode mn, String className, String methodName, BytecodeInstruction instruction, Frame frame) {
        LinkedList<Mutation> mutations = new LinkedList<Mutation>();
        JumpInsnNode node = (JumpInsnNode)instruction.getASMNode();
        LabelNode target = node.label;
        JumpInsnNode mutation = new JumpInsnNode(NegateCondition.getOpposite(node.getOpcode()), target);
        Mutation mutationObject = MutationPool.addMutation(className, methodName, NAME, instruction, mutation, Mutation.getDefaultInfectionDistance());
        mutations.add(mutationObject);
        return mutations;
    }

    private static int getOpposite(int opcode) {
        return opcodeMap.get(opcode);
    }

    @Override
    public boolean isApplicable(BytecodeInstruction instruction) {
        return instruction.isBranch();
    }

    static {
        opcodeMap.put(165, 166);
        opcodeMap.put(166, 165);
        opcodeMap.put(159, 160);
        opcodeMap.put(162, 161);
        opcodeMap.put(163, 164);
        opcodeMap.put(164, 163);
        opcodeMap.put(161, 162);
        opcodeMap.put(160, 159);
        opcodeMap.put(153, 154);
        opcodeMap.put(156, 155);
        opcodeMap.put(157, 158);
        opcodeMap.put(158, 157);
        opcodeMap.put(155, 156);
        opcodeMap.put(154, 153);
        opcodeMap.put(199, 198);
        opcodeMap.put(198, 199);
    }
}

