/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.cfg;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.graphs.cfg.BasicBlock;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.graphs.cfg.ControlFlowEdge;
import org.evosuite.graphs.cfg.ControlFlowGraph;
import org.evosuite.graphs.cfg.EntryBlock;
import org.evosuite.graphs.cfg.ExitBlock;
import org.evosuite.graphs.cfg.RawControlFlowGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActualControlFlowGraph
extends ControlFlowGraph<BasicBlock> {
    private static Logger logger = LoggerFactory.getLogger(ActualControlFlowGraph.class);
    private RawControlFlowGraph rawGraph;
    private BytecodeInstruction entryPoint;
    private Set<BytecodeInstruction> exitPoints;
    private Set<BytecodeInstruction> branches;
    private Set<BytecodeInstruction> branchTargets;
    private Set<BytecodeInstruction> joins;
    private Set<BytecodeInstruction> joinSources;

    public ActualControlFlowGraph(RawControlFlowGraph rawGraph) {
        super(rawGraph.getClassName(), rawGraph.getMethodName(), rawGraph.getMethodAccess());
        this.rawGraph = rawGraph;
        this.fillSets();
        this.computeGraph();
    }

    protected ActualControlFlowGraph(ActualControlFlowGraph toRevert) {
        super(toRevert.className, toRevert.methodName, toRevert.access, toRevert.computeReverseJGraph());
    }

    public ActualControlFlowGraph computeReverseCFG() {
        return new ActualControlFlowGraph(this);
    }

    private void fillSets() {
        this.setEntryPoint(this.rawGraph.determineEntryPoint());
        this.setExitPoints(this.rawGraph.determineExitPoints());
        this.setBranches(this.rawGraph.determineBranches());
        this.setBranchTargets();
        this.setJoins(this.rawGraph.determineJoins());
        this.setJoinSources();
    }

    private void setEntryPoint(BytecodeInstruction entryPoint) {
        if (entryPoint == null) {
            throw new IllegalArgumentException("null given");
        }
        if (!this.belongsToMethod(entryPoint)) {
            throw new IllegalArgumentException("entry point does not belong to this CFGs method");
        }
        this.entryPoint = entryPoint;
    }

    private void setExitPoints(Set<BytecodeInstruction> exitPoints) {
        if (exitPoints == null) {
            throw new IllegalArgumentException("null given");
        }
        this.exitPoints = new HashSet<BytecodeInstruction>();
        for (BytecodeInstruction exitPoint : exitPoints) {
            if (!this.belongsToMethod(exitPoint)) {
                throw new IllegalArgumentException("exit point does not belong to this CFGs method");
            }
            if (!exitPoint.canBeExitPoint()) {
                throw new IllegalArgumentException("unexpected exitPoint byteCode instruction type: " + exitPoint.getInstructionType());
            }
            this.exitPoints.add(exitPoint);
        }
    }

    private void setJoins(Set<BytecodeInstruction> joins) {
        if (joins == null) {
            throw new IllegalArgumentException("null given");
        }
        this.joins = new HashSet<BytecodeInstruction>();
        for (BytecodeInstruction join : joins) {
            if (!this.belongsToMethod(join)) {
                throw new IllegalArgumentException("join does not belong to this CFGs method");
            }
            this.joins.add(join);
        }
    }

    private void setJoinSources() {
        if (this.joins == null) {
            throw new IllegalStateException("expect joins to be set before setting of joinSources");
        }
        if (this.rawGraph == null) {
            throw new IllegalArgumentException("null given");
        }
        this.joinSources = new HashSet<BytecodeInstruction>();
        for (BytecodeInstruction join : this.joins) {
            for (ControlFlowEdge joinEdge : this.rawGraph.incomingEdgesOf(join)) {
                this.joinSources.add((BytecodeInstruction)this.rawGraph.getEdgeSource(joinEdge));
            }
        }
    }

    private void setBranches(Set<BytecodeInstruction> branches) {
        if (branches == null) {
            throw new IllegalArgumentException("null given");
        }
        this.branches = new HashSet<BytecodeInstruction>();
        for (BytecodeInstruction branch : branches) {
            if (!this.belongsToMethod(branch)) {
                throw new IllegalArgumentException("branch does not belong to this CFGs method");
            }
            this.branches.add(branch);
        }
    }

    private void setBranchTargets() {
        if (this.branches == null) {
            throw new IllegalStateException("expect branches to be set before setting of branchTargets");
        }
        if (this.rawGraph == null) {
            throw new IllegalArgumentException("null given");
        }
        this.branchTargets = new HashSet<BytecodeInstruction>();
        for (BytecodeInstruction branch : this.branches) {
            for (ControlFlowEdge branchEdge : this.rawGraph.outgoingEdgesOf(branch)) {
                this.branchTargets.add((BytecodeInstruction)this.rawGraph.getEdgeTarget(branchEdge));
            }
        }
    }

    private Set<BytecodeInstruction> getInitiallyKnownInstructions() {
        HashSet<BytecodeInstruction> r = new HashSet<BytecodeInstruction>();
        r.add(this.entryPoint);
        r.addAll(this.exitPoints);
        r.addAll(this.branches);
        r.addAll(this.branchTargets);
        r.addAll(this.joins);
        r.addAll(this.joinSources);
        return r;
    }

    private void computeGraph() {
        this.computeNodes();
        this.computeEdges();
        this.addAuxiliaryBlocks();
    }

    private void addAuxiliaryBlocks() {
        EntryBlock entry = new EntryBlock(this.className, this.methodName);
        ExitBlock exit = new ExitBlock(this.className, this.methodName);
        this.addBlock(entry);
        this.addBlock(exit);
        this.addEdge(entry, exit);
        this.addEdge(entry, this.entryPoint.getBasicBlock());
        for (BytecodeInstruction exitPoint : this.exitPoints) {
            this.addEdge(exitPoint.getBasicBlock(), exit);
        }
    }

    private void computeNodes() {
        Set<BytecodeInstruction> nodes = this.getInitiallyKnownInstructions();
        for (BytecodeInstruction node : nodes) {
            if (this.knowsInstruction(node)) continue;
            BasicBlock nodeBlock = this.rawGraph.determineBasicBlockFor(node);
            this.addBlock(nodeBlock);
        }
        logger.debug(this.vertexCount() + " BasicBlocks");
    }

    private void computeEdges() {
        for (BasicBlock block : this.vertexSet()) {
            this.computeIncomingEdgesFor(block);
            this.computeOutgoingEdgesFor(block);
        }
        logger.debug(this.edgeCount() + " ControlFlowEdges");
    }

    private void computeIncomingEdgesFor(BasicBlock block) {
        if (this.isEntryPoint(block)) {
            return;
        }
        BytecodeInstruction blockStart = block.getFirstInstruction();
        Set rawIncomings = this.rawGraph.incomingEdgesOf(blockStart);
        for (ControlFlowEdge rawIncoming : rawIncomings) {
            BytecodeInstruction incomingStart = (BytecodeInstruction)this.rawGraph.getEdgeSource(rawIncoming);
            this.addRawEdge(incomingStart, block, rawIncoming);
        }
    }

    private void computeOutgoingEdgesFor(BasicBlock block) {
        if (this.isExitPoint(block)) {
            return;
        }
        BytecodeInstruction blockEnd = block.getLastInstruction();
        Set rawOutgoings = this.rawGraph.outgoingEdgesOf(blockEnd);
        for (ControlFlowEdge rawOutgoing : rawOutgoings) {
            BytecodeInstruction outgoingEnd = (BytecodeInstruction)this.rawGraph.getEdgeTarget(rawOutgoing);
            this.addRawEdge(block, outgoingEnd, rawOutgoing);
        }
    }

    protected void addBlock(BasicBlock nodeBlock) {
        if (nodeBlock == null) {
            throw new IllegalArgumentException("null given");
        }
        logger.debug("Adding block: " + nodeBlock.getName());
        if (this.containsVertex(nodeBlock)) {
            throw new IllegalArgumentException("block already added before");
        }
        if (!this.addVertex(nodeBlock)) {
            throw new IllegalStateException("internal error while addind basic block to CFG");
        }
        if (!this.containsVertex(nodeBlock)) {
            throw new IllegalStateException("expect graph to contain the given block on returning of addBlock()");
        }
        logger.debug(".. succeeded. nodeCount: " + this.vertexCount());
    }

    protected void addRawEdge(BytecodeInstruction src, BasicBlock target, ControlFlowEdge origEdge) {
        BasicBlock srcBlock = src.getBasicBlock();
        if (srcBlock == null) {
            throw new IllegalStateException("when adding an edge to a CFG it is expected to know both the src- and the target-instruction");
        }
        this.addRawEdge(srcBlock, target, origEdge);
    }

    protected void addRawEdge(BasicBlock src, BytecodeInstruction target, ControlFlowEdge origEdge) {
        BasicBlock targetBlock = target.getBasicBlock();
        if (targetBlock == null) {
            throw new IllegalStateException("when adding an edge to a CFG it is expected to know both the src- and the target-instruction");
        }
        this.addRawEdge(src, targetBlock, origEdge);
    }

    protected void addRawEdge(BasicBlock src, BasicBlock target, ControlFlowEdge origEdge) {
        if (src == null || target == null) {
            throw new IllegalArgumentException("null given");
        }
        logger.debug("Adding edge from " + src.getName() + " to " + target.getName());
        if (this.containsEdge(src, target)) {
            logger.debug("edge already contained in CFG");
            ControlFlowEdge current = (ControlFlowEdge)this.getEdge(src, target);
            if (current == null) {
                throw new IllegalStateException("expect getEdge() not to return null on parameters on which containsEdge() retruned true");
            }
            if (current.getBranchExpressionValue() && !origEdge.getBranchExpressionValue()) {
                throw new IllegalStateException("if this rawEdge was handled before i expect the old edge to have same branchExpressionValue set");
            }
            if (current.getBranchInstruction() == null ? origEdge.getBranchInstruction() != null : origEdge.getBranchInstruction() == null || !current.getBranchInstruction().equals(origEdge.getBranchInstruction())) {
                throw new IllegalStateException("if this rawEdge was handled before i expect the old edge to have same branchInstruction set");
            }
            return;
        }
        ControlFlowEdge e = new ControlFlowEdge(origEdge);
        if (!super.addEdge(src, target, e)) {
            throw new IllegalStateException("internal error while adding edge to CFG");
        }
        logger.debug(".. succeeded, edgeCount: " + this.edgeCount());
    }

    public BasicBlock getBlockOf(BytecodeInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException("null given");
        }
        if (instruction.hasBasicBlockSet()) {
            return instruction.getBasicBlock();
        }
        for (BasicBlock block : this.vertexSet()) {
            if (!block.containsInstruction(instruction)) continue;
            instruction.setBasicBlock(block);
            return block;
        }
        logger.debug("unknown instruction " + instruction.toString());
        return null;
    }

    public boolean knowsInstruction(BytecodeInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException("null given");
        }
        if (instruction.hasBasicBlockSet()) {
            return this.containsVertex(instruction.getBasicBlock());
        }
        for (BasicBlock block : this.vertexSet()) {
            if (!block.containsInstruction(instruction)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getDistance(BytecodeInstruction v1, BytecodeInstruction v2) {
        if (v1 == null || v2 == null) {
            throw new IllegalArgumentException("null given");
        }
        if (!this.knowsInstruction(v1) || !this.knowsInstruction(v2)) {
            throw new IllegalArgumentException("instructions not contained in this CFG");
        }
        BasicBlock b1 = v1.getBasicBlock();
        BasicBlock b2 = v2.getBasicBlock();
        if (b1 == null || b2 == null) {
            throw new IllegalStateException("expect CFG to contain the BasicBlock for each instruction knowsInstruction() returns true on");
        }
        return this.getDistance(b1, b2);
    }

    @Override
    public boolean isDirectSuccessor(BytecodeInstruction v1, BytecodeInstruction v2) {
        if (v1 == null || v2 == null) {
            throw new IllegalArgumentException("null given");
        }
        if (!this.knowsInstruction(v1) || !this.knowsInstruction(v2)) {
            throw new IllegalArgumentException("instructions not contained in this CFG");
        }
        BasicBlock b1 = v1.getBasicBlock();
        BasicBlock b2 = v2.getBasicBlock();
        if (b1 == null || b2 == null) {
            throw new IllegalStateException("expect CFG to contain the BasicBlock for each instruction knowsInstruction() returns true on");
        }
        return this.isDirectSuccessor(b1, b2);
    }

    public boolean isEntryPoint(BasicBlock block) {
        if (block == null) {
            throw new IllegalArgumentException("null given");
        }
        return block.containsInstruction(this.entryPoint);
    }

    public boolean isExitPoint(BasicBlock block) {
        if (block == null) {
            throw new IllegalArgumentException("null given");
        }
        for (BytecodeInstruction exitPoint : this.exitPoints) {
            if (!block.containsInstruction(exitPoint)) continue;
            return true;
        }
        return false;
    }

    public boolean belongsToMethod(BytecodeInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException("null given");
        }
        if (!this.className.equals(instruction.getClassName())) {
            return false;
        }
        return this.methodName.equals(instruction.getMethodName());
    }

    public void checkSanity() {
        logger.debug("checking sanity of CFG for " + this.methodName);
        if (this.isEmpty()) {
            throw new IllegalStateException("a CFG must contain at least one element");
        }
        for (BytecodeInstruction initInstruction : this.getInitiallyKnownInstructions()) {
            if (this.knowsInstruction(initInstruction)) continue;
            throw new IllegalStateException("expect CFG to contain all initially known instructions");
        }
        logger.debug(".. all initInstructions contained");
        this.checkInstructionsContainedOnceConstraint();
        logger.debug(".. CFG sanity ensured");
    }

    private void checkInstructionsContainedOnceConstraint() {
        for (BytecodeInstruction ins : this.rawGraph.vertexSet()) {
            if (!this.knowsInstruction(ins)) {
                throw new IllegalStateException("expect all instructions ins underlying RawCFG to be known by Actual CFG");
            }
            BasicBlock insBlock = ins.getBasicBlock();
            if (insBlock == null) {
                throw new IllegalStateException("expect ActualCFG.getBlockOf() to return non-null BasicBlocks for all instructions it knows");
            }
            for (BasicBlock block : this.vertexSet()) {
                if (block.equals(insBlock) || !block.containsInstruction(ins)) continue;
                throw new IllegalStateException("expect ActualCFG to contain exactly one BasicBlock for each original bytecode instruction, not more!");
            }
        }
    }

    void checkNodeSanity() {
        for (BasicBlock node : this.vertexSet()) {
            this.checkEntryExitPointConstraint(node);
            this.checkSingleCFGNodeConstraint(node);
            this.checkNodeMinimalityConstraint(node);
        }
        logger.debug("..all node constraints ensured");
    }

    void checkEntryExitPointConstraint(BasicBlock node) {
        int out = this.outDegreeOf(node);
        if (!this.isExitPoint(node) && out == 0) {
            throw new IllegalStateException("expect nodes without outgoing edges to be exitBlocks: " + node.toString());
        }
        int in = this.inDegreeOf(node);
        if (!this.isEntryPoint(node) && in == 0) {
            throw new IllegalStateException("expect nodes without incoming edges to be the entryBlock: " + node.toString());
        }
    }

    void checkSingleCFGNodeConstraint(BasicBlock node) {
        int out;
        int in = this.inDegreeOf(node);
        if (in + (out = this.outDegreeOf(node)) == 0 && this.vertexCount() != 1) {
            throw new IllegalStateException("node with neither child nor parent only allowed if CFG consists of a single block: " + node.toString());
        }
        if (!(this.vertexCount() != 1 || this.isEntryPoint(node) && this.isExitPoint(node))) {
            throw new IllegalStateException("if a CFG consists of a single basic block that block must be both entry and exitBlock: " + node.toString());
        }
    }

    void checkNodeMinimalityConstraint(BasicBlock node) {
        if (this.hasNPartentsMChildren(node, 1, 1)) {
            for (BasicBlock child : this.getChildren(node)) {
                if (!this.hasNPartentsMChildren(child, 1, 1)) continue;
                throw new IllegalStateException("whenever a node has exactly one child and one parent, it is expected that the same is true for either of those");
            }
            for (BasicBlock parent : this.getParents(node)) {
                if (!this.hasNPartentsMChildren(parent, 1, 1)) continue;
                throw new IllegalStateException("whenever a node has exactly one child and one parent, it is expected that the same is true for either of those");
            }
        }
    }

    @Override
    public boolean containsInstruction(BytecodeInstruction v) {
        if (v == null) {
            return false;
        }
        for (BasicBlock block : this.vertexSet()) {
            if (!block.containsInstruction(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BytecodeInstruction getInstruction(int instructionId) {
        BytecodeInstruction searchedFor = BytecodeInstructionPool.getInstance(this.rawGraph.getClassLoader()).getInstruction(this.className, this.methodName, instructionId);
        if (this.containsInstruction(searchedFor)) {
            return searchedFor;
        }
        return null;
    }

    public BytecodeInstruction getEntryPoint() {
        return this.entryPoint;
    }

    public Set<BytecodeInstruction> getExitPoints() {
        return new HashSet<BytecodeInstruction>(this.exitPoints);
    }

    public Set<BytecodeInstruction> getBranches() {
        return new HashSet<BytecodeInstruction>(this.branches);
    }

    public Set<BytecodeInstruction> getJoins() {
        return new HashSet<BytecodeInstruction>(this.joins);
    }

    @Override
    public String getCFGType() {
        return "ACFG";
    }
}

