/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs;

import java.util.HashMap;
import org.jgrapht.Graph;

public class FloydWarshall<V, E> {
    int nextIndex = 0;
    HashMap<V, Integer> indices;
    double[][] d;
    double diameter;

    public FloydWarshall(Graph<V, E> g) {
        int sz = g.vertexSet().size();
        this.d = new double[sz][sz];
        this.indices = new HashMap();
        for (V v1 : g.vertexSet()) {
            for (V v2 : g.vertexSet()) {
                if (v1 == v2) {
                    this.d[this.index(v1)][this.index(v2)] = 0.0;
                    continue;
                }
                E e = g.getEdge(v1, v2);
                if (e == null) {
                    this.d[this.index(v1)][this.index(v2)] = Double.POSITIVE_INFINITY;
                    continue;
                }
                this.d[this.index(v1)][this.index(v2)] = g.getEdgeWeight(e);
            }
        }
        for (int k = 0; k < sz; ++k) {
            for (V v1 : g.vertexSet()) {
                for (V v2 : g.vertexSet()) {
                    this.d[this.index(v1)][this.index(v2)] = Math.min(this.d[this.index(v1)][this.index(v2)], this.d[this.index(v1)][k] + this.d[k][this.index(v2)]);
                    if (Double.POSITIVE_INFINITY == this.d[this.index(v1)][this.index(v2)]) continue;
                    this.diameter = Math.max(this.diameter, this.d[this.index(v1)][this.index(v2)]);
                }
            }
        }
    }

    public double shortestDistance(V v1, V v2) {
        return this.d[this.index(v1)][this.index(v2)];
    }

    public double getDiameter() {
        return this.diameter;
    }

    private int index(V vertex) {
        Integer index = this.indices.get(vertex);
        if (index == null) {
            this.indices.put((Integer)vertex, this.nextIndex);
            index = this.nextIndex++;
        }
        return index;
    }
}

