/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mosa;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.metaheuristics.mosa.Ranking;
import org.evosuite.ga.metaheuristics.mosa.comparators.MOSADominanceComparator;
import org.evosuite.ga.metaheuristics.mosa.comparators.PreferenceSortingComparator;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RankBasedPreferenceSorting<T extends Chromosome>
implements Ranking<T> {
    private static final Logger logger = LoggerFactory.getLogger(RankBasedPreferenceSorting.class);
    private Map<Integer, List<T>> fronts = new LinkedHashMap<Integer, List<T>>();

    @Override
    public void computeRankingAssignment(List<T> solutions, Set<FitnessFunction<T>> uncovered_goals) {
        if (solutions.isEmpty()) {
            return;
        }
        this.fronts.clear();
        List<T> zero_front = this.getZeroFront(solutions, uncovered_goals);
        this.fronts.put(0, zero_front);
        if (zero_front.size() < Properties.POPULATION) {
            List new_front;
            MOSADominanceComparator<T> comparator = new MOSADominanceComparator<T>(uncovered_goals);
            ArrayList<T> remaining = new ArrayList<T>(solutions.size());
            remaining.addAll(solutions);
            remaining.removeAll(zero_front);
            int front_index = 1;
            for (int rankedSolutions = zero_front.size(); rankedSolutions < Properties.POPULATION && remaining.size() > 0; rankedSolutions += new_front.size()) {
                new_front = this.getNonDominatedSolutions(remaining, comparator);
                this.fronts.put(front_index, new_front);
                remaining.removeAll(new_front);
                ++front_index;
            }
        } else {
            ArrayList<T> remaining = new ArrayList<T>(solutions.size());
            remaining.addAll(solutions);
            remaining.removeAll(zero_front);
            this.fronts.put(1, remaining);
        }
        for (Integer index : this.fronts.keySet()) {
            for (Chromosome p : this.fronts.get(index)) {
                p.setRank(index);
            }
        }
    }

    private List<T> getZeroFront(List<T> solutionSet, Set<FitnessFunction<T>> uncovered_goals) {
        LinkedHashSet<Chromosome> zero_front = new LinkedHashSet<Chromosome>(solutionSet.size());
        for (FitnessFunction<T> f : uncovered_goals) {
            PreferenceSortingComparator<T> comp = new PreferenceSortingComparator<T>(f);
            Chromosome best = null;
            for (Chromosome test : solutionSet) {
                int flag = comp.compare(test, best);
                if (flag >= 0 && (flag != 0 || !Randomness.nextBoolean())) continue;
                best = test;
            }
            assert (best != null);
            zero_front.add(best);
        }
        ArrayList<Chromosome> list = new ArrayList<Chromosome>(zero_front.size());
        list.addAll(zero_front);
        return list;
    }

    private List<T> getNonDominatedSolutions(List<T> solutions, MOSADominanceComparator<T> comparator) {
        ArrayList<Chromosome> front = new ArrayList<Chromosome>(solutions.size());
        for (Chromosome p : solutions) {
            boolean isDominated = false;
            ArrayList<Chromosome> dominatedSolutions = new ArrayList<Chromosome>(solutions.size());
            for (Chromosome best : front) {
                int flag = comparator.compare(p, best);
                if (flag == -1) {
                    dominatedSolutions.add(best);
                }
                if (flag != 1) continue;
                isDominated = true;
            }
            if (isDominated) continue;
            front.add(p);
            front.removeAll(dominatedSolutions);
        }
        return front;
    }

    @Override
    public List<T> getSubfront(int rank) {
        List<T> subFront = this.fronts.get(rank);
        if (subFront == null) {
            subFront = new ArrayList<T>();
        }
        return subFront;
    }

    @Override
    public int getNumberOfSubfronts() {
        return this.fronts.keySet().size();
    }
}

