/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.executionmode;

import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.ClientProcess;
import org.evosuite.EvoSuite;
import org.evosuite.PackageInfo;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.TimeController;
import org.evosuite.classpath.ClassPathHacker;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.classpath.ResourceList;
import org.evosuite.executionmode.Help;
import org.evosuite.instrumentation.BytecodeInstrumentation;
import org.evosuite.result.TestGenerationResult;
import org.evosuite.result.TestGenerationResultBuilder;
import org.evosuite.rmi.MasterServices;
import org.evosuite.rmi.service.ClientNodeRemote;
import org.evosuite.runtime.util.JarPathing;
import org.evosuite.runtime.util.JavaExecCmdUtil;
import org.evosuite.shaded.org.apache.commons.cli.CommandLine;
import org.evosuite.shaded.org.apache.commons.cli.Option;
import org.evosuite.shaded.org.apache.commons.cli.Options;
import org.evosuite.shaded.org.apache.commons.io.FileUtils;
import org.evosuite.statistics.SearchStatistics;
import org.evosuite.utils.ExternalProcessHandler;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGeneration {
    private static Logger logger = LoggerFactory.getLogger(TestGeneration.class);

    public static List<List<TestGenerationResult>> executeTestGeneration(Options options, List<String> javaOpts, CommandLine line) {
        Properties.Strategy strategy = TestGeneration.getChosenStrategy(javaOpts, line);
        if (strategy == null) {
            strategy = Properties.Strategy.EVOSUITE;
        }
        ArrayList<List<TestGenerationResult>> results = new ArrayList<List<TestGenerationResult>>();
        if (line.getOptions().length == 0) {
            Help.execute(options);
            return results;
        }
        String cp = ClassPathHandler.getInstance().getTargetProjectClasspath();
        if (cp == null || cp.isEmpty()) {
            LoggingUtils.getEvoLogger().error("No classpath has been defined for the target project.\nOn the command line you can set it with the -projectCP option\n");
            Help.execute(options);
            return results;
        }
        if (line.hasOption("class")) {
            results.addAll(TestGeneration.generateTests(strategy, line.getOptionValue("class"), javaOpts));
        } else if (line.hasOption("prefix")) {
            results.addAll(TestGeneration.generateTestsPrefix(strategy, line.getOptionValue("prefix"), javaOpts));
        } else if (line.hasOption("target")) {
            String target = line.getOptionValue("target");
            results.addAll(TestGeneration.generateTestsTarget(strategy, target, javaOpts));
        } else if (EvoSuite.hasLegacyTargets()) {
            results.addAll(TestGeneration.generateTestsLegacy(strategy, javaOpts));
        } else {
            LoggingUtils.getEvoLogger().error("Please specify either target class ('-class' option), prefix ('-prefix' option), or classpath entry ('-target' option)\n");
            Help.execute(options);
        }
        return results;
    }

    private static List<List<TestGenerationResult>> generateTestsLegacy(Properties.Strategy strategy, List<String> args) {
        ArrayList<List<TestGenerationResult>> results = new ArrayList<List<TestGenerationResult>>();
        ClassPathHandler.getInstance().getTargetProjectClasspath();
        LoggingUtils.getEvoLogger().info("* Using .task files in " + Properties.OUTPUT_DIR + " [deprecated]");
        File directory = new File(Properties.OUTPUT_DIR);
        String[] extensions = new String[]{"task"};
        for (File file : FileUtils.listFiles(directory, extensions, false)) {
            results.addAll(TestGeneration.generateTests(strategy, file.getName().replace(".task", ""), args));
        }
        return results;
    }

    public static Option[] getOptions() {
        return new Option[]{new Option("generateSuite", "use whole suite generation. This is the default behavior"), new Option("generateTests", "use individual test generation (old approach for reference purposes)"), new Option("generateRandom", "use random test generation"), new Option("generateNumRandom", true, "generate fixed number of random tests"), new Option("regressionSuite", "generate a regression test suite"), new Option("regressionTests", "generate a regression test suite of individual tests"), new Option("generateMOSuite", "use many objective test generation (MOSA). "), new Option("generateSuiteUsingDSE", "use Dynamic Symbolic Execution to generate test suite")};
    }

    private static Properties.Strategy getChosenStrategy(List<String> javaOpts, CommandLine line) {
        Properties.Strategy strategy = null;
        if (javaOpts.contains("-Dstrategy=" + Properties.Strategy.ENTBUG.name()) && line.hasOption("generateTests")) {
            strategy = Properties.Strategy.ENTBUG;
        } else if (javaOpts.contains("-Dstrategy=" + Properties.Strategy.NOVELTY.name())) {
            strategy = Properties.Strategy.NOVELTY;
        } else if (line.hasOption("generateTests")) {
            strategy = Properties.Strategy.ONEBRANCH;
        } else if (line.hasOption("generateSuite")) {
            strategy = Properties.Strategy.EVOSUITE;
        } else if (line.hasOption("generateRandom")) {
            strategy = Properties.Strategy.RANDOM;
        } else if (line.hasOption("regressionSuite")) {
            strategy = Properties.Strategy.REGRESSION;
        } else if (line.hasOption("generateNumRandom")) {
            strategy = Properties.Strategy.RANDOM_FIXED;
            javaOpts.add("-Dnum_random_tests=" + line.getOptionValue("generateNumRandom"));
        } else if (line.hasOption("generateMOSuite")) {
            strategy = Properties.Strategy.MOSUITE;
        } else if (line.hasOption("generateSuiteUsingDSE")) {
            strategy = Properties.Strategy.DSE;
        }
        return strategy;
    }

    private static List<List<TestGenerationResult>> generateTestsPrefix(Properties.Strategy strategy, String prefix, List<String> args) {
        ArrayList<List<TestGenerationResult>> results = new ArrayList<List<TestGenerationResult>>();
        String cp = ClassPathHandler.getInstance().getTargetProjectClasspath();
        HashSet<String> classes = new HashSet<String>();
        for (String classPathElement : cp.split(File.pathSeparator)) {
            classes.addAll(ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllClasses(classPathElement, prefix, false));
            try {
                ClassPathHacker.addFile(classPathElement);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            if (Properties.INSTRUMENT_CONTEXT || Properties.INHERITANCE_FILE.isEmpty()) {
                String inheritanceFile = EvoSuite.generateInheritanceTree(cp);
                args.add("-Dinheritance_file=" + inheritanceFile);
            }
        }
        catch (IOException e) {
            LoggingUtils.getEvoLogger().info("* Error while traversing classpath: " + e);
            return results;
        }
        LoggingUtils.getEvoLogger().info("* Found " + classes.size() + " matching classes for prefix " + prefix);
        for (String sut : classes) {
            block10: {
                try {
                    if (ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).isClassAnInterface(sut)) {
                        LoggingUtils.getEvoLogger().info("* Skipping interface: " + sut);
                    }
                    break block10;
                }
                catch (IOException e) {
                    LoggingUtils.getEvoLogger().info("Could not load class: " + sut);
                }
                continue;
            }
            LoggingUtils.getEvoLogger().info("* Current class: " + sut);
            results.addAll(TestGeneration.generateTests(Properties.Strategy.EVOSUITE, sut, args));
        }
        return results;
    }

    private static boolean findTargetClass(String target) {
        if (ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).hasClass(target)) {
            return true;
        }
        LoggingUtils.getEvoLogger().info("* Unknown class: " + target + ". Be sure its full qualifying name  is correct and the classpath is properly set with '-projectCP'");
        return false;
    }

    private static List<List<TestGenerationResult>> generateTests(Properties.Strategy strategy, String target, List<String> args) {
        String logDir;
        ExternalProcessHandler handler;
        int port;
        LoggingUtils.getEvoLogger().info("* Going to generate test cases for class: " + target);
        if (!TestGeneration.findTargetClass(target)) {
            return Arrays.asList(Arrays.asList(TestGenerationResultBuilder.buildErrorResult("Could not find target class")));
        }
        if (!BytecodeInstrumentation.checkIfCanInstrument(target)) {
            throw new IllegalArgumentException("Cannot consider " + target + " because it belongs to one of the packages EvoSuite cannot currently handle");
        }
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(JavaExecCmdUtil.getJavaBinExecutablePath(true));
        TestGeneration.handleClassPath(cmdLine);
        if (Properties.SPAWN_PROCESS_MANAGER_PORT != null) {
            cmdLine.add("-Dspawn_process_manager_port=" + Properties.SPAWN_PROCESS_MANAGER_PORT);
        }
        if ((port = (handler = new ExternalProcessHandler()).openServer()) <= 0) {
            throw new RuntimeException("Not possible to start RMI service");
        }
        cmdLine.add("-Dprocess_communication_port=" + port);
        cmdLine.add("-Dinline=true");
        if (Properties.HEADLESS_MODE) {
            cmdLine.add("-Djava.awt.headless=true");
        }
        cmdLine.add("-Dlogback.configurationFile=" + LoggingUtils.getLogbackFileName());
        cmdLine.add("-Dlog4j.configuration=SUT.log4j.properties");
        if (Properties.LOG_LEVEL != null) {
            cmdLine.add("-Dlog.level=" + Properties.LOG_LEVEL);
        }
        if (Properties.LOG_TARGET != null) {
            cmdLine.add("-Dlog.target=" + Properties.LOG_TARGET);
        }
        if ((logDir = System.getProperty("evosuite.log.folder")) != null) {
            cmdLine.add(" -Devosuite.log.folder=" + logDir);
        }
        cmdLine.add("-Djava.library.path=lib");
        if (Properties.DEBUG) {
            cmdLine.add("-Ddebug=true");
            cmdLine.add("-Xdebug");
            cmdLine.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + Properties.PORT);
            LoggingUtils.getEvoLogger().info("* Waiting for remote debugger to connect on port " + Properties.PORT + "...");
        }
        if (!Properties.PROFILE.isEmpty()) {
            File agentFile = new File(Properties.PROFILE);
            if (!agentFile.exists()) {
                LoggingUtils.getEvoLogger().info("* Error: " + Properties.PROFILE + " not found");
            } else {
                cmdLine.add("-agentpath:" + Properties.PROFILE);
                LoggingUtils.getEvoLogger().info("* Using profiling agent " + Properties.PROFILE);
            }
        }
        if (Properties.JMC) {
            cmdLine.add("-XX:+UnlockCommercialFeatures");
            cmdLine.add("-XX:+FlightRecorder");
            cmdLine.add("-Dcom.sun.management.jmxremote");
            cmdLine.add("-Dcom.sun.management.jmxremote.autodiscovery");
            cmdLine.add("-Dcom.sun.management.jmxremote.authenticate=false");
            cmdLine.add("-Dcom.sun.management.jmxremote.ssl=false");
        }
        cmdLine.add("-XX:MaxJavaStackTraceDepth=1000000");
        cmdLine.add("-XX:+StartAttachListener");
        for (String arg : args) {
            if (arg.startsWith("-DCP=")) continue;
            cmdLine.add(arg);
        }
        switch (strategy) {
            case EVOSUITE: {
                cmdLine.add("-Dstrategy=EvoSuite");
                break;
            }
            case ONEBRANCH: {
                cmdLine.add("-Dstrategy=OneBranch");
                break;
            }
            case RANDOM: {
                cmdLine.add("-Dstrategy=Random");
                break;
            }
            case RANDOM_FIXED: {
                cmdLine.add("-Dstrategy=Random_Fixed");
                break;
            }
            case REGRESSION: {
                cmdLine.add("-Dstrategy=Regression");
                break;
            }
            case ENTBUG: {
                cmdLine.add("-Dstrategy=EntBug");
                break;
            }
            case MOSUITE: {
                cmdLine.add("-Dstrategy=MOSuite");
                break;
            }
            case DSE: {
                cmdLine.add("-Dstrategy=Dynamic_Symbolic_Execution");
                break;
            }
            case NOVELTY: {
                cmdLine.add("-Dstrategy=Novelty");
                break;
            }
            default: {
                throw new RuntimeException("Unsupported strategy: " + (Object)((Object)strategy));
            }
        }
        cmdLine.add("-DTARGET_CLASS=" + target);
        if (Properties.PROJECT_PREFIX != null) {
            cmdLine.add("-DPROJECT_PREFIX=" + Properties.PROJECT_PREFIX);
        }
        cmdLine.add(ClientProcess.class.getName());
        Properties.getInstance();
        Properties.TARGET_CLASS = target;
        Properties.PROCESS_COMMUNICATION_PORT = port;
        String definedEAforClient = null;
        String definedEAforSUT = null;
        String DISABLE_ASSERTIONS_EVO = "-da:" + PackageInfo.getEvoSuitePackage() + "...";
        String ENABLE_ASSERTIONS_EVO = "-ea:" + PackageInfo.getEvoSuitePackage() + "...";
        String DISABLE_ASSERTIONS_SUT = "-da:" + Properties.PROJECT_PREFIX + "...";
        String ENABLE_ASSERTIONS_SUT = "-ea:" + Properties.PROJECT_PREFIX + "...";
        for (String s : cmdLine) {
            if (s.startsWith("-Denable_asserts_for_evosuite")) {
                if (s.endsWith("false")) {
                    definedEAforClient = DISABLE_ASSERTIONS_EVO;
                } else if (s.endsWith("true")) {
                    definedEAforClient = ENABLE_ASSERTIONS_EVO;
                }
            }
            if (!s.startsWith("-Denable_asserts_for_sut")) continue;
            if (s.endsWith("false")) {
                definedEAforSUT = DISABLE_ASSERTIONS_SUT;
                continue;
            }
            if (!s.endsWith("true")) continue;
            definedEAforSUT = ENABLE_ASSERTIONS_SUT;
        }
        if (definedEAforSUT == null) {
            definedEAforSUT = Properties.ENABLE_ASSERTS_FOR_SUT ? ENABLE_ASSERTIONS_SUT : DISABLE_ASSERTIONS_SUT;
        }
        if (definedEAforClient == null) {
            definedEAforClient = Properties.ENABLE_ASSERTS_FOR_EVOSUITE ? ENABLE_ASSERTIONS_EVO : DISABLE_ASSERTIONS_EVO;
        }
        if (definedEAforClient.equals(ENABLE_ASSERTIONS_EVO)) {
            cmdLine.add(1, definedEAforClient);
        }
        if (definedEAforSUT.equals(ENABLE_ASSERTIONS_SUT)) {
            cmdLine.add(1, definedEAforSUT);
        }
        LoggingUtils logUtils = new LoggingUtils();
        if (!Properties.CLIENT_ON_THREAD) {
            boolean logServerStarted = logUtils.startLogServer();
            if (!logServerStarted) {
                logger.error("Cannot start the log server");
                return null;
            }
            int logPort = logUtils.getLogServerPort();
            cmdLine.add(1, "-Dmaster_log_port=" + logPort);
            cmdLine.add(1, "-Devosuite.log.appender=CLIENT");
        }
        String[] newArgs = cmdLine.toArray(new String[cmdLine.size()]);
        for (String entry : ClassPathHandler.getInstance().getTargetProjectClasspath().split(File.pathSeparator)) {
            try {
                ClassPathHacker.addFile(entry);
            }
            catch (IOException e) {
                LoggingUtils.getEvoLogger().info("* Error while adding classpath entry: " + entry);
            }
        }
        handler.setBaseDir(EvoSuite.base_dir_path);
        if (handler.startProcess(newArgs)) {
            Set<ClientNodeRemote> clients = null;
            try {
                clients = MasterServices.getInstance().getMasterNode().getClientsOnceAllConnected(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (clients == null) {
                logger.error("Not possible to access to clients. Clients' state: " + handler.getProcessState() + ". Master registry port: " + MasterServices.getInstance().getRegistryPort());
            } else {
                for (ClientNodeRemote client : clients) {
                    try {
                        client.startNewSearch();
                    }
                    catch (RemoteException e) {
                        logger.error("Error in starting clients", e);
                    }
                }
                int time = TimeController.getInstance().calculateForHowLongClientWillRunInSeconds();
                handler.waitForResult(time * 1000);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (Properties.CLIENT_ON_THREAD) {
                handler.stopAndWaitForClientOnThread(10000L);
            }
            handler.killProcess();
        } else {
            LoggingUtils.getEvoLogger().info("* Could not connect to client process");
        }
        boolean hasFailed = false;
        if (Properties.NEW_STATISTICS) {
            if (MasterServices.getInstance().getMasterNode() == null) {
                logger.error("Cannot write results as RMI master node is not running");
                hasFailed = true;
            } else {
                boolean written = SearchStatistics.getInstance().writeStatistics();
                hasFailed = !written;
            }
        }
        List<List<TestGenerationResult>> results = SearchStatistics.getInstance().getTestGenerationResults();
        SearchStatistics.clearInstance();
        handler.closeServer();
        if (Properties.CLIENT_ON_THREAD) {
            handler.stopAndWaitForClientOnThread(10000L);
        } else {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logUtils.closeLogServer();
        }
        logger.debug("Master process has finished to wait for client");
        if (hasFailed) {
            logger.error("failed to write statistics data");
            return new ArrayList<List<TestGenerationResult>>();
        }
        return results;
    }

    private static void handleClassPath(List<String> cmdLine) {
        String classPath = ClassPathHandler.getInstance().getEvoSuiteClassPath();
        String projectCP = ClassPathHandler.getInstance().getTargetProjectClasspath();
        if (!classPath.isEmpty() && !projectCP.isEmpty()) {
            classPath = classPath + File.pathSeparator;
        }
        if (!projectCP.isEmpty()) {
            classPath = classPath + projectCP;
        }
        cmdLine.add("-cp");
        String pathingJar = JarPathing.createJarPathing(classPath);
        cmdLine.add(pathingJar);
        if (projectCP.isEmpty()) {
            projectCP = classPath;
        }
        String projectCPFilePath = ClassPathHandler.writeClasspathToFile(projectCP);
        cmdLine.add("-DCP_file_path=" + projectCPFilePath);
    }

    private static List<List<TestGenerationResult>> generateTestsTarget(Properties.Strategy strategy, String target, List<String> args) {
        ArrayList<List<TestGenerationResult>> results = new ArrayList<List<TestGenerationResult>>();
        String cp = ClassPathHandler.getInstance().getTargetProjectClasspath();
        Set<String> classes = ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllClasses(target, false);
        LoggingUtils.getEvoLogger().info("* Found " + classes.size() + " matching classes in target " + target);
        try {
            ClassPathHacker.addFile(target);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (Properties.INSTRUMENT_CONTEXT || Properties.INHERITANCE_FILE.isEmpty()) {
                String inheritanceFile = EvoSuite.generateInheritanceTree(cp);
                args.add("-Dinheritance_file=" + inheritanceFile);
            }
        }
        catch (IOException e) {
            LoggingUtils.getEvoLogger().info("* Error while traversing classpath: " + e);
            return results;
        }
        for (String sut : classes) {
            block9: {
                try {
                    if (ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).isClassAnInterface(sut)) {
                        LoggingUtils.getEvoLogger().info("* Skipping interface: " + sut);
                    }
                    break block9;
                }
                catch (IOException e) {
                    LoggingUtils.getEvoLogger().info("Could not load class: " + sut);
                }
                continue;
            }
            LoggingUtils.getEvoLogger().info("* Current class: " + sut);
            results.addAll(TestGeneration.generateTests(strategy, sut, args));
        }
        return results;
    }
}

