/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.statement;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.branch.BranchCoverageFactory;
import org.evosuite.coverage.branch.BranchCoverageTestFitness;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.graphs.cfg.ControlDependency;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;

public class StatementCoverageTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = 4609519536866911970L;
    protected transient BytecodeInstruction goalInstruction;
    protected List<BranchCoverageTestFitness> branchFitnesses = new ArrayList<BranchCoverageTestFitness>();
    BranchCoverageTestFitness lastCoveringFitness = null;

    public StatementCoverageTestFitness(BytecodeInstruction goalInstruction) {
        if (goalInstruction == null) {
            throw new IllegalArgumentException("null given");
        }
        this.goalInstruction = goalInstruction;
        Set<ControlDependency> cds = goalInstruction.getControlDependencies();
        for (ControlDependency cd : cds) {
            BranchCoverageTestFitness fitness = BranchCoverageFactory.createBranchCoverageTestFitness(cd);
            this.branchFitnesses.add(fitness);
        }
        if (goalInstruction.isRootBranchDependent()) {
            this.branchFitnesses.add(BranchCoverageFactory.createRootBranchTestFitness(goalInstruction));
        }
        if (cds.isEmpty() && !goalInstruction.isRootBranchDependent()) {
            throw new IllegalStateException("expect control dependencies to be empty only for root dependent instructions: " + this.toString());
        }
        if (this.branchFitnesses.isEmpty()) {
            throw new IllegalStateException("an instruction is at least on the root branch of it's method");
        }
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        if (this.branchFitnesses.isEmpty()) {
            throw new IllegalStateException("expect to know at least one fitness for goalInstruction");
        }
        if (result.hasTimeout() || result.hasTestException()) {
            this.updateIndividual(this, individual, Double.MAX_VALUE);
            return Double.MAX_VALUE;
        }
        double r = Double.MAX_VALUE;
        for (BranchCoverageTestFitness branchFitness : this.branchFitnesses) {
            double newFitness = branchFitness.getFitness(individual, result);
            if (newFitness == 0.0) {
                this.lastCoveringFitness = branchFitness;
                return 0.0;
            }
            if (!(newFitness < r)) continue;
            r = newFitness;
        }
        this.lastCoveringFitness = null;
        this.updateIndividual(this, individual, r);
        return r;
    }

    public BranchCoverageTestFitness getLastCoveringFitness() {
        return this.lastCoveringFitness;
    }

    public String toString() {
        return "Statement Goal: " + this.goalInstruction.getMethodName() + " " + this.goalInstruction.toString();
    }

    public String explain() {
        StringBuilder r = new StringBuilder();
        r.append("StatementCoverageTestFitness for ");
        r.append(this.goalInstruction.toString());
        r.append(" in " + this.goalInstruction.getMethodName());
        r.append("\n");
        r.append("CDS:\n");
        for (BranchCoverageTestFitness branchFitness : this.branchFitnesses) {
            r.append("\t" + branchFitness.toString());
        }
        return r.toString();
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other instanceof StatementCoverageTestFitness) {
            return this.goalInstruction.compareTo(((StatementCoverageTestFitness)other).goalInstruction);
        }
        return this.compareClassName(other);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.goalInstruction.getInstructionId();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatementCoverageTestFitness other = (StatementCoverageTestFitness)obj;
        return !(this.goalInstruction == null ? other.goalInstruction != null : !this.goalInstruction.equals(other.goalInstruction));
    }

    @Override
    public String getTargetClass() {
        return this.goalInstruction.getClassName();
    }

    @Override
    public String getTargetMethod() {
        return this.goalInstruction.getMethodName();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.goalInstruction.getClassName());
        oos.writeObject(this.goalInstruction.getMethodName());
        oos.writeInt(this.goalInstruction.getInstructionId());
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        String className = (String)ois.readObject();
        String methodName = (String)ois.readObject();
        int instructionId = ois.readInt();
        BytecodeInstructionPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getInstruction(className, methodName, instructionId);
    }
}

