/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.mutation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.ga.stoppingconditions.StoppingConditionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutationTimeoutStoppingCondition
extends StoppingConditionImpl {
    private final Logger logger = LoggerFactory.getLogger(MutationTimeoutStoppingCondition.class);
    public static Map<Mutation, Integer> timeouts = new HashMap<Mutation, Integer>();
    private static final long serialVersionUID = -7347443938884126325L;
    private static int timeout = 0;
    private static boolean hasException = false;
    private static Set<Mutation> exceptions = new HashSet<Mutation>();
    private static int MAX_TIMEOUTS = Properties.MUTATION_TIMEOUTS;
    private static Set<Mutation> disabled = new HashSet<Mutation>();

    public static boolean isDisabled(Mutation mutation) {
        return disabled.contains(mutation);
    }

    @Override
    public long getCurrentValue() {
        if (Properties.STRATEGY != Properties.Strategy.ONEBRANCH) {
            return 0L;
        }
        return timeout;
    }

    @Override
    public boolean isFinished() {
        this.logger.debug("Number of timeouts registered for this mutant: " + timeouts + "/" + MAX_TIMEOUTS);
        if (Properties.STRATEGY != Properties.Strategy.ONEBRANCH) {
            return false;
        }
        if (timeout >= MAX_TIMEOUTS) {
            this.logger.debug("Mutation timed out, stopping search");
        }
        return timeout >= MAX_TIMEOUTS || hasException;
    }

    @Override
    public void reset() {
        if (Properties.STRATEGY != Properties.Strategy.ONEBRANCH) {
            timeouts = new HashMap<Mutation, Integer>();
            exceptions = new HashSet<Mutation>();
        } else {
            timeout = 0;
            hasException = false;
        }
    }

    @Override
    public void setLimit(long limit) {
        MAX_TIMEOUTS = (int)limit;
    }

    @Override
    public long getLimit() {
        return MAX_TIMEOUTS;
    }

    public static void timeOut(Mutation mutation) {
        if (Properties.STRATEGY != Properties.Strategy.ONEBRANCH) {
            int t = 1;
            if (timeouts.containsKey(mutation)) {
                t = timeouts.get(mutation) + 1;
            }
            timeouts.put(mutation, t);
            if (t >= MAX_TIMEOUTS) {
                disabled.add(mutation);
            }
        } else if (++timeout >= MAX_TIMEOUTS) {
            disabled.add(mutation);
        }
    }

    public static void raisedException(Mutation mutation) {
        if (Properties.STRATEGY != Properties.Strategy.ONEBRANCH) {
            exceptions.add(mutation);
        } else {
            hasException = true;
        }
        disabled.add(mutation);
    }

    @Override
    public void forceCurrentValue(long value) {
        if (Properties.STRATEGY == Properties.Strategy.ONEBRANCH) {
            timeout = (int)value;
        }
    }

    public static void resetStatic() {
        timeouts.clear();
        exceptions.clear();
        disabled.clear();
        timeout = 0;
        hasException = false;
    }
}

