/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.io.output;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.assertion.CheapPurityAnalyzer;
import org.evosuite.assertion.Inspector;
import org.evosuite.assertion.InspectorManager;
import org.evosuite.coverage.MethodNameMatcher;
import org.evosuite.coverage.io.output.OutputCoverageGoal;
import org.evosuite.coverage.io.output.OutputCoverageTestFitness;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.setup.TestClusterUtils;
import org.evosuite.setup.TestUsageChecker;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.testsuite.AbstractFitnessFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputCoverageFactory
extends AbstractFitnessFactory<OutputCoverageTestFitness> {
    private static final Logger logger = LoggerFactory.getLogger(OutputCoverageFactory.class);

    @Override
    public List<OutputCoverageTestFitness> getCoverageGoals() {
        ArrayList<OutputCoverageTestFitness> goals = new ArrayList<OutputCoverageTestFitness>();
        long start = System.currentTimeMillis();
        String targetClass = Properties.TARGET_CLASS;
        MethodNameMatcher matcher = new MethodNameMatcher();
        for (String className : BytecodeInstructionPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).knownClasses()) {
            if (!targetClass.equals("") && !className.endsWith(targetClass)) continue;
            block8: for (Method method : TestClusterUtils.getClass(className).getDeclaredMethods()) {
                String methodName = method.getName() + Type.getMethodDescriptor(method);
                if (!TestUsageChecker.canUse(method) || !matcher.methodMatches(methodName) || methodName.equals("hashCode()I")) continue;
                logger.info("Adding goals for method " + className + "." + methodName);
                Type returnType = Type.getReturnType(method);
                switch (returnType.getSort()) {
                    case 1: {
                        goals.add(OutputCoverageFactory.createGoal(className, methodName, returnType, "True"));
                        goals.add(OutputCoverageFactory.createGoal(className, methodName, returnType, "False"));
                        continue block8;
                    }
                    case 2: {
                        goals.add(OutputCoverageFactory.createGoal(className, methodName, returnType, "AlphabeticChar"));
                        goals.add(OutputCoverageFactory.createGoal(className, methodName, returnType, "Digit"));
                        goals.add(OutputCoverageFactory.createGoal(className, methodName, returnType, "OtherChar"));
                        continue block8;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        goals.add(OutputCoverageFactory.createGoal(className, methodName, returnType, "Negative"));
                        goals.add(OutputCoverageFactory.createGoal(className, methodName, returnType, "Zero"));
                        goals.add(OutputCoverageFactory.createGoal(className, methodName, returnType, "Positive"));
                        continue block8;
                    }
                    case 9: {
                        goals.add(OutputCoverageFactory.createGoal(className, methodName, returnType, "Null"));
                        goals.add(OutputCoverageFactory.createGoal(className, methodName, returnType, "EmptyArray"));
                        goals.add(OutputCoverageFactory.createGoal(className, methodName, returnType, "NonEmptyArray"));
                        continue block8;
                    }
                    case 10: {
                        goals.add(OutputCoverageFactory.createGoal(className, methodName, returnType, "Null"));
                        if (returnType.getClassName().equals("java.lang.String")) {
                            goals.add(OutputCoverageFactory.createGoal(className, methodName, returnType, "EmptyString"));
                            goals.add(OutputCoverageFactory.createGoal(className, methodName, returnType, "NonEmptyString"));
                            continue block8;
                        }
                        boolean observerGoalsAdded = false;
                        Class<?> returnClazz = method.getReturnType();
                        for (Inspector inspector : InspectorManager.getInstance().getInspectors(returnClazz)) {
                            String insp = inspector.getMethodCall() + Type.getMethodDescriptor(inspector.getMethod());
                            Type t = Type.getReturnType(inspector.getMethod());
                            if (t.getSort() == 1) {
                                goals.add(OutputCoverageFactory.createGoal(className, methodName, returnType, "NonNull:" + returnType.getClassName() + ":" + insp + ":" + "True"));
                                goals.add(OutputCoverageFactory.createGoal(className, methodName, returnType, "NonNull:" + returnType.getClassName() + ":" + insp + ":" + "False"));
                                observerGoalsAdded = true;
                                continue;
                            }
                            if (!Arrays.asList(3, 4, 5, 6, 7, 8).contains(t.getSort())) continue;
                            goals.add(OutputCoverageFactory.createGoal(className, methodName, returnType, "NonNull:" + returnType.getClassName() + ":" + insp + ":" + "Negative"));
                            goals.add(OutputCoverageFactory.createGoal(className, methodName, returnType, "NonNull:" + returnType.getClassName() + ":" + insp + ":" + "Zero"));
                            goals.add(OutputCoverageFactory.createGoal(className, methodName, returnType, "NonNull:" + returnType.getClassName() + ":" + insp + ":" + "Positive"));
                            observerGoalsAdded = true;
                        }
                        if (observerGoalsAdded) continue block8;
                        goals.add(OutputCoverageFactory.createGoal(className, methodName, returnType, "NonNull"));
                        continue block8;
                    }
                }
            }
        }
        goalComputationTime = System.currentTimeMillis() - start;
        return goals;
    }

    public static OutputCoverageTestFitness createGoal(String className, String methodName, Type returnType, String suffix) {
        return new OutputCoverageTestFitness(new OutputCoverageGoal(className, methodName, returnType, suffix));
    }

    public static List<String> getInspectors(String className) {
        List<String> pureMethods = CheapPurityAnalyzer.getInstance().getPureMethods(className);
        ArrayList<String> inspectors = new ArrayList<String>();
        for (String pm : pureMethods) {
            if (Type.getArgumentTypes(pm.substring(pm.indexOf(40))).length != 0 || pm.substring(0, pm.indexOf("(")).equals("<clinit>")) continue;
            inspectors.add(pm);
        }
        return inspectors;
    }
}

