/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.io.input;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.MethodNameMatcher;
import org.evosuite.coverage.io.input.InputCoverageGoal;
import org.evosuite.coverage.io.input.InputCoverageTestFitness;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.setup.TestClusterUtils;
import org.evosuite.setup.TestUsageChecker;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.testsuite.AbstractFitnessFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputCoverageFactory
extends AbstractFitnessFactory<InputCoverageTestFitness> {
    private static final Logger logger = LoggerFactory.getLogger(InputCoverageFactory.class);

    @Override
    public List<InputCoverageTestFitness> getCoverageGoals() {
        ArrayList<InputCoverageTestFitness> goals = new ArrayList<InputCoverageTestFitness>();
        long start = System.currentTimeMillis();
        String targetClass = Properties.TARGET_CLASS;
        MethodNameMatcher matcher = new MethodNameMatcher();
        for (String className : BytecodeInstructionPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).knownClasses()) {
            if (!targetClass.equals("") && !className.endsWith(targetClass)) continue;
            for (Method method : TestClusterUtils.getClass(className).getDeclaredMethods()) {
                String methodName = method.getName() + Type.getMethodDescriptor(method);
                if (!TestUsageChecker.canUse(method) || !matcher.methodMatches(methodName)) continue;
                logger.info("Adding input goals for method " + className + "." + methodName);
                Type[] argumentTypes = Type.getArgumentTypes(method);
                Class<?>[] argumentClasses = method.getParameterTypes();
                block9: for (int i = 0; i < argumentTypes.length; ++i) {
                    Type argType = argumentTypes[i];
                    switch (argType.getSort()) {
                        case 1: {
                            goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "True"));
                            goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "False"));
                            continue block9;
                        }
                        case 2: {
                            goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "AlphabeticChar"));
                            goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "Digit"));
                            goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "OtherChar"));
                            continue block9;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "Negative"));
                            goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "Zero"));
                            goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "Positive"));
                            continue block9;
                        }
                        case 9: {
                            goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "Null"));
                            goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "EmptyArray"));
                            goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "NonEmptyArray"));
                            continue block9;
                        }
                        case 10: {
                            goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "Null"));
                            if (argType.getClassName().equals("java.lang.String")) {
                                goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "EmptyString"));
                                goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "NonEmptyString"));
                                continue block9;
                            }
                            if (List.class.isAssignableFrom(argumentClasses[i])) {
                                goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "EmptyList"));
                                goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "NonEmptyList"));
                                continue block9;
                            }
                            if (Set.class.isAssignableFrom(argumentClasses[i])) {
                                goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "EmptySet"));
                                goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "NonEmptySet"));
                                continue block9;
                            }
                            if (Map.class.isAssignableFrom(argumentClasses[i])) {
                                goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "EmptyMap"));
                                goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "NonEmptyMap"));
                                continue block9;
                            }
                            goals.add(InputCoverageFactory.createGoal(className, methodName, i, argType, "NonNull"));
                            continue block9;
                        }
                    }
                }
            }
        }
        goalComputationTime = System.currentTimeMillis() - start;
        return goals;
    }

    public static InputCoverageTestFitness createGoal(String className, String methodName, int argIndex, Type argType, String descriptor) {
        return new InputCoverageTestFitness(new InputCoverageGoal(className, methodName, argIndex, argType, descriptor));
    }
}

