/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.dataflow.analysis;

import org.evosuite.graphs.ccfg.CCFGMethodCallNode;
import org.evosuite.graphs.cfg.BytecodeInstruction;

public class MethodCall {
    private static int invocations = 0;
    private final CCFGMethodCallNode methodCall;
    private final int invocationNumber;
    private final String calledMethod;

    public MethodCall(CCFGMethodCallNode methodCall, String calledMethod) {
        this.methodCall = methodCall;
        this.invocationNumber = ++invocations;
        this.calledMethod = calledMethod;
    }

    public boolean isInitialMethodCall() {
        return this.methodCall == null;
    }

    public boolean isMethodCallFor(BytecodeInstruction callInstruction) {
        if (this.methodCall == null) {
            return callInstruction == null;
        }
        return this.methodCall.getCallInstruction().equals(callInstruction);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.invocationNumber;
        result = 31 * result + (this.methodCall == null ? 0 : this.methodCall.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodCall other = (MethodCall)obj;
        if (this.invocationNumber != other.invocationNumber) {
            return false;
        }
        return !(this.methodCall == null ? other.methodCall != null : !this.methodCall.equals(other.methodCall));
    }

    public String toString() {
        if (this.methodCall == null) {
            return "initCall for " + this.calledMethod + " " + this.invocationNumber;
        }
        return this.methodCall.getCalledMethod() + " " + this.invocationNumber;
    }

    public String getCalledMethodName() {
        return this.calledMethod;
    }

    public static MethodCall constructForCallNode(CCFGMethodCallNode callNode) {
        if (callNode == null) {
            throw new IllegalArgumentException("given call node was null");
        }
        return new MethodCall(callNode, callNode.getCalledMethod());
    }
}

