/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.branch;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.coverage.branch.OnlyBranchCoverageFactory;
import org.evosuite.coverage.branch.OnlyBranchCoverageTestFitness;
import org.evosuite.ga.archive.Archive;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlyBranchCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = 2991632394620406243L;
    private static final Logger logger = LoggerFactory.getLogger(TestSuiteFitnessFunction.class);
    public int totalBranches;
    public int totalGoals;
    private final Set<Integer> branchesId;
    public int maxCoveredBranches = 0;
    public double bestFitness = Double.MAX_VALUE;
    private final Map<Integer, TestFitnessFunction> branchCoverageTrueMap = new LinkedHashMap<Integer, TestFitnessFunction>();
    private final Map<Integer, TestFitnessFunction> branchCoverageFalseMap = new LinkedHashMap<Integer, TestFitnessFunction>();
    private final Set<Integer> toRemoveBranchesT = new LinkedHashSet<Integer>();
    private final Set<Integer> toRemoveBranchesF = new LinkedHashSet<Integer>();
    private final Set<Integer> removedBranchesT = new LinkedHashSet<Integer>();
    private final Set<Integer> removedBranchesF = new LinkedHashSet<Integer>();

    public OnlyBranchCoverageSuiteFitness() {
        String prefix = Properties.TARGET_CLASS_PREFIX;
        if (prefix.isEmpty()) {
            prefix = Properties.TARGET_CLASS;
        }
        this.totalBranches = BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getBranchCountForPrefix(prefix);
        this.branchesId = new LinkedHashSet<Integer>();
        this.totalGoals = 2 * this.totalBranches;
        logger.info("Total branch coverage goals: " + this.totalGoals);
        logger.info("Total branches: " + this.totalBranches);
        this.determineCoverageGoals();
        assert (this.totalGoals == this.branchCoverageTrueMap.size() + this.branchCoverageFalseMap.size());
    }

    private void determineCoverageGoals() {
        List<OnlyBranchCoverageTestFitness> goals = new OnlyBranchCoverageFactory().getCoverageGoals();
        for (OnlyBranchCoverageTestFitness goal : goals) {
            if (Properties.TEST_ARCHIVE) {
                Archive.getArchiveInstance().addTarget(goal);
            }
            this.branchesId.add(goal.getBranch().getActualBranchId());
            if (goal.getBranchExpressionValue()) {
                this.branchCoverageTrueMap.put(goal.getBranch().getActualBranchId(), goal);
                continue;
            }
            this.branchCoverageFalseMap.put(goal.getBranch().getActualBranchId(), goal);
        }
    }

    private boolean analyzeTraces(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite, List<ExecutionResult> results, Map<Integer, Integer> predicateCount, Map<Integer, Double> trueDistance, Map<Integer, Double> falseDistance) {
        boolean hasTimeoutOrTestException = false;
        for (ExecutionResult result : results) {
            OnlyBranchCoverageTestFitness goal;
            if (result.hasTimeout() || result.hasTestException()) {
                hasTimeoutOrTestException = true;
                continue;
            }
            TestChromosome test = new TestChromosome();
            test.setTestCase(result.test);
            test.setLastExecutionResult(result);
            test.setChanged(false);
            for (Map.Entry<Integer, Integer> entry : result.getTrace().getPredicateExecutionCount().entrySet()) {
                if (!this.branchesId.contains(entry.getKey()) || this.removedBranchesT.contains(entry.getKey()) && this.removedBranchesF.contains(entry.getKey())) continue;
                if (!predicateCount.containsKey(entry.getKey())) {
                    predicateCount.put(entry.getKey(), entry.getValue());
                    continue;
                }
                predicateCount.put(entry.getKey(), predicateCount.get(entry.getKey()) + entry.getValue());
            }
            for (Map.Entry<Integer, Number> entry : result.getTrace().getTrueDistances().entrySet()) {
                if (!this.branchesId.contains(entry.getKey()) || this.removedBranchesT.contains(entry.getKey())) continue;
                if (!trueDistance.containsKey(entry.getKey())) {
                    trueDistance.put(entry.getKey(), (Double)entry.getValue());
                } else {
                    trueDistance.put(entry.getKey(), Math.min(trueDistance.get(entry.getKey()), (Double)entry.getValue()));
                }
                goal = (OnlyBranchCoverageTestFitness)this.branchCoverageTrueMap.get(entry.getKey());
                if (Double.compare((Double)entry.getValue(), 0.0) == 0) {
                    test.getTestCase().addCoveredGoal(goal);
                    this.toRemoveBranchesT.add(entry.getKey());
                }
                if (!Properties.TEST_ARCHIVE) continue;
                Archive.getArchiveInstance().updateArchive(goal, test, (Double)entry.getValue());
            }
            for (Map.Entry<Integer, Number> entry : result.getTrace().getFalseDistances().entrySet()) {
                if (!this.branchesId.contains(entry.getKey()) || this.removedBranchesF.contains(entry.getKey())) continue;
                if (!falseDistance.containsKey(entry.getKey())) {
                    falseDistance.put(entry.getKey(), (Double)entry.getValue());
                } else {
                    falseDistance.put(entry.getKey(), Math.min(falseDistance.get(entry.getKey()), (Double)entry.getValue()));
                }
                goal = (OnlyBranchCoverageTestFitness)this.branchCoverageFalseMap.get(entry.getKey());
                if (Double.compare((Double)entry.getValue(), 0.0) == 0) {
                    test.getTestCase().addCoveredGoal(goal);
                    this.toRemoveBranchesF.add(entry.getKey());
                }
                if (!Properties.TEST_ARCHIVE) continue;
                Archive.getArchiveInstance().updateArchive(goal, test, (Double)entry.getValue());
            }
        }
        return hasTimeoutOrTestException;
    }

    @Override
    public boolean updateCoveredGoals() {
        TestFitnessFunction f;
        if (!Properties.TEST_ARCHIVE) {
            return false;
        }
        for (Integer branch : this.toRemoveBranchesT) {
            f = this.branchCoverageTrueMap.remove(branch);
            if (f != null) {
                this.removedBranchesT.add(branch);
                if (!this.removedBranchesF.contains(branch)) continue;
                --this.totalBranches;
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        for (Integer branch : this.toRemoveBranchesF) {
            f = this.branchCoverageFalseMap.remove(branch);
            if (f != null) {
                this.removedBranchesF.add(branch);
                if (!this.removedBranchesT.contains(branch)) continue;
                --this.totalBranches;
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        this.toRemoveBranchesF.clear();
        this.toRemoveBranchesT.clear();
        logger.info("Current state of archive: " + Archive.getArchiveInstance().toString());
        return true;
    }

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite) {
        logger.trace("Calculating branch fitness");
        double fitness = 0.0;
        List<ExecutionResult> results = this.runTestSuite(suite);
        LinkedHashMap<Integer, Double> trueDistance = new LinkedHashMap<Integer, Double>();
        LinkedHashMap<Integer, Double> falseDistance = new LinkedHashMap<Integer, Double>();
        LinkedHashMap<Integer, Integer> predicateCount = new LinkedHashMap<Integer, Integer>();
        boolean hasTimeoutOrTestException = this.analyzeTraces(suite, results, predicateCount, trueDistance, falseDistance);
        int numCoveredBranches = 0;
        for (Integer key : predicateCount.keySet()) {
            double df = 0.0;
            double dt = 0.0;
            int numExecuted = (Integer)predicateCount.get(key);
            if (this.removedBranchesT.contains(key)) {
                ++numExecuted;
            }
            if (this.removedBranchesF.contains(key)) {
                ++numExecuted;
            }
            if (trueDistance.containsKey(key)) {
                dt = (Double)trueDistance.get(key);
            }
            if (falseDistance.containsKey(key)) {
                df = (Double)falseDistance.get(key);
            }
            fitness = numExecuted == 1 ? (fitness += 1.0) : (fitness += OnlyBranchCoverageSuiteFitness.normalize(df) + OnlyBranchCoverageSuiteFitness.normalize(dt));
            if (falseDistance.containsKey(key) && Double.compare(df, 0.0) == 0) {
                ++numCoveredBranches;
            }
            if (!trueDistance.containsKey(key) || Double.compare(dt, 0.0) != 0) continue;
            ++numCoveredBranches;
        }
        this.printStatusMessages(suite, numCoveredBranches, fitness += (double)(2 * (this.totalBranches - predicateCount.size())));
        int coverage = numCoveredBranches;
        coverage += this.removedBranchesF.size();
        coverage += this.removedBranchesT.size();
        if (this.totalGoals > 0) {
            suite.setCoverage(this, (double)coverage / (double)this.totalGoals);
        } else {
            suite.setCoverage(this, 1.0);
        }
        suite.setNumOfCoveredGoals(this, coverage);
        suite.setNumOfNotCoveredGoals(this, this.totalGoals - coverage);
        if (hasTimeoutOrTestException) {
            logger.info("Test suite has timed out, setting fitness to max value " + this.totalBranches * 2);
            fitness = this.totalBranches * 2;
        }
        this.updateIndividual(this, suite, fitness);
        assert (coverage <= this.totalGoals) : "Covered " + coverage + " vs total goals " + this.totalGoals;
        assert (fitness >= 0.0);
        assert (fitness != 0.0 || coverage == this.totalGoals) : "Fitness: " + fitness + ", coverage: " + coverage + "/" + this.totalGoals;
        assert (suite.getCoverage(this) <= 1.0 && suite.getCoverage(this) >= 0.0) : "Wrong coverage value " + suite.getCoverage(this);
        return fitness;
    }

    private void printStatusMessages(AbstractTestSuiteChromosome<? extends ExecutableChromosome> suite, int coveredBranches, double fitness) {
        if (coveredBranches > this.maxCoveredBranches) {
            this.maxCoveredBranches = coveredBranches;
            logger.info("(Branches) Best individual covers " + coveredBranches + "/" + this.totalBranches * 2 + " branches");
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
        if (fitness < this.bestFitness) {
            logger.info("(Fitness) Best individual covers " + coveredBranches + "/" + this.totalBranches * 2 + " branches");
            this.bestFitness = fitness;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
    }
}

