/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.branch;

import java.io.Serializable;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.shaded.org.objectweb.asm.tree.LabelNode;

public class Branch
implements Serializable,
Comparable<Branch> {
    private static final long serialVersionUID = -4732587925060748263L;
    private final int actualBranchId;
    private boolean isSwitch = false;
    private Integer targetCaseValue = null;
    private final BytecodeInstruction instruction;
    private boolean isInstrumented = false;

    public Branch(BytecodeInstruction branchInstruction, int actualBranchId) {
        if (!branchInstruction.isBranch()) {
            throw new IllegalArgumentException("only branch instructions are accepted");
        }
        this.instruction = branchInstruction;
        this.actualBranchId = actualBranchId;
        if (this.actualBranchId < 1) {
            throw new IllegalStateException("expect branch to have actualBranchId set to positive value");
        }
    }

    public Branch(BytecodeInstruction switchInstruction, Integer targetCaseValue, LabelNode targetLabel, int actualBranchId) {
        if (!switchInstruction.isSwitch()) {
            throw new IllegalArgumentException("switch instruction expected");
        }
        if (targetLabel == null) {
            throw new IllegalArgumentException("expect targetLabel to not be null for case branches");
        }
        this.instruction = switchInstruction;
        this.actualBranchId = actualBranchId;
        this.targetCaseValue = targetCaseValue;
        this.isSwitch = true;
        if (this.actualBranchId < 1) {
            throw new IllegalStateException("expect branch to have actualBranchId set to positive value");
        }
    }

    public int getActualBranchId() {
        return this.actualBranchId;
    }

    public boolean isDefaultCase() {
        return this.isSwitch && this.targetCaseValue == null;
    }

    public boolean isActualCase() {
        return this.isSwitch && this.targetCaseValue != null;
    }

    public Integer getTargetCaseValue() {
        if (!this.isSwitch) {
            throw new IllegalStateException("method only allowed to be called on non-switch-Branches");
        }
        return this.targetCaseValue;
    }

    public BytecodeInstruction getInstruction() {
        return this.instruction;
    }

    public String getClassName() {
        return this.instruction.getClassName();
    }

    public String getMethodName() {
        return this.instruction.getMethodName();
    }

    public boolean isSwitchCaseBranch() {
        return this.isSwitch;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.actualBranchId;
        result = 31 * result + (this.instruction == null ? 0 : this.instruction.hashCode());
        result = 31 * result + (this.isSwitch ? 1231 : 1237);
        result = 31 * result + (this.targetCaseValue == null ? 0 : this.targetCaseValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Branch other = (Branch)obj;
        if (this.actualBranchId != other.actualBranchId) {
            return false;
        }
        if (this.instruction == null ? other.instruction != null : !this.instruction.equals(other.instruction)) {
            return false;
        }
        if (this.isSwitch != other.isSwitch) {
            return false;
        }
        return !(this.targetCaseValue == null ? other.targetCaseValue != null : !this.targetCaseValue.equals(other.targetCaseValue));
    }

    @Override
    public int compareTo(Branch other) {
        return this.instruction.getLineNumber() - other.getInstruction().getLineNumber();
    }

    public String toString() {
        String r = "I" + this.instruction.getInstructionId();
        r = r + " Branch " + this.getActualBranchId();
        r = r + " " + this.instruction.getInstructionType();
        if (this.isSwitch) {
            r = r + " L" + this.instruction.getLineNumber();
            r = this.targetCaseValue != null ? r + " Case " + this.targetCaseValue : r + " Default-Case";
        } else {
            r = r + " L" + this.instruction.getLineNumber();
        }
        return r;
    }

    public boolean isInstrumented() {
        return this.isInstrumented;
    }

    public void setInstrumented(boolean isInstrumented) {
        this.isInstrumented = isInstrumented;
    }
}

