/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage;

import org.evosuite.ga.FitnessFunction;

public class ControlFlowDistance
implements Comparable<ControlFlowDistance> {
    public int approachLevel;
    public double branchDistance;

    public ControlFlowDistance() {
        this.approachLevel = 0;
        this.branchDistance = 0.0;
    }

    public ControlFlowDistance(int approachLevel, double branchDistance) {
        if (approachLevel < 0 || branchDistance < 0.0) {
            throw new IllegalStateException("expect approachLevel and branchDistance to always be positive");
        }
        this.approachLevel = approachLevel;
        this.branchDistance = branchDistance;
    }

    @Override
    public int compareTo(ControlFlowDistance o) {
        ControlFlowDistance d = o;
        if (this.approachLevel < d.approachLevel) {
            return -1;
        }
        if (this.approachLevel > d.approachLevel) {
            return 1;
        }
        if (this.branchDistance < d.branchDistance) {
            return -1;
        }
        if (this.branchDistance > d.branchDistance) {
            return 1;
        }
        return 0;
    }

    public void increaseApproachLevel() {
        ++this.approachLevel;
        if (this.approachLevel < 0) {
            throw new IllegalStateException("expect approach Level to always be positive - overflow?");
        }
    }

    public int getApproachLevel() {
        return this.approachLevel;
    }

    public void setApproachLevel(int approachLevel) {
        if (approachLevel < 0) {
            throw new IllegalArgumentException("expect approachLevel to always be positive");
        }
        this.approachLevel = approachLevel;
    }

    public double getBranchDistance() {
        return this.branchDistance;
    }

    public void setBranchDistance(double branchDistance) {
        if (branchDistance < 0.0) {
            throw new IllegalArgumentException("expect branchDistance to be positive");
        }
        this.branchDistance = branchDistance;
    }

    public double getResultingBranchFitness() {
        return (double)this.approachLevel + FitnessFunction.normalize(this.branchDistance);
    }

    public String toString() {
        return "Approach = " + this.approachLevel + ", branch distance = " + this.branchDistance;
    }
}

