/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.contracts;

import java.util.List;
import org.evosuite.Properties;
import org.evosuite.contracts.Contract;
import org.evosuite.contracts.ContractViolation;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;

public class AssertionErrorContract
extends Contract {
    @Override
    public ContractViolation check(Statement statement, Scope scope, Throwable exception) {
        if (!Properties.ENABLE_ASSERTS_FOR_SUT) {
            throw new IllegalArgumentException("Cannot check for assert errors if they are not enabled");
        }
        if (!this.isTargetStatement(statement)) {
            return null;
        }
        if (exception != null && exception instanceof AssertionError) {
            return new ContractViolation(this, statement, exception, new VariableReference[0]);
        }
        return null;
    }

    @Override
    public void addAssertionAndComments(Statement statement, List<VariableReference> variables, Throwable exception) {
        statement.addComment("Assertion violation: " + exception.getMessage());
    }

    public String toString() {
        return "Assertion failed";
    }
}

