/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.persistency;

import com.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.statistics.RuntimeVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvJUnitData {
    private static Logger logger = LoggerFactory.getLogger(CsvJUnitData.class);
    private String targetClass;
    private Map<String, Double> coverageValues = new LinkedHashMap<String, Double>();
    private Map<String, String> coverageBitString = new LinkedHashMap<String, String>();
    private int totalNumberOfStatements;
    private int numberOfTests;
    private int totalNumberOfFailures;
    private int durationInSeconds;
    private int configurationId;

    protected CsvJUnitData() {
    }

    public static CsvJUnitData openFile(File file) {
        if (!file.getName().endsWith("csv")) {
            logger.error("Not a csv file: " + file.getAbsolutePath());
            return null;
        }
        List<String[]> rows = null;
        try {
            CSVReader reader = new CSVReader(new FileReader(file));
            rows = reader.readAll();
            reader.close();
        }
        catch (Exception e) {
            logger.error("Exception while parsing CSV file " + file.getAbsolutePath() + " , " + e.getMessage(), e);
            return null;
        }
        if (rows.size() != 2) {
            logger.error("Cannot parse " + file.getAbsolutePath() + " as it has " + rows.size() + " rows");
            return null;
        }
        CsvJUnitData data = new CsvJUnitData();
        try {
            data.targetClass = CsvJUnitData.getValue(rows, "TARGET_CLASS").trim();
            data.configurationId = 0;
            for (String columnName : rows.get(0)) {
                if (!columnName.equals(RuntimeVariable.Coverage.name()) && (columnName.endsWith("Coverage") || columnName.endsWith("Score"))) {
                    data.coverageValues.put(columnName, Double.parseDouble(CsvJUnitData.getValue(rows, columnName)));
                }
                if (columnName.equals(RuntimeVariable.CoverageBitString.name()) || !columnName.endsWith("CoverageBitString")) continue;
                String coverageColumn = columnName.replace("BitString", "");
                if (coverageColumn.contains("Mutation")) {
                    coverageColumn = coverageColumn.replace("Coverage", "Score");
                }
                data.coverageBitString.put(coverageColumn, CsvJUnitData.getValue(rows, columnName));
            }
            data.totalNumberOfStatements = Integer.parseInt(CsvJUnitData.getValue(rows, RuntimeVariable.Length.toString()));
            data.durationInSeconds = Integer.parseInt(CsvJUnitData.getValue(rows, RuntimeVariable.Total_Time.toString())) / 1000;
            data.numberOfTests = Integer.parseInt(CsvJUnitData.getValue(rows, RuntimeVariable.Size.toString()));
            data.totalNumberOfFailures = 0;
        }
        catch (Exception e) {
            logger.error("Error while parsing CSV file: " + e, e);
            return null;
        }
        return data;
    }

    public static String getValue(List<String[]> rows, String columnName) {
        String[] names = rows.get(0);
        String[] values = rows.get(1);
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].trim().equalsIgnoreCase(columnName.trim())) continue;
            return values[i].trim();
        }
        return null;
    }

    public static List<String> getValues(List<String[]> rows, String columnName) {
        String[] names = rows.get(0);
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].trim().equalsIgnoreCase(columnName.trim())) continue;
            for (int j = 1; j < rows.size(); ++j) {
                values.add(rows.get(j)[i].trim());
            }
        }
        return values;
    }

    public String getTargetClass() {
        return this.targetClass;
    }

    public Set<String> getCoverageVariables() {
        return this.coverageValues.keySet();
    }

    public double getCoverage(String coverageVariable) {
        return this.coverageValues.get(coverageVariable);
    }

    public boolean hasCoverage(String coverageVariable) {
        return this.coverageValues.containsKey(coverageVariable);
    }

    public int getNumberOfCoverageValues() {
        return this.coverageValues.size();
    }

    public Set<String> getCoverageBitStringVariables() {
        return this.coverageBitString.keySet();
    }

    public String getCoverageBitString(String coverageVariable) {
        return this.coverageBitString.get(coverageVariable);
    }

    public int getTotalNumberOfStatements() {
        return this.totalNumberOfStatements;
    }

    public int getNumberOfTests() {
        return this.numberOfTests;
    }

    public int getTotalNumberOfFailures() {
        return this.totalNumberOfFailures;
    }

    public int getDurationInSeconds() {
        return this.durationInSeconds;
    }

    public int getConfigurationId() {
        return this.configurationId;
    }
}

