/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.job.schedule;

import java.util.LinkedList;
import java.util.List;
import org.evosuite.continuous.job.JobDefinition;
import org.evosuite.continuous.job.JobScheduler;
import org.evosuite.continuous.project.ProjectStaticData;

public abstract class ScheduleType {
    protected final JobScheduler scheduler;

    protected ScheduleType(JobScheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected boolean enoughBudgetForAll() {
        int totalBudget = 60 * this.scheduler.getConfiguration().timeInMinutes * this.scheduler.getConfiguration().getNumberOfUsableCores();
        int maximumNumberOfJobs = totalBudget / (60 * this.scheduler.getConfiguration().minMinutesPerJob);
        return maximumNumberOfJobs >= this.scheduler.getProjectData().getTotalNumberOfTestableCUTs();
    }

    public abstract List<JobDefinition> createNewSchedule() throws IllegalStateException;

    public abstract boolean canExecuteMore();

    protected List<JobDefinition> createScheduleForWhenNotEnoughBudget() {
        ProjectStaticData data = this.scheduler.getProjectData();
        int totalBudget = 60 * this.scheduler.getConfiguration().timeInMinutes * this.scheduler.getConfiguration().getNumberOfUsableCores();
        LinkedList<JobDefinition> jobs = new LinkedList<JobDefinition>();
        for (ProjectStaticData.ClassInfo info : data.getClassInfos()) {
            if (!info.isTestable()) continue;
            JobDefinition job = new JobDefinition(60 * this.scheduler.getConfiguration().minMinutesPerJob, this.scheduler.getConfiguration().getConstantMemoryPerJob(), info.getClassName(), 0, null, null);
            jobs.add(job);
            if ((totalBudget -= 60 * this.scheduler.getConfiguration().minMinutesPerJob) > 0) continue;
            break;
        }
        return jobs;
    }
}

