/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.job;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.continuous.job.JobDefinition;
import org.evosuite.continuous.job.JobExecutor;
import org.evosuite.continuous.persistency.StorageManager;
import org.evosuite.coverage.CoverageCriteriaAnalyzer;
import org.evosuite.runtime.util.JarPathing;
import org.evosuite.runtime.util.JavaExecCmdUtil;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobHandler
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(JobHandler.class);
    private final JobExecutor executor;
    private Process latestProcess;

    public JobHandler(JobExecutor executor) {
        this.executor = executor;
    }

    public void setUpShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (JobHandler.this.latestProcess != null) {
                    JobHandler.this.latestProcess.destroy();
                }
            }
        });
    }

    public static JobHandler[] getPool(int n, JobExecutor executor) {
        JobHandler[] jobs = new JobHandler[n];
        for (int i = 0; i < jobs.length; ++i) {
            jobs[i] = new JobHandler(executor);
            jobs[i].setUpShutdownHook();
        }
        return jobs;
    }

    public void stopExecution() {
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isInterrupted()) {
            JobDefinition job = null;
            try {
                job = this.executor.pollJob();
            }
            catch (InterruptedException e) {
                break;
            }
            Process process = null;
            try {
                List<String> commands = this.getCommandString(job);
                String baseDir = System.getProperty("user.dir");
                File dir = new File(baseDir);
                CharSequence[] parsedCommand = new String[commands.size()];
                commands.toArray(parsedCommand);
                ProcessBuilder builder = new ProcessBuilder((String[])parsedCommand);
                builder.directory(dir);
                builder.redirectErrorStream(true);
                LocalDateTime endBy = LocalDateTime.now().plus(job.seconds, ChronoUnit.SECONDS);
                LoggingUtils.getEvoLogger().info("Going to start job for: " + job.cut + ". Expected to end in " + job.seconds + " seconds, by " + endBy.toString());
                logger.debug("Base directory: " + baseDir);
                if (logger.isDebugEnabled()) {
                    String commandString = String.join((CharSequence)" ", parsedCommand);
                    commandString = commandString.replace("\\", "\\\\");
                    logger.debug("Commands: " + commandString);
                }
                this.latestProcess = process = builder.start();
                int exitCode = process.waitFor();
                if (exitCode == 0) continue;
                this.handleProcessError(job, process);
            }
            catch (InterruptedException e) {
                this.interrupt();
                if (process == null) continue;
                try {
                    process.getOutputStream().close();
                    process.getInputStream().close();
                    process.getErrorStream().close();
                }
                catch (Exception t) {
                    logger.error("Failed to close process stream: " + t.toString());
                }
                process.destroy();
            }
            catch (Exception e) {
                logger.error("Failed to start new job: " + e.getMessage(), e);
            }
            finally {
                this.executor.doneWithJob(job);
            }
        }
    }

    private void handleProcessError(JobDefinition job, Process process) throws IOException {
        StringBuffer sb = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
        int data = 0;
        while (data != -1 && !this.isInterrupted()) {
            data = in.read();
            if (data == -1) continue;
            sb.append((char)data);
        }
        logger.warn("Job ended with erroneous exit code: " + job.cut + "\nProcess console output:\n" + sb.toString());
    }

    private String configureAndGetClasspath() {
        String classpath = System.getProperty("java.class.path");
        classpath = classpath + File.pathSeparator + this.executor.getProjectClassPath();
        return JarPathing.createJarPathing(classpath);
    }

    private List<String> getCommandString(JobDefinition job) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(JavaExecCmdUtil.getJavaBinExecutablePath());
        commands.add("-cp");
        commands.add(this.configureAndGetClasspath());
        commands.add("-Duse_different_logback=logback-ctg.xml");
        commands.add("-Dlogback.configurationFile=logback-ctg.xml");
        StorageManager storage = this.executor.getStorage();
        File logs = storage.getTmpLogs();
        commands.add("-Devosuite.log.folder=" + logs.getAbsolutePath() + File.separator + job.cut);
        if (Properties.LOG_LEVEL != null && !Properties.LOG_LEVEL.isEmpty()) {
            commands.add("-Dlog.level=" + Properties.LOG_LEVEL);
        }
        int masterMB = 250;
        int clientMB = job.memoryInMB - masterMB;
        commands.add("-Xmx" + masterMB + "m");
        if (Properties.CTG_DEBUG_PORT != null) {
            commands.add("-Xdebug");
            commands.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + Properties.CTG_DEBUG_PORT);
        }
        commands.add(EvoSuite.class.getName());
        if (Properties.CTG_DEBUG_PORT != null) {
            commands.add("-Ddebug");
            commands.add("-Dport=" + (Properties.CTG_DEBUG_PORT + 1));
        }
        commands.add("-mem");
        commands.add("" + clientMB);
        commands.add("-class");
        commands.add(job.cut);
        if (Properties.SPAWN_PROCESS_MANAGER_PORT != null) {
            commands.add("-Dspawn_process_manager_port=" + Properties.SPAWN_PROCESS_MANAGER_PORT);
        }
        String classpath = ClassPathHandler.writeClasspathToFile(this.executor.getProjectClassPath());
        commands.add("-DCP_file_path=" + classpath);
        if (Properties.LOG_LEVEL != null && !Properties.LOG_LEVEL.isEmpty()) {
            commands.add("-Dlog.level=" + Properties.LOG_LEVEL);
        }
        if (Properties.LOG_TARGET != null && !Properties.LOG_TARGET.isEmpty()) {
            commands.add("-Dlog.target=" + Properties.LOG_TARGET);
        }
        commands.addAll(this.getPoolInfo(job));
        commands.addAll(this.timeSetUp(job.seconds));
        File reports = storage.getTmpReports();
        File tests = storage.getTmpTests();
        File seedOut = storage.getTmpSeeds();
        File seedIn = storage.getSeedInFolder();
        commands.add("-Dreport_dir=" + reports.getAbsolutePath() + File.separator + job.cut);
        commands.add("-Dtest_dir=" + tests.getAbsolutePath());
        String seedsFileName = job.cut + "." + Properties.CTG_SEEDS_EXT;
        commands.add("-Dctg_seeds_file_out=" + seedOut.getAbsolutePath() + File.separator + seedsFileName);
        commands.add("-Dctg_seeds_file_in=" + seedIn.getAbsolutePath() + File.separator + seedsFileName);
        commands.addAll(this.getOutputVariables());
        commands.add("-Danalysis_criteria=" + Properties.ANALYSIS_CRITERIA);
        commands.add("-Dcriterion=" + Arrays.toString((Object[])Properties.CRITERION).replace("[", "").replace("]", "").replaceAll(", ", ":"));
        commands.add("-Djunit_suffix=" + Properties.JUNIT_SUFFIX);
        commands.add("-Denable_asserts_for_evosuite=" + Properties.ENABLE_ASSERTS_FOR_EVOSUITE);
        String confId = Properties.CONFIGURATION_ID;
        if (confId != null && !confId.isEmpty()) {
            commands.add("-Dconfiguration_id=" + confId);
        } else {
            commands.add("-Dconfiguration_id=default");
        }
        if (Properties.RANDOM_SEED != null) {
            commands.add("-Drandom_seed=" + Properties.RANDOM_SEED);
        }
        commands.add("-Dprint_to_system=" + Properties.PRINT_TO_SYSTEM);
        commands.add("-Dp_object_pool=" + Properties.P_OBJECT_POOL);
        commands.add("-Dminimize=" + Properties.MINIMIZE);
        commands.add("-Dassertions=" + Properties.ASSERTIONS);
        commands.add("-Djunit_tests=" + Properties.JUNIT_TESTS);
        commands.add("-Djunit_check=" + Properties.JUNIT_CHECK);
        commands.add("-Dmax_size=" + Properties.MAX_SIZE);
        commands.add("-Dlog_timeout=false");
        commands.add("-Dplot=false");
        commands.add("-Dtest_comments=false");
        commands.add("-Dshow_progress=false");
        commands.add("-Dsave_all_data=false");
        commands.add("-Dcoverage=" + Properties.COVERAGE);
        commands.add("-Dreset_static_fields=true");
        commands.add("-Dreplace_calls=true");
        if (Properties.CTG_HISTORY_FILE != null) {
            commands.add("-Dctg_history_file=" + Properties.CTG_HISTORY_FILE);
        }
        return commands;
    }

    private List<String> getPoolInfo(JobDefinition job) {
        ArrayList<String> commands = new ArrayList<String>();
        StorageManager storage = this.executor.getStorage();
        File poolFolder = storage.getTmpPools();
        String extension = ".pool";
        commands.add("-Dwrite_pool=" + poolFolder.getAbsolutePath() + File.separator + job.cut + extension);
        if (job.inputClasses != null && job.inputClasses.size() > 0) {
            String[] dep = job.inputClasses.toArray(new String[0]);
            double poolP = 0.5;
            if (Properties.P_OBJECT_POOL > 0.0) {
                poolP = Properties.P_OBJECT_POOL;
            }
            commands.add("-Dp_object_pool=" + poolP);
            String cmd = "-Dobject_pools=";
            cmd = cmd + poolFolder.getAbsolutePath() + File.separator + dep[0] + extension;
            for (int i = 1; i < dep.length; ++i) {
                cmd = cmd + File.pathSeparator + poolFolder.getAbsolutePath() + File.separator + dep[i] + extension;
            }
            commands.add(cmd);
        }
        return commands;
    }

    private List<String> getOutputVariables() {
        ArrayList<String> commands = new ArrayList<String>();
        if (Properties.OUTPUT_VARIABLES == null) {
            StringBuilder cmd = new StringBuilder();
            cmd.append("TARGET_CLASS,configuration_id,criterion");
            cmd.append(",ctg_min_time_per_job,ctg_schedule,search_budget,p_object_pool");
            if (Properties.CTG_TIME_PER_CLASS != null) {
                cmd.append(",ctg_time_per_class");
            }
            cmd.append("," + (Object)((Object)RuntimeVariable.Size));
            cmd.append("," + (Object)((Object)RuntimeVariable.Length));
            cmd.append("," + (Object)((Object)RuntimeVariable.Total_Time));
            cmd.append("," + (Object)((Object)RuntimeVariable.Random_Seed));
            for (Properties.Criterion criterion : Properties.CRITERION) {
                cmd.append("," + (Object)((Object)CoverageCriteriaAnalyzer.getCoverageVariable(criterion)));
                cmd.append("," + (Object)((Object)CoverageCriteriaAnalyzer.getBitStringVariable(criterion)));
                if (criterion.equals((Object)Properties.Criterion.EXCEPTION)) {
                    cmd.append("," + (Object)((Object)RuntimeVariable.Explicit_MethodExceptions) + "," + (Object)((Object)RuntimeVariable.Explicit_TypeExceptions));
                    cmd.append("," + (Object)((Object)RuntimeVariable.Implicit_MethodExceptions) + "," + (Object)((Object)RuntimeVariable.Implicit_TypeExceptions));
                    continue;
                }
                if (!criterion.equals((Object)Properties.Criterion.STATEMENT)) continue;
                cmd.append("," + (Object)((Object)RuntimeVariable.Statements_Executed));
            }
            commands.add("-Doutput_variables=" + cmd.toString());
        } else {
            commands.add("-Doutput_variables=" + Properties.OUTPUT_VARIABLES);
        }
        if (Properties.CTG_TIME_PER_CLASS != null) {
            commands.add("-Dctg_time_per_class=" + Properties.CTG_TIME_PER_CLASS);
        }
        commands.add("-startedByCtg");
        commands.add("-Dctg_schedule=" + (Object)((Object)Properties.CTG_SCHEDULE));
        commands.add("-Dctg_min_time_per_job=" + Properties.CTG_MIN_TIME_PER_JOB);
        if (Properties.CTG_EXTRA_ARGS != null && !Properties.CTG_EXTRA_ARGS.isEmpty()) {
            String[] tokens;
            String extraArgs = Properties.CTG_EXTRA_ARGS;
            if (extraArgs.startsWith("\"") && extraArgs.endsWith("\"")) {
                extraArgs = extraArgs.substring(1, extraArgs.length() - 1);
            }
            for (String token : tokens = extraArgs.split(" ")) {
                if ((token = token.trim()).isEmpty() || token.equals("\"")) continue;
                if (!token.startsWith("-D")) {
                    throw new IllegalStateException("Invalid extra parameter \"" + token + "\" as it does not start with '-D'");
                }
                commands.add(token);
            }
        }
        return commands;
    }

    private List<String> timeSetUp(int seconds) {
        int minSecondsPerJob;
        int remaining = (int)this.executor.getRemainingTimeInMs() / 1000;
        if (seconds > remaining) {
            seconds = remaining;
        }
        if (seconds < (minSecondsPerJob = 60 * this.executor.configuration.minMinutesPerJob)) {
            seconds = minSecondsPerJob;
        }
        int PHASES = 6;
        int halfTime = seconds / 2;
        int initialization = halfTime / 6;
        int minimization = halfTime / 6;
        int assertions = halfTime / 6;
        int extra = halfTime / 6;
        int junit = halfTime / 6;
        int write = halfTime / 6;
        int MAJOR_DELTA = 120;
        int MINOR_DELTA = 60;
        if (halfTime > 720) {
            initialization = 120;
            minimization = 120;
            assertions = 120;
            extra = 120;
            junit = 120;
            write = 120;
        } else if (halfTime > 360) {
            initialization = 60;
            minimization = 60;
            assertions = 60;
            extra = 60;
            junit = 60;
            write = 60;
        }
        int search = seconds - (initialization + minimization + assertions + extra + junit + write);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("-Dsearch_budget=" + search);
        commands.add("-Dglobal_timeout=" + search);
        commands.add("-Dstopping_condition=" + (Object)((Object)Properties.StoppingCondition.MAXTIME));
        commands.add("-Dinitialization_timeout=" + initialization);
        commands.add("-Dminimization_timeout=" + minimization);
        commands.add("-Dassertion_timeout=" + assertions);
        commands.add("-Dextra_timeout=" + extra);
        commands.add("-Djunit_check_timeout=" + junit);
        commands.add("-Dwrite_junit_timeout=" + write);
        return commands;
    }
}

