/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.job;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobDefinition {
    private static Logger logger = LoggerFactory.getLogger(JobDefinition.class);
    private static final AtomicInteger counter = new AtomicInteger(0);
    public final int jobID = counter.getAndIncrement();
    public final int seconds;
    public final int memoryInMB;
    public final String cut;
    public final int configurationId;
    public final Set<String> dependentOnClasses;
    public final Set<String> inputClasses;
    public final Set<String> parentClasses;

    public JobDefinition(int seconds, int memoryInMB, String cut, int configurationId, Set<String> inputDependencies, Set<String> parentDependencies) {
        this.seconds = seconds;
        this.memoryInMB = memoryInMB;
        this.cut = cut;
        this.configurationId = configurationId;
        HashSet<String> union = new HashSet<String>();
        if (inputDependencies != null && inputDependencies.size() > 0) {
            this.inputClasses = Collections.unmodifiableSet(new HashSet<String>(inputDependencies));
            union.addAll(this.inputClasses);
        } else {
            this.inputClasses = null;
        }
        if (parentDependencies != null && parentDependencies.size() > 0) {
            this.parentClasses = Collections.unmodifiableSet(new HashSet<String>(parentDependencies));
            union.addAll(this.parentClasses);
        } else {
            this.parentClasses = null;
        }
        this.dependentOnClasses = union.size() == 0 ? null : Collections.unmodifiableSet(new HashSet(union));
    }

    public JobDefinition getByAddingDependencies(Set<String> inputs, Set<String> parents) throws IllegalArgumentException {
        if (inputs == null && parents == null) {
            throw new IllegalArgumentException("Both sets are null");
        }
        if (inputs != null && inputs.contains(this.cut)) {
            throw new IllegalArgumentException("'inputs' contains reference to this job");
        }
        if (parents != null && parents.contains(this.cut)) {
            throw new IllegalArgumentException("'parents' contains reference to this job");
        }
        if (this.inputClasses != null) {
            logger.debug("Adding " + this.inputClasses.size() + "input dependecies in job " + this.jobID);
            if (inputs == null) {
                inputs = this.inputClasses;
            } else {
                inputs.addAll(this.inputClasses);
            }
        }
        if (this.parentClasses != null) {
            if (parents == null) {
                parents = this.parentClasses;
            } else {
                parents.addAll(this.parentClasses);
            }
        }
        return new JobDefinition(this.seconds, this.memoryInMB, this.cut, this.configurationId, inputs, parents);
    }

    public JobDefinition getByAddingBudget(int moreSeconds) throws IllegalArgumentException {
        if (moreSeconds <= 0) {
            throw new IllegalArgumentException("Invalid extra seconds: " + moreSeconds);
        }
        return new JobDefinition(this.seconds + moreSeconds, this.memoryInMB, this.cut, this.configurationId, this.inputClasses, this.parentClasses);
    }

    public boolean dependOn(JobDefinition other) {
        return this.dependentOnClasses != null && this.dependentOnClasses.contains(other.cut);
    }

    public int getNumberOfDependencies() {
        if (this.dependentOnClasses == null) {
            return 0;
        }
        return this.dependentOnClasses.size();
    }

    public boolean areDependenciesSatisfied(List<JobDefinition> schedule, Set<String> done) {
        if (this.dependentOnClasses == null) {
            return true;
        }
        for (String name : this.dependentOnClasses) {
            if (!this.inTheSchedule(schedule, name) || done.contains(name)) continue;
            return false;
        }
        return true;
    }

    private boolean inTheSchedule(List<JobDefinition> jobs, String cut) {
        for (JobDefinition job : jobs) {
            if (!job.cut.equals(cut)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.configurationId;
        result = 31 * result + (this.cut == null ? 0 : this.cut.hashCode());
        result = 31 * result + (this.dependentOnClasses == null ? 0 : this.dependentOnClasses.hashCode());
        result = 31 * result + this.jobID;
        result = 31 * result + this.memoryInMB;
        result = 31 * result + this.seconds;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobDefinition other = (JobDefinition)obj;
        if (this.configurationId != other.configurationId) {
            return false;
        }
        if (this.cut == null ? other.cut != null : !this.cut.equals(other.cut)) {
            return false;
        }
        if (this.dependentOnClasses == null ? other.dependentOnClasses != null : !this.dependentOnClasses.equals(other.dependentOnClasses)) {
            return false;
        }
        if (this.jobID != other.jobID) {
            return false;
        }
        if (this.memoryInMB != other.memoryInMB) {
            return false;
        }
        return this.seconds == other.seconds;
    }

    public String toString() {
        return "job " + this.jobID + ", target " + this.cut + ", number of dependencies " + this.getNumberOfDependencies();
    }
}

