/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous;

import org.evosuite.Properties;

public class CtgConfiguration {
    protected final int MINIMUM_MEMORY_PER_JOB_MB = 500;
    public final int totalMemoryInMB;
    public final int numberOfCores;
    public final int timeInMinutes;
    public final int minMinutesPerJob;
    public final boolean callHome;
    public final Properties.AvailableSchedule schedule;
    public final String extraArgs;

    public CtgConfiguration(int totalMemoryInMB, int numberOfCores, int timeInMinutes, int minMinutesPerJob, boolean callHome, Properties.AvailableSchedule schedule) {
        this(totalMemoryInMB, numberOfCores, timeInMinutes, minMinutesPerJob, callHome, schedule, "");
    }

    public CtgConfiguration(int totalMemoryInMB, int numberOfCores, int timeInMinutes, int minMinutesPerJob, boolean callHome, Properties.AvailableSchedule schedule, String extraArgs) {
        this.totalMemoryInMB = totalMemoryInMB;
        this.numberOfCores = numberOfCores;
        this.timeInMinutes = timeInMinutes;
        this.minMinutesPerJob = minMinutesPerJob;
        this.callHome = callHome;
        this.schedule = schedule;
        this.extraArgs = extraArgs;
        if (totalMemoryInMB < 500) {
            throw new IllegalArgumentException("Should use at least 500MB");
        }
        if (numberOfCores < 1) {
            throw new IllegalArgumentException("Need at least one core");
        }
        int requiredMemory = numberOfCores * 500;
        if (totalMemoryInMB < requiredMemory) {
            throw new IllegalArgumentException("Not enough memory assigned. You need at least 500MB per core. You are using " + numberOfCores + " cores for a total of " + totalMemoryInMB + "MB of memory. Decrease the number of cores or increase the total memory. See documentation.");
        }
    }

    public static CtgConfiguration getFromParameters() {
        return new CtgConfiguration(Properties.CTG_MEMORY, Properties.CTG_CORES, Properties.CTG_TIME, Properties.CTG_MIN_TIME_PER_JOB, false, Properties.CTG_SCHEDULE, Properties.CTG_EXTRA_ARGS);
    }

    public CtgConfiguration getWithChangedTime(int minutesPerClass, int numberOfCUTs) throws IllegalArgumentException {
        if (minutesPerClass < 0) {
            throw new IllegalArgumentException("Invalid value for minutesPerClass:" + minutesPerClass);
        }
        if (numberOfCUTs < 0) {
            throw new IllegalArgumentException("Invalid value for numberOfCUTs:" + numberOfCUTs);
        }
        int time = (int)Math.ceil((double)(minutesPerClass * numberOfCUTs) / (double)this.getNumberOfUsableCores());
        return new CtgConfiguration(this.totalMemoryInMB, this.numberOfCores, time, this.minMinutesPerJob, this.callHome, this.schedule, this.extraArgs);
    }

    public int getNumberOfUsableCores() {
        return this.numberOfCores;
    }

    public int getConstantMemoryPerJob() {
        return this.totalMemoryInMB / this.getNumberOfUsableCores();
    }
}

