/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.classpath;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.evosuite.Properties;
import org.evosuite.runtime.agent.ToolsJarLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathHacker {
    private static Logger logger = LoggerFactory.getLogger(ClassPathHacker.class);
    private static final Class<?>[] parameters = new Class[]{URL.class};

    public static void initializeToolJar() throws RuntimeException {
        ToolsJarLocator locator = new ToolsJarLocator(Properties.TOOLS_JAR_LOCATION);
        locator.getLoaderForToolsJar();
        if (locator.getLocationNotOnClasspath() != null) {
            try {
                logger.info("Using JDK libraries at: " + locator.getLocationNotOnClasspath());
                ClassPathHacker.addFile(locator.getLocationNotOnClasspath());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to add " + locator.getLocationNotOnClasspath() + " to system classpath");
            }
        }
    }

    public static void addFile(String s) throws IOException {
        File f = new File(s);
        ClassPathHacker.addFile(f);
    }

    public static void addFile(File f) throws IOException {
        ClassPathHacker.addURL(f.toURI().toURL());
    }

    public static void addURL(URL u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }
}

