/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import org.evosuite.TestGenerationContext;
import org.evosuite.assertion.Assertion;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.utils.NumberFormatter;

public class PrimitiveFieldAssertion
extends Assertion {
    private static final long serialVersionUID = 2827276810722210456L;
    protected transient Field field;

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    @Override
    public String getCode() {
        if (this.value == null) {
            return "assertNull(" + this.source.getName() + "." + this.field.getName() + ");";
        }
        if (this.value.getClass().equals(Long.class)) {
            return "assertEquals(" + NumberFormatter.getNumberString(this.value) + ", " + this.source.getName() + "." + this.field.getName() + ");";
        }
        if (this.value.getClass().equals(Float.class)) {
            return "assertEquals(" + NumberFormatter.getNumberString(this.value) + ", " + this.source.getName() + "." + this.field.getName() + ", 0.01F);";
        }
        if (this.value.getClass().equals(Double.class)) {
            return "assertEquals(" + NumberFormatter.getNumberString(this.value) + ", " + this.source.getName() + "." + this.field.getName() + ", 0.01D);";
        }
        if (this.value.getClass().equals(Character.class)) {
            return "assertEquals(" + NumberFormatter.getNumberString(this.value) + ", " + this.source.getName() + "." + this.field.getName() + ");";
        }
        if (this.value.getClass().equals(String.class)) {
            return "assertEquals(" + NumberFormatter.getNumberString(this.value) + ", " + this.source.getName() + "." + this.field.getName() + ");";
        }
        return "assertEquals(" + NumberFormatter.getNumberString(this.value) + ", " + this.source.getName() + "." + this.field.getName() + ");";
    }

    @Override
    public Assertion copy(TestCase newTestCase, int offset) {
        PrimitiveFieldAssertion s = new PrimitiveFieldAssertion();
        s.source = newTestCase.getStatement(this.source.getStPosition() + offset).getReturnValue();
        s.value = this.value;
        s.field = this.field;
        s.comment = this.comment;
        s.killedMutants.addAll(this.killedMutants);
        return s;
    }

    @Override
    public boolean evaluate(Scope scope) {
        try {
            Object obj = this.source.getObject(scope);
            if (obj != null) {
                try {
                    Object val = this.field.get(obj);
                    if (val != null) {
                        return val.equals(this.value);
                    }
                    return this.value == null;
                }
                catch (Exception e) {
                    return true;
                }
            }
            return true;
        }
        catch (CodeUnderTestException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrimitiveFieldAssertion other = (PrimitiveFieldAssertion)obj;
        return !(this.field == null ? other.field != null : !this.field.equals(other.field));
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.field.getDeclaringClass().getName());
        oos.writeObject(this.field.getName());
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        Class<?> methodClass = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass((String)ois.readObject());
        String fieldName = (String)ois.readObject();
        try {
            this.field = methodClass.getField(fieldName);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

