/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import org.evosuite.assertion.Assertion;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.utils.NumberFormatter;

public class PrimitiveAssertion
extends Assertion {
    private static final long serialVersionUID = -3394333075511344913L;

    @Override
    public String getCode() {
        if (this.value == null) {
            return "assertNull(" + this.source.getName() + ");";
        }
        if (this.source.getVariableClass().equals(Float.TYPE)) {
            return "assertEquals(" + NumberFormatter.getNumberString(this.value) + ", " + this.source.getName() + ", 0.01F);";
        }
        if (this.source.getVariableClass().equals(Double.TYPE)) {
            return "assertEquals(" + NumberFormatter.getNumberString(this.value) + ", " + this.source.getName() + ", 0.01D);";
        }
        if (this.value.getClass().isEnum()) {
            return "assertEquals(" + NumberFormatter.getNumberString(this.value) + ", " + this.source.getName() + ");";
        }
        if (this.source.isWrapperType()) {
            if (this.source.getVariableClass().equals(Float.class)) {
                return "assertEquals(" + NumberFormatter.getNumberString(this.value) + "(float)" + this.source.getName() + ", 0.01F);";
            }
            if (this.source.getVariableClass().equals(Double.class)) {
                return "assertEquals(" + NumberFormatter.getNumberString(this.value) + "(double)" + this.source.getName() + ", 0.01D);";
            }
            if (this.value.getClass().isEnum()) {
                return "assertEquals(" + NumberFormatter.getNumberString(this.value) + ", " + this.source.getName() + ");";
            }
            return "assertEquals(" + NumberFormatter.getNumberString(this.value) + ", (" + NumberFormatter.getBoxedClassName(this.value) + ")" + this.source.getName() + ");";
        }
        return "assertEquals(" + NumberFormatter.getNumberString(this.value) + ", " + this.source.getName() + ");";
    }

    @Override
    public Assertion copy(TestCase newTestCase, int offset) {
        PrimitiveAssertion s = new PrimitiveAssertion();
        s.source = this.source.copy(newTestCase, offset);
        s.value = this.value;
        s.comment = this.comment;
        s.killedMutants.addAll(this.killedMutants);
        return s;
    }

    @Override
    public boolean evaluate(Scope scope) {
        try {
            if (this.value != null) {
                return this.value.equals(this.source.getObject(scope));
            }
            return this.source.getObject(scope) == null;
        }
        catch (CodeUnderTestException e) {
            throw new UnsupportedOperationException();
        }
    }
}

