/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.assertion.ArrayLengthAssertion;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.OutputTraceEntry;
import org.evosuite.testcase.variable.VariableReference;

public class ArrayLengthTraceEntry
implements OutputTraceEntry {
    protected VariableReference var;
    protected int length;

    public ArrayLengthTraceEntry(VariableReference var, Object[] value) {
        this.var = var;
        this.length = value.length;
    }

    public ArrayLengthTraceEntry(VariableReference var, int length) {
        this.var = var;
        this.length = length;
    }

    @Override
    public boolean differs(OutputTraceEntry other) {
        if (other instanceof ArrayLengthTraceEntry) {
            ArrayLengthTraceEntry otherEntry = (ArrayLengthTraceEntry)other;
            if (this.length != otherEntry.length) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Assertion> getAssertions(OutputTraceEntry other) {
        HashSet<Assertion> assertions = new HashSet<Assertion>();
        if (other instanceof ArrayLengthTraceEntry) {
            ArrayLengthTraceEntry otherEntry = (ArrayLengthTraceEntry)other;
            if (this.length != otherEntry.length) {
                ArrayLengthAssertion assertion = new ArrayLengthAssertion();
                assertion.length = this.length;
                assertion.source = this.var;
                assertion.value = this.length;
                assertions.add(assertion);
                assert (assertion.isValid());
            }
        }
        return assertions;
    }

    @Override
    public Set<Assertion> getAssertions() {
        HashSet<Assertion> assertions = new HashSet<Assertion>();
        ArrayLengthAssertion assertion = new ArrayLengthAssertion();
        assertion.source = this.var;
        assertion.length = this.length;
        assertion.value = this.length;
        assertions.add(assertion);
        assert (assertion.isValid());
        return assertions;
    }

    @Override
    public boolean isDetectedBy(Assertion assertion) {
        if (assertion instanceof ArrayLengthAssertion) {
            ArrayLengthAssertion ass = (ArrayLengthAssertion)assertion;
            if (this.var.equals(ass.source) && this.length != ass.length) {
                return true;
            }
        }
        return false;
    }

    @Override
    public OutputTraceEntry cloneEntry() {
        return new ArrayLengthTraceEntry(this.var, this.length);
    }
}

