/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.lang.reflect.Array;
import org.evosuite.assertion.ArrayLengthTraceEntry;
import org.evosuite.assertion.AssertionTraceObserver;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;

public class ArrayLengthObserver
extends AssertionTraceObserver<ArrayLengthTraceEntry> {
    @Override
    public synchronized void afterStatement(Statement statement, Scope scope, Throwable exception) {
        if (exception != null) {
            return;
        }
        if (statement instanceof FunctionalMockStatement) {
            return;
        }
        this.visitReturnValue(statement, scope);
        this.visitDependencies(statement, scope);
    }

    @Override
    protected void visit(Statement statement, Scope scope, VariableReference var) {
        logger.debug("Checking array " + var);
        try {
            if (var == null) {
                return;
            }
            if (statement instanceof PrimitiveStatement) {
                return;
            }
            if (statement instanceof AssignmentStatement) {
                return;
            }
            if (statement instanceof ArrayStatement) {
                return;
            }
            Object object = var.getObject(scope);
            if (object == null) {
                return;
            }
            if (!object.getClass().isArray()) {
                return;
            }
            if (var.getComponentClass() == null) {
                return;
            }
            int arrlength = Array.getLength(object);
            logger.debug("Observed length {} for statement {}", (Object)arrlength, (Object)statement.getCode());
            this.trace.addEntry(statement.getPosition(), var, new ArrayLengthTraceEntry(var, arrlength));
        }
        catch (CodeUnderTestException e) {
            logger.debug("", e);
        }
    }

    @Override
    public void testExecutionFinished(ExecutionResult r, Scope s) {
    }
}

