/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import java.util.List;
import org.evosuite.Properties;
import org.evosuite.assertion.InspectorManager;
import org.evosuite.contracts.ContractChecker;
import org.evosuite.contracts.FailingTestSet;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.coverage.dataflow.DefUsePool;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.coverage.mutation.MutationTimeoutStoppingCondition;
import org.evosuite.ga.archive.Archive;
import org.evosuite.ga.stoppingconditions.GlobalTimeStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.evosuite.graphs.GraphPool;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.graphs.cfg.CFGMethodAdapter;
import org.evosuite.instrumentation.InstrumentingClassLoader;
import org.evosuite.instrumentation.LinePool;
import org.evosuite.runtime.Runtime;
import org.evosuite.runtime.classhandling.ModifiedTargetStaticFields;
import org.evosuite.runtime.instrumentation.MethodCallReplacementCache;
import org.evosuite.runtime.instrumentation.RemoveFinalClassAdapter;
import org.evosuite.runtime.javaee.db.DBManager;
import org.evosuite.runtime.javaee.injection.Injector;
import org.evosuite.runtime.util.JOptionPaneInputs;
import org.evosuite.runtime.util.SystemInUtil;
import org.evosuite.seeding.CastClassManager;
import org.evosuite.seeding.ConstantPoolManager;
import org.evosuite.seeding.ObjectPoolManager;
import org.evosuite.setup.ConcreteClassAnalyzer;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.TestCluster;
import org.evosuite.setup.TestClusterGenerator;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.testcarver.extraction.CarvingManager;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testcase.execution.reset.ClassReInitializer;
import org.evosuite.utils.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGenerationContext {
    private static final Logger logger = LoggerFactory.getLogger(TestGenerationContext.class);
    private static final TestGenerationContext singleton = new TestGenerationContext();
    private InstrumentingClassLoader classLoader;
    private InstrumentingClassLoader regressionClassLoader;
    private ClassLoader originalClassLoader = this.getClass().getClassLoader();
    private TestClusterGenerator testClusterGenerator;

    private TestGenerationContext() {
        this.classLoader = new InstrumentingClassLoader();
        this.regressionClassLoader = new InstrumentingClassLoader(true);
        DBManager.getInstance().setSutClassLoader(this.classLoader);
    }

    public static TestGenerationContext getInstance() {
        return singleton;
    }

    public void goingToExecuteSUTCode() {
        Thread.currentThread().setContextClassLoader(this.classLoader);
    }

    public void doneWithExecutingSUTCode() {
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
    }

    public InstrumentingClassLoader getClassLoaderForSUT() {
        return this.classLoader;
    }

    public InstrumentingClassLoader getRegressionClassLoaderForSUT() {
        return this.regressionClassLoader;
    }

    public TestClusterGenerator getTestClusterGenerator() {
        return this.testClusterGenerator;
    }

    public void setTestClusterGenerator(TestClusterGenerator generator) {
        this.testClusterGenerator = generator;
    }

    public static ClassLoader getClassLoader() {
        return TestGenerationContext.getInstance().classLoader;
    }

    public void resetContext() {
        logger.info("*** Resetting context");
        this.classLoader = new InstrumentingClassLoader();
        if (!DBManager.getInstance().isWasAccessed()) {
            DBManager.getInstance().setSutClassLoader(this.classLoader);
        }
        TestCaseExecutor.pullDown();
        ExecutionTracer.getExecutionTracer().clear();
        BranchPool.getInstance(this.classLoader).reset();
        RemoveFinalClassAdapter.reset();
        LinePool.reset();
        MutationPool.clear();
        GraphPool.clearAll();
        DefUsePool.clear();
        for (ClassLoader cl : CFGMethodAdapter.methods.keySet()) {
            CFGMethodAdapter.methods.get(cl).clear();
        }
        BytecodeInstructionPool.clearAll();
        TestCluster.reset();
        CastClassManager.getInstance().clear();
        ConcreteClassAnalyzer.getInstance().clear();
        TestFactory.getInstance().reset();
        MaxStatementsStoppingCondition.setNumExecutedStatements(0L);
        GlobalTimeStoppingCondition.forceReset();
        MutationTimeoutStoppingCondition.resetStatic();
        Properties.resetTargetClass();
        TestCaseExecutor.initExecutor();
        Archive.getArchiveInstance().reset();
        ConstantPoolManager.getInstance().reset();
        ObjectPoolManager.getInstance().reset();
        CarvingManager.getInstance().clear();
        if (Properties.INSTRUMENT_CONTEXT || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.IBRANCH)) {
            try {
                this.testClusterGenerator = new TestClusterGenerator(DependencyAnalysis.getInheritanceTree());
                this.testClusterGenerator.generateCluster(DependencyAnalysis.getCallGraph());
            }
            catch (RuntimeException e) {
                logger.error(e.getMessage(), e);
            }
            catch (ClassNotFoundException e) {
                logger.error(e.getMessage(), e);
            }
        }
        if (Properties.CHECK_CONTRACTS) {
            FailingTestSet.changeClassLoader(this.classLoader);
        }
        ContractChecker.setActive(true);
        SystemInUtil.resetSingleton();
        JOptionPaneInputs.resetSingleton();
        Runtime.resetSingleton();
        MethodCallReplacementCache.resetSingleton();
        Injector.reset();
        DSEStats.clear();
        List<String> initializedClasses = ClassReInitializer.getInstance().getInitializedClasses();
        ClassReInitializer.resetSingleton();
        ClassReInitializer.getInstance().addInitializedClasses(initializedClasses);
        InspectorManager.resetSingleton();
        ModifiedTargetStaticFields.resetSingleton();
    }
}

