/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.evosuite.CommandLineParameters;
import org.evosuite.Properties;
import org.evosuite.classpath.ClassPathHacker;
import org.evosuite.executionmode.Continuous;
import org.evosuite.executionmode.Help;
import org.evosuite.executionmode.ListClasses;
import org.evosuite.executionmode.ListParameters;
import org.evosuite.executionmode.MeasureCoverage;
import org.evosuite.executionmode.PrintStats;
import org.evosuite.executionmode.Setup;
import org.evosuite.executionmode.TestGeneration;
import org.evosuite.executionmode.WriteDependencies;
import org.evosuite.junit.writer.TestSuiteWriterUtils;
import org.evosuite.runtime.sandbox.MSecurityManager;
import org.evosuite.setup.InheritanceTree;
import org.evosuite.setup.InheritanceTreeGenerator;
import org.evosuite.shaded.org.apache.commons.cli.CommandLine;
import org.evosuite.shaded.org.apache.commons.cli.GnuParser;
import org.evosuite.shaded.org.apache.commons.cli.Options;
import org.evosuite.shaded.org.apache.commons.cli.ParseException;
import org.evosuite.shaded.org.apache.commons.io.FileUtils;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;
import org.evosuite.utils.SpawnProcessKeepAliveChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvoSuite {
    private static Logger logger;
    private static String separator;
    public static String base_dir_path;

    public static String generateInheritanceTree(String cp) throws IOException {
        LoggingUtils.getEvoLogger().info("* Analyzing classpath (generating inheritance tree)");
        List<String> cpList = Arrays.asList(cp.split(File.pathSeparator));
        Properties.INHERITANCE_FILE = "";
        InheritanceTree tree = InheritanceTreeGenerator.createFromClassPath(cpList);
        File outputFile = File.createTempFile("ES_inheritancetree", ".xml.gz");
        outputFile.deleteOnExit();
        InheritanceTreeGenerator.writeInheritanceTree(tree, outputFile);
        return outputFile.getAbsolutePath();
    }

    private void setupProperties() {
        if (base_dir_path.equals("")) {
            Properties.getInstanceSilent();
        } else {
            Properties.getInstanceSilent().loadProperties(base_dir_path + separator + Properties.PROPERTIES_FILE, true);
        }
    }

    public Object parseCommandLine(String[] args) {
        Options options = CommandLineParameters.getCommandLineOptions();
        ArrayList<String> javaOpts = new ArrayList<String>();
        String version = EvoSuite.class.getPackage().getImplementationVersion();
        if (version == null) {
            version = "";
        }
        GnuParser parser = new GnuParser();
        try {
            Object[] unrecognized;
            CommandLine line = parser.parse(options, args);
            if (!line.hasOption("setup") && (unrecognized = line.getArgs()).length > 0) {
                String msg = "";
                msg = unrecognized.length == 1 ? "There is one unrecognized input:" : "There are " + unrecognized.length + " unrecognized inputs:";
                msg = msg + " " + Arrays.toString(unrecognized);
                msg = msg + "\nRecall, '-Dx=v' assignments should have no space, i.e. '-Dx= v' and '-Dx = v' are wrong";
                throw new IllegalArgumentException(msg);
            }
            this.setupProperties();
            if (TestSuiteWriterUtils.needToUseAgent() && Properties.JUNIT_CHECK) {
                ClassPathHacker.initializeToolJar();
            }
            if (!line.hasOption("regressionSuite")) {
                if (line.hasOption("criterion")) {
                    javaOpts.add("-Dcriterion=" + line.getOptionValue("criterion"));
                    try {
                        Properties.getInstance().setValue("criterion", line.getOptionValue("criterion"));
                    }
                    catch (Exception e) {
                        throw new Error("Invalid value for criterion: " + e.getMessage());
                    }
                }
            } else {
                javaOpts.add("-Dcriterion=regression");
            }
            CommandLineParameters.handleSeed(javaOpts, line);
            CommandLineParameters.addJavaDOptions(javaOpts, line);
            CommandLineParameters.handleClassPath(line);
            CommandLineParameters.handleJVMOptions(javaOpts, line);
            if (line.hasOption("base_dir")) {
                base_dir_path = line.getOptionValue("base_dir");
                File baseDir = new File(base_dir_path);
                if (!baseDir.exists()) {
                    LoggingUtils.getEvoLogger().error("Base directory does not exist: " + base_dir_path);
                    return null;
                }
                if (!baseDir.isDirectory()) {
                    LoggingUtils.getEvoLogger().error("Specified base directory is not a directory: " + base_dir_path);
                    return null;
                }
            }
            CommandLineParameters.validateInputOptionsAndParameters(line);
            if (!line.hasOption("listClasses")) {
                LoggingUtils.getEvoLogger().info("* EvoSuite " + version);
                String conf = Properties.CONFIGURATION_ID;
                if (conf != null && !conf.isEmpty()) {
                    LoggingUtils.getEvoLogger().info("* Configuration: " + conf);
                }
            }
            if (Properties.CLIENT_ON_THREAD) {
                MSecurityManager.setRunningClientOnThread(true);
            }
            if (Properties.SPAWN_PROCESS_MANAGER_PORT != null) {
                SpawnProcessKeepAliveChecker.getInstance().registerToRemoteServerAndDieIfFails(Properties.SPAWN_PROCESS_MANAGER_PORT);
            }
            if (line.hasOption("help")) {
                return Help.execute(options);
            }
            if (line.hasOption("setup")) {
                return Setup.execute(javaOpts, line);
            }
            if (line.hasOption("measureCoverage")) {
                return MeasureCoverage.execute(options, javaOpts, line);
            }
            if (line.hasOption("listClasses")) {
                return ListClasses.execute(options, line);
            }
            if (line.hasOption("writeDependencies")) {
                return WriteDependencies.execute(options, javaOpts, line);
            }
            if (line.hasOption("printStats")) {
                return PrintStats.execute(options, javaOpts, line);
            }
            if (line.hasOption("listParameters")) {
                return ListParameters.execute();
            }
            if (line.hasOption("continuous")) {
                return Continuous.execute(options, javaOpts, line);
            }
            return TestGeneration.executeTestGeneration(options, javaOpts, line);
        }
        catch (ParseException exp) {
            logger.error("Parsing failed.  Reason: " + exp.getMessage());
            Help.execute(options);
            return null;
        }
    }

    public static boolean hasLegacyTargets() {
        File directory = new File(Properties.OUTPUT_DIR);
        if (!directory.exists()) {
            return false;
        }
        String[] extensions = new String[]{"task"};
        return !FileUtils.listFiles(directory, extensions, false).isEmpty();
    }

    public static void main(String[] args) {
        try {
            EvoSuite evosuite = new EvoSuite();
            evosuite.parseCommandLine(args);
        }
        catch (Throwable t) {
            logger.error("Fatal crash on main EvoSuite process. Class " + Properties.TARGET_CLASS + " using seed " + Randomness.getSeed() + ". Configuration id : " + Properties.CONFIGURATION_ID, t);
            System.exit(-1);
        }
        System.exit(0);
    }

    static {
        LoggingUtils.loadLogbackForEvoSuite();
        logger = LoggerFactory.getLogger(EvoSuite.class);
        separator = System.getProperty("file.separator");
        base_dir_path = System.getProperty("user.dir");
    }
}

