/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import org.evosuite.PackageInfo;
import org.evosuite.Properties;
import org.evosuite.TimeController;
import org.evosuite.classpath.ClassPathHacker;
import org.evosuite.junit.writer.TestSuiteWriterUtils;
import org.evosuite.result.TestGenerationResult;
import org.evosuite.result.TestGenerationResultBuilder;
import org.evosuite.rmi.ClientServices;
import org.evosuite.rmi.service.MasterNodeRemote;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.classhandling.JDKClassResetter;
import org.evosuite.runtime.instrumentation.MethodCallReplacementCache;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.sandbox.MSecurityManager;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.shaded.org.dom4j.DocumentFactory;
import org.evosuite.shaded.org.dom4j.dom.DOMDocumentFactory;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;
import org.evosuite.utils.SpawnProcessKeepAliveChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientProcess {
    private static Logger logger = LoggerFactory.getLogger(ClientProcess.class);
    public static TestGenerationResult result;

    public void run() {
        Properties.getInstance();
        ClientProcess.setupRuntimeProperties();
        ClientProcess.handleShadingSpecialCases();
        JDKClassResetter.init();
        Sandbox.setCheckForInitialization(Properties.SANDBOX);
        MockFramework.enable();
        if (TestSuiteWriterUtils.needToUseAgent() && Properties.JUNIT_CHECK) {
            this.initializeToolJar();
        }
        MSecurityManager.setupMasterNodeRemoteHandling(MasterNodeRemote.class);
        LoggingUtils.getEvoLogger().info("* Connecting to master process on port " + Properties.PROCESS_COMMUNICATION_PORT);
        boolean registered = ClientServices.getInstance().registerServices();
        if (!registered) {
            result = TestGenerationResultBuilder.buildErrorResult("Could not connect to master process on port " + Properties.PROCESS_COMMUNICATION_PORT);
            throw new RuntimeException("Could not connect to master process on port " + Properties.PROCESS_COMMUNICATION_PORT);
        }
        if (Properties.SPAWN_PROCESS_MANAGER_PORT != null) {
            SpawnProcessKeepAliveChecker.getInstance().registerToRemoteServerAndDieIfFails(Properties.SPAWN_PROCESS_MANAGER_PORT);
        }
        ClientServices.getInstance().getClientNode().waitUntilDone();
        ClientServices.getInstance().stopServices();
        SpawnProcessKeepAliveChecker.getInstance().unRegister();
    }

    private void initializeToolJar() {
        ClassPathHacker.initializeToolJar();
    }

    private static void setupRuntimeProperties() {
        RuntimeSettings.useVFS = Properties.VIRTUAL_FS;
        RuntimeSettings.mockJVMNonDeterminism = Properties.REPLACE_CALLS;
        RuntimeSettings.mockSystemIn = Properties.REPLACE_SYSTEM_IN;
        RuntimeSettings.mockGUI = Properties.REPLACE_GUI;
        RuntimeSettings.sandboxMode = Properties.SANDBOX_MODE;
        RuntimeSettings.maxNumberOfThreads = Properties.MAX_STARTED_THREADS;
        RuntimeSettings.maxNumberOfIterationsPerLoop = Properties.MAX_LOOP_ITERATIONS;
        RuntimeSettings.useVNET = Properties.VIRTUAL_NET;
        RuntimeSettings.useSeparateClassLoader = Properties.USE_SEPARATE_CLASSLOADER;
        RuntimeSettings.className = Properties.TARGET_CLASS;
        RuntimeSettings.useJEE = Properties.JEE;
        RuntimeSettings.applyUIDTransformation = true;
        RuntimeSettings.isRunningASystemTest = Properties.IS_RUNNING_A_SYSTEM_TEST;
        MethodCallReplacementCache.resetSingleton();
    }

    private static void handleShadingSpecialCases() {
        String shadePrefix = PackageInfo.getShadedPackageForThirdPartyLibraries() + ".";
        if (!DocumentFactory.class.getName().startsWith(shadePrefix)) {
            return;
        }
        String defaultFactory = System.getProperty("org.evosuite.shaded.org.dom4j.factory", "org.evosuite.shaded.org.dom4j.DocumentFactory");
        String defaultDomSingletonClass = System.getProperty("org.evosuite.shaded.org.dom4j.dom.DOMDocumentFactory.singleton.strategy", "org.evosuite.shaded.org.dom4j.util.SimpleSingleton");
        String defaultSingletonClass = System.getProperty("org.evosuite.shaded.org.dom4j.DocumentFactory.singleton.strategy", "org.evosuite.shaded.org.dom4j.util.SimpleSingleton");
        System.setProperty("org.evosuite.shaded.org.dom4j.factory", shadePrefix + defaultFactory);
        System.setProperty("org.evosuite.shaded.org.dom4j.dom.DOMDocumentFactory.singleton.strategy", shadePrefix + defaultDomSingletonClass);
        System.setProperty("org.evosuite.shaded.org.dom4j.DocumentFactory.singleton.strategy", shadePrefix + defaultSingletonClass);
        DocumentFactory.getInstance();
        DOMDocumentFactory.getInstance();
        System.setProperty("org.evosuite.shaded.org.dom4j.factory", defaultFactory);
        System.setProperty("org.evosuite.shaded.org.dom4j.dom.DOMDocumentFactory.singleton.strategy", defaultDomSingletonClass);
        System.setProperty("org.evosuite.shaded.org.dom4j.DocumentFactory.singleton.strategy", defaultSingletonClass);
    }

    public static void main(String[] args) {
        block5: {
            boolean onThread = Properties.CLIENT_ON_THREAD;
            try {
                LoggingUtils.getEvoLogger().info("* Starting client");
                ClientProcess process = new ClientProcess();
                TimeController.resetSingleton();
                process.run();
                if (!onThread) {
                    System.exit(0);
                }
            }
            catch (Throwable t) {
                logger.error("Error when generating tests for: " + Properties.TARGET_CLASS + " with seed " + Randomness.getSeed() + ". Configuration id : " + Properties.CONFIGURATION_ID, t);
                t.printStackTrace();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (onThread) break block5;
                System.exit(1);
            }
        }
    }
}

