/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import java.io.Serializable;
import java.util.Collection;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.BooleanIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.api.list.primitive.BooleanList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableBooleanStack;
import org.eclipse.collections.api.stack.primitive.MutableBooleanStack;
import org.eclipse.collections.impl.factory.primitive.BooleanStacks;
import org.eclipse.collections.impl.iterator.UnmodifiableBooleanIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import org.eclipse.collections.impl.stack.mutable.primitive.UnmodifiableBooleanStack;

public class SynchronizedBooleanStack
implements MutableBooleanStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    private final MutableBooleanStack stack;

    public SynchronizedBooleanStack(MutableBooleanStack stack) {
        this(stack, null);
    }

    public SynchronizedBooleanStack(MutableBooleanStack stack, Object newLock) {
        this.stack = stack;
        this.lock = newLock == null ? this : newLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(boolean item) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.push(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pop() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BooleanList pop(int count) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.pop(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean peek() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BooleanList peek(int count) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.peek(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean peekAt(int index) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.peekAt(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.stack.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(boolean value) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(boolean ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(BooleanIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.containsAll(source);
        }
    }

    public BooleanIterator booleanIterator() {
        return new UnmodifiableBooleanIterator(this.stack.booleanIterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void each(BooleanProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anySatisfy(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allSatisfy(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noneSatisfy(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.detectIfNone(predicate, ifNone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanStack select(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanStack reject(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableStack<V> collect(BooleanToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] toArray(boolean[] target) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toArray(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.appendString(appendable, start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanList toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanSet toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanBag toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherStack) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.equals(otherStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyBooleanIterable asLazy() {
        Object object = this.lock;
        synchronized (object) {
            return new LazyBooleanIterableAdapter((BooleanIterable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanStack asUnmodifiable() {
        Object object = this.lock;
        synchronized (object) {
            return new UnmodifiableBooleanStack(this);
        }
    }

    public MutableBooleanStack asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableBooleanStack toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return BooleanStacks.immutable.withAllReversed((BooleanIterable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanStack newEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.newEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.stack.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RichIterable<BooleanIterable> chunk(int size) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.chunk(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFirst() {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(boolean value) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.indexOf(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T injectIntoWithIndex(T injectedValue, ObjectBooleanIntToObjectFunction<? super T, ? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.stack.injectIntoWithIndex(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithIndex(BooleanIntProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.stack.forEachWithIndex(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanStack selectWithIndex(BooleanIntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.selectWithIndex(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableBooleanCollection> R selectWithIndex(BooleanIntPredicate predicate, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.stack.selectWithIndex(predicate, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanStack rejectWithIndex(BooleanIntPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.rejectWithIndex(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableBooleanCollection> R rejectWithIndex(BooleanIntPredicate predicate, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.stack.rejectWithIndex(predicate, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableStack<V> collectWithIndex(BooleanIntToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.stack.collectWithIndex(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends Collection<V>> R collectWithIndex(BooleanIntToObjectFunction<? extends V> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.stack.collectWithIndex(function, target);
        }
    }
}

