/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.regex.Pattern;
import org.eclipse.californium.elements.util.Base64;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.StandardCharsets;

public class StringUtil {
    public static final char NO_SEPARATOR = '\u0000';
    private static final Pattern HOSTNAME_PATTERN = Pattern.compile("^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])$");
    private static final Pattern IP_PATTERN = Pattern.compile("^(\\[[0-9a-fA-F:]+(%\\w+)?\\]|[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})$");
    public static final String lineSeparator = System.getProperty("line.separator");
    public static final boolean SUPPORT_HOST_STRING;
    public static final String CALIFORNIUM_VERSION;
    private static final char[] BIN_TO_HEX_ARRAY;
    private static final String[] TABS;

    public static String toHostString(InetSocketAddress socketAddress) {
        if (SUPPORT_HOST_STRING) {
            return socketAddress.getHostString();
        }
        InetAddress address = socketAddress.getAddress();
        if (address != null) {
            String textAddress = address.toString();
            if (textAddress.startsWith("/")) {
                return textAddress.substring(1);
            }
            return address.getHostName();
        }
        return socketAddress.getHostName();
    }

    public static String indentation(int indentIndex) {
        if (indentIndex < 0) {
            return "";
        }
        if (indentIndex >= TABS.length) {
            return TABS[TABS.length - 1];
        }
        return TABS[indentIndex];
    }

    public static String lineSeparator() {
        return lineSeparator;
    }

    public static char[] hex2CharArray(String hex) {
        if (hex == null) {
            return null;
        }
        int length = hex.length();
        if ((1 & length) != 0) {
            throw new IllegalArgumentException("'" + hex + "' has odd length!");
        }
        char[] result = new char[length /= 2];
        int indexDest = 0;
        int indexSrc = 0;
        while (indexDest < length) {
            int digit = Character.digit(hex.charAt(indexSrc), 16);
            if (digit < 0) {
                throw new IllegalArgumentException("'" + hex + "' digit " + indexSrc + " is not hexadecimal!");
            }
            result[indexDest] = (char)(digit << 4);
            if ((digit = Character.digit(hex.charAt(++indexSrc), 16)) < 0) {
                throw new IllegalArgumentException("'" + hex + "' digit " + indexSrc + " is not hexadecimal!");
            }
            int n = indexDest++;
            result[n] = (char)(result[n] | (char)digit);
            ++indexSrc;
        }
        return result;
    }

    public static String charArray2hex(char[] charArray) {
        if (charArray != null) {
            int length = charArray.length;
            StringBuilder builder = new StringBuilder(length * 2);
            for (int index = 0; index < length; ++index) {
                int value = charArray[index] & 0xFF;
                builder.append(BIN_TO_HEX_ARRAY[value >>> 4]);
                builder.append(BIN_TO_HEX_ARRAY[value & 0xF]);
            }
            return builder.toString();
        }
        return null;
    }

    public static byte[] hex2ByteArray(String hex) {
        if (hex == null) {
            return null;
        }
        int length = hex.length();
        if ((1 & length) != 0) {
            throw new IllegalArgumentException("'" + hex + "' has odd length!");
        }
        byte[] result = new byte[length /= 2];
        int indexDest = 0;
        int indexSrc = 0;
        while (indexDest < length) {
            int digit = Character.digit(hex.charAt(indexSrc), 16);
            if (digit < 0) {
                throw new IllegalArgumentException("'" + hex + "' digit " + indexSrc + " is not hexadecimal!");
            }
            result[indexDest] = (byte)(digit << 4);
            if ((digit = Character.digit(hex.charAt(++indexSrc), 16)) < 0) {
                throw new IllegalArgumentException("'" + hex + "' digit " + indexSrc + " is not hexadecimal!");
            }
            int n = indexDest++;
            result[n] = (byte)(result[n] | (byte)digit);
            ++indexSrc;
        }
        return result;
    }

    public static String byteArray2Hex(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        if (byteArray.length == 0) {
            return "";
        }
        return StringUtil.byteArray2HexString(byteArray, '\u0000', 0);
    }

    public static String byteArray2HexString(byte[] byteArray) {
        return StringUtil.byteArray2HexString(byteArray, '\u0000', 0);
    }

    public static String byteArray2HexString(byte[] byteArray, char sep, int max) {
        if (byteArray != null && byteArray.length != 0) {
            if (max == 0 || max > byteArray.length) {
                max = byteArray.length;
            }
            StringBuilder builder = new StringBuilder(max * (sep == '\u0000' ? 2 : 3));
            for (int index = 0; index < max; ++index) {
                int value = byteArray[index] & 0xFF;
                builder.append(BIN_TO_HEX_ARRAY[value >>> 4]);
                builder.append(BIN_TO_HEX_ARRAY[value & 0xF]);
                if (sep == '\u0000' || index >= max - 1) continue;
                builder.append(sep);
            }
            return builder.toString();
        }
        return "--";
    }

    public static byte[] base64ToByteArray(String base64) {
        int pad = base64.length() % 4;
        if (pad > 0) {
            if ((pad = 4 - pad) == 1) {
                base64 = base64 + "=";
            } else if (pad == 2) {
                base64 = base64 + "==";
            } else {
                throw new IllegalArgumentException("'" + base64 + "' invalid base64!");
            }
        }
        try {
            return Base64.decode(base64);
        }
        catch (IOException e) {
            return Bytes.EMPTY;
        }
    }

    public static byte[] base64ToByteArray(char[] base64) {
        int pad = base64.length % 4;
        if (pad > 0 && (pad = 4 - pad) != 1 && pad != 2) {
            throw new IllegalArgumentException("'" + new String(base64) + "' invalid base64!");
        }
        byte[] data64 = new byte[base64.length + pad];
        for (int index = 0; index < base64.length; ++index) {
            char b = base64[index];
            if (b > '\u007f') {
                throw new IllegalArgumentException("'" + new String(base64) + "' has invalid base64 char '" + b + "'!");
            }
            data64[index] = (byte)b;
        }
        while (pad > 0) {
            --pad;
            data64[index++] = 61;
        }
        try {
            return Base64.decode(data64);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static String byteArrayToBase64(byte[] bytes) {
        return Base64.encodeBytes(bytes);
    }

    public static char[] byteArrayToBase64CharArray(byte[] bytes) {
        byte[] base64 = Base64.encodeBytesToBytes(bytes);
        char[] result = new char[base64.length];
        for (int index = 0; index < base64.length; ++index) {
            result[index] = (char)base64[index];
        }
        Bytes.clear(base64);
        return result;
    }

    public static String trunc(String text, int maxLength) {
        if (text != null && maxLength > 0 && maxLength < text.length()) {
            return text.substring(0, maxLength);
        }
        return text;
    }

    public static boolean truncateTail(StringBuilder builder, String tail) {
        int end;
        if (builder == null) {
            throw new NullPointerException("Builder must not be null!");
        }
        if (tail == null) {
            throw new NullPointerException("Tail must not be null!");
        }
        boolean truncated = false;
        int tailLength = tail.length();
        if (tailLength > 0 && (end = builder.length() - tailLength) > 0) {
            truncated = true;
            for (int index = 0; index < tailLength; ++index) {
                if (builder.charAt(index + end) == tail.charAt(index)) continue;
                truncated = false;
                break;
            }
            if (truncated) {
                builder.setLength(end);
            }
        }
        return truncated;
    }

    public static String truncateTail(String text, String tail) {
        if (text == null) {
            throw new NullPointerException("Text must not be null!");
        }
        if (tail == null) {
            throw new NullPointerException("Tail must not be null!");
        }
        if (tail.length() > 0 && text.endsWith(tail)) {
            return text.substring(0, text.length() - tail.length());
        }
        return text;
    }

    public static String toDisplayString(byte[] data, int limit) {
        if (data == null) {
            return "<no data>";
        }
        if (data.length == 0) {
            return "<empty data>";
        }
        if (data.length < limit) {
            limit = data.length;
        }
        boolean text = true;
        block3: for (byte b : data) {
            if (32 <= b) continue;
            switch (b) {
                case 9: 
                case 10: 
                case 13: {
                    continue block3;
                }
                default: {
                    text = false;
                    break block3;
                }
            }
        }
        if (text) {
            CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            ByteBuffer in = ByteBuffer.wrap(data);
            CharBuffer out = CharBuffer.allocate(limit);
            CoderResult result = decoder.decode(in, out, true);
            decoder.flush(out);
            ((Buffer)out).flip();
            if (CoderResult.OVERFLOW == result) {
                return "\"" + out + "\".. " + data.length + " bytes";
            }
            if (!result.isError()) {
                return "\"" + out + "\"";
            }
        }
        String hex = StringUtil.byteArray2HexString(data, ' ', limit);
        if (data.length > limit) {
            hex = hex + ".." + data.length + " bytes";
        }
        return hex;
    }

    public static String toString(InetAddress address) {
        if (address == null) {
            return null;
        }
        return address.getHostAddress();
    }

    public static String toString(InetSocketAddress address) {
        InetAddress addr;
        if (address == null) {
            return null;
        }
        String host = SUPPORT_HOST_STRING ? StringUtil.toHostString(address) : ((addr = address.getAddress()) != null ? StringUtil.toString(addr) : "<unresolved>");
        if (address.getAddress() instanceof Inet6Address) {
            return "[" + host + "]:" + address.getPort();
        }
        return host + ":" + address.getPort();
    }

    public static String toString(SocketAddress address) {
        if (address == null) {
            return null;
        }
        if (address instanceof InetSocketAddress) {
            return StringUtil.toString((InetSocketAddress)address);
        }
        return address.toString();
    }

    public static String toDisplayString(InetSocketAddress address) {
        if (address == null) {
            return null;
        }
        InetAddress addr = address.getAddress();
        if (addr != null && addr.isAnyLocalAddress()) {
            return "port " + address.getPort();
        }
        String name = SUPPORT_HOST_STRING ? StringUtil.toHostString(address) : "";
        String host = addr != null ? StringUtil.toString(addr) : "<unresolved>";
        name = name.equals(host) ? "" : name + "/";
        if (address.getAddress() instanceof Inet6Address) {
            return name + "[" + host + "]:" + address.getPort();
        }
        return name + host + ":" + address.getPort();
    }

    public static Object toLog(final SocketAddress address) {
        if (address == null) {
            return null;
        }
        return new Object(){

            public String toString() {
                if (address instanceof InetSocketAddress) {
                    return StringUtil.toDisplayString((InetSocketAddress)address);
                }
                return address.toString();
            }
        };
    }

    public static boolean isValidHostName(String name) {
        if (name == null) {
            return false;
        }
        return HOSTNAME_PATTERN.matcher(name).matches();
    }

    public static boolean isLiteralIpAddress(String address) {
        if (address == null) {
            return false;
        }
        return IP_PATTERN.matcher(address).matches();
    }

    public static String getUriHostname(InetAddress address) throws URISyntaxException {
        int pos;
        Inet6Address address6;
        if (address == null) {
            throw new NullPointerException("address must not be null!");
        }
        String host = address.getHostAddress();
        if (address instanceof Inet6Address && ((address6 = (Inet6Address)address).getScopedInterface() != null || address6.getScopeId() > 0) && (pos = host.indexOf(37)) > 0 && pos + 1 < host.length()) {
            String separator = "%25";
            String scope = host.substring(pos + 1);
            String hostAddress = host.substring(0, pos);
            host = hostAddress + separator + scope;
            try {
                new URI(null, null, host, -1, null, null, null);
            }
            catch (URISyntaxException e) {
                scope = scope.replaceAll("[-._~]", "");
                if (scope.isEmpty()) {
                    host = hostAddress;
                }
                host = hostAddress + separator + scope;
                try {
                    new URI(null, null, host, -1, null, null, null);
                }
                catch (URISyntaxException e2) {
                    throw e;
                }
            }
        }
        return host;
    }

    public static String normalizeLoggingTag(String tag) {
        if (tag == null) {
            tag = "";
        } else if (!tag.isEmpty() && !tag.endsWith(" ")) {
            tag = tag + " ";
        }
        return tag;
    }

    public static String toDisplayString(Certificate cert) {
        int indentIndex = 0;
        String[] lines = cert.toString().split("\n");
        StringBuilder text = new StringBuilder();
        for (String line : lines) {
            if (!(line = line.trim()).isEmpty()) {
                int indent = StringUtil.indentDelta(line);
                if (indent < 0 && line.length() == 1) {
                    indentIndex += indent;
                    indent = 0;
                }
                text.append(StringUtil.indentation(indentIndex)).append(line).append("\n");
                indentIndex += indent;
                continue;
            }
            text.append("\n");
        }
        return text.toString();
    }

    private static int indentDelta(String line) {
        int index = 0;
        int i = line.length();
        while (i > 0) {
            char c;
            if ((c = line.charAt(--i)) == '[') {
                ++index;
                continue;
            }
            if (c != ']') continue;
            --index;
        }
        if (index != 0 && line.matches("\\d+:\\s+.*")) {
            return 0;
        }
        return index;
    }

    public static String toDisplayString(PublicKey publicKey) {
        return publicKey.toString().replaceAll("\n\\s+", "\n");
    }

    public static boolean containsIgnoreCase(String[] set, String value) {
        for (String item : set) {
            if (!item.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public static String getConfiguration(String name) {
        String property;
        String value = System.getenv(name);
        if ((value == null || value.isEmpty()) && (property = System.getProperty(name)) != null) {
            value = property;
        }
        return value;
    }

    public static Long getConfigurationLong(String name) {
        String value = StringUtil.getConfiguration(name);
        if (value != null && !value.isEmpty()) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Boolean getConfigurationBoolean(String name) {
        String value = StringUtil.getConfiguration(name);
        if (value != null && !value.isEmpty()) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    public static String readFile(File file, String defaultText) {
        String content = defaultText;
        if (file.canRead()) {
            try (FileReader reader = new FileReader(file);){
                BufferedReader lineReader = new BufferedReader(reader);
                content = lineReader.readLine();
                lineReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return content;
    }

    static {
        BIN_TO_HEX_ARRAY = "0123456789ABCDEF".toCharArray();
        TABS = new String[10];
        String tab = "";
        for (int i = 0; i < TABS.length; ++i) {
            StringUtil.TABS[i] = tab;
            tab = tab + "\t";
        }
        boolean support = false;
        try {
            Method method = InetSocketAddress.class.getMethod("getHostString", new Class[0]);
            support = method != null;
        }
        catch (NoSuchMethodException method) {
            // empty catch block
        }
        SUPPORT_HOST_STRING = support;
        String version = null;
        Package pack = StringUtil.class.getPackage();
        if (pack != null && "0.0".equals(version = pack.getImplementationVersion())) {
            version = null;
        }
        CALIFORNIUM_VERSION = version;
    }
}

