package org.daisy.pipeline.modules.impl;

import java.io.File;
import java.net.URI;

import org.daisy.pipeline.modules.AbstractModuleBuilder;
import org.daisy.pipeline.modules.JarModuleBuilder;
import org.daisy.pipeline.modules.Module;
import org.daisy.pipeline.modules.ModuleRef;
import org.daisy.pipeline.xmlcatalog.XmlCatalogParser;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(
    name = "org.daisy.pipeline.modules.impl.Module_common_utils",
    service = { ModuleRef.class },
    immediate = true
)
public class Module_common_utils implements ModuleRef {
    
    private Module instance;
    private XmlCatalogParser catalogParser;
    
    public Module get() {
        if (instance == null) {
            AbstractModuleBuilder builder
            = AbstractModuleBuilder.fromContainedClass(Module_common_utils.class)
                                   .withCatalogParser(catalogParser);
            if (builder instanceof JarModuleBuilder) {
                // name, version and title not set yet
                builder.withName("common-utils")
                       .withVersion("1.1.6")
                       .withTitle("DAISY Pipeline 2 module :: Common Utilities");
            }
            instance = builder.build();
        }
        return instance;
    }
    
    @Reference(
        name = "XmlCatalogParser",
        unbind = "-",
        service = XmlCatalogParser.class,
        cardinality = ReferenceCardinality.MANDATORY,
        policy = ReferencePolicy.STATIC
    )
    public void setParser(XmlCatalogParser parser) {
        catalogParser = parser;
    }
}
