/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.api.ServerComponent;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rule.Severity;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.check.Cardinality;

public class RulesDefinitionXmlLoader
implements ServerComponent {
    public void load(RulesDefinition.NewRepository repo, InputStream input, String encoding) {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(input, encoding);
            this.load(repo, reader);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Fail to load XML file", e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(reader);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)reader);
    }

    public void load(RulesDefinition.NewRepository repo, Reader reader) {
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        xmlFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmlFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        SMInputFactory inputFactory = new SMInputFactory(xmlFactory);
        try {
            SMHierarchicCursor rootC = inputFactory.rootElementCursor(reader);
            rootC.advance();
            SMInputCursor rulesC = rootC.childElementCursor("rule");
            while (rulesC.getNext() != null) {
                this.processRule(repo, rulesC);
            }
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("XML is not valid", e);
        }
    }

    private void processRule(RulesDefinition.NewRepository repo, SMInputCursor ruleC) throws XMLStreamException {
        String priorityAttribute;
        String key = null;
        String name = null;
        String description = null;
        String internalKey = null;
        String severity = Severity.defaultSeverity();
        String status = null;
        Cardinality cardinality = Cardinality.SINGLE;
        ArrayList<ParamStruct> params = new ArrayList<ParamStruct>();
        ArrayList<String> tags = new ArrayList<String>();
        String keyAttribute = ruleC.getAttrValue("key");
        if (StringUtils.isNotBlank((String)keyAttribute)) {
            key = StringUtils.trim((String)keyAttribute);
        }
        if (StringUtils.isNotBlank((String)(priorityAttribute = ruleC.getAttrValue("priority")))) {
            severity = StringUtils.trim((String)priorityAttribute);
        }
        SMInputCursor cursor = ruleC.childElementCursor();
        while (cursor.getNext() != null) {
            String nodeName = cursor.getLocalName();
            if (StringUtils.equalsIgnoreCase((String)"name", (String)nodeName)) {
                name = StringUtils.trim((String)cursor.collectDescendantText(false));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"description", (String)nodeName)) {
                description = StringUtils.trim((String)cursor.collectDescendantText(false));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"key", (String)nodeName)) {
                key = StringUtils.trim((String)cursor.collectDescendantText(false));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"configKey", (String)nodeName)) {
                internalKey = StringUtils.trim((String)cursor.collectDescendantText(false));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"internalKey", (String)nodeName)) {
                internalKey = StringUtils.trim((String)cursor.collectDescendantText(false));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"priority", (String)nodeName)) {
                severity = StringUtils.trim((String)cursor.collectDescendantText(false));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"severity", (String)nodeName)) {
                severity = StringUtils.trim((String)cursor.collectDescendantText(false));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"cardinality", (String)nodeName)) {
                cardinality = Cardinality.valueOf((String)StringUtils.trim((String)cursor.collectDescendantText(false)));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"status", (String)nodeName)) {
                status = StringUtils.trim((String)cursor.collectDescendantText(false));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"param", (String)nodeName)) {
                params.add(this.processParameter(cursor));
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)"tag", (String)nodeName)) continue;
            tags.add(StringUtils.trim((String)cursor.collectDescendantText(false)));
        }
        RulesDefinition.NewRule rule = repo.createRule(key).setHtmlDescription(description).setSeverity(severity).setName(name).setInternalKey(internalKey).setTags(tags.toArray(new String[tags.size()])).setTemplate(cardinality == Cardinality.MULTIPLE);
        if (status != null) {
            rule.setStatus(RuleStatus.valueOf(status));
        }
        for (ParamStruct param : params) {
            rule.createParam(param.key).setDefaultValue(param.defaultValue).setType(param.type).setDescription(param.description);
        }
    }

    private ParamStruct processParameter(SMInputCursor ruleC) throws XMLStreamException {
        String typeAttribute;
        ParamStruct param = new ParamStruct();
        String keyAttribute = ruleC.getAttrValue("key");
        if (StringUtils.isNotBlank((String)keyAttribute)) {
            param.key = StringUtils.trim((String)keyAttribute);
        }
        if (StringUtils.isNotBlank((String)(typeAttribute = ruleC.getAttrValue("type")))) {
            param.type = RuleParamType.parse(typeAttribute);
        }
        SMInputCursor paramC = ruleC.childElementCursor();
        while (paramC.getNext() != null) {
            String propNodeName = paramC.getLocalName();
            String propText = StringUtils.trim((String)paramC.collectDescendantText(false));
            if (StringUtils.equalsIgnoreCase((String)"key", (String)propNodeName)) {
                param.key = propText;
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"description", (String)propNodeName)) {
                param.description = propText;
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)"type", (String)propNodeName)) {
                param.type = RuleParamType.parse(propText);
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((String)"defaultValue", (String)propNodeName)) continue;
            param.defaultValue = propText;
        }
        return param;
    }

    private static class ParamStruct {
        String key;
        String description;
        String defaultValue;
        RuleParamType type = RuleParamType.STRING;

        private ParamStruct() {
        }
    }
}

