/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import javax.annotation.Nullable;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.debt.internal.DefaultDebtRemediationFunction;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.utils.MessageException;

class DefaultDebtRemediationFunctions
implements RulesDefinition.DebtRemediationFunctions {
    private final String repoKey;
    private final String key;

    DefaultDebtRemediationFunctions(String repoKey, String key) {
        this.repoKey = repoKey;
        this.key = key;
    }

    @Override
    public DebtRemediationFunction linear(String coefficient) {
        return this.create(DebtRemediationFunction.Type.LINEAR, coefficient, null);
    }

    @Override
    public DebtRemediationFunction linearWithOffset(String coefficient, String offset) {
        return this.create(DebtRemediationFunction.Type.LINEAR_OFFSET, coefficient, offset);
    }

    @Override
    public DebtRemediationFunction constantPerIssue(String offset) {
        return this.create(DebtRemediationFunction.Type.CONSTANT_ISSUE, null, offset);
    }

    private DebtRemediationFunction create(DebtRemediationFunction.Type type, @Nullable String coefficient, @Nullable String offset) {
        try {
            return new DefaultDebtRemediationFunction(type, coefficient, offset);
        }
        catch (Exception e) {
            throw MessageException.of(String.format("The rule '%s:%s' is invalid : %s ", this.repoKey, this.key, e.getMessage()));
        }
    }
}

