/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import com.google.common.base.Preconditions;
import java.util.Locale;
import org.sonar.api.resources.Language;

public abstract class AbstractLanguage
implements Language {
    private final String key;
    private String name;

    public AbstractLanguage(String key) {
        this(key, key);
    }

    public AbstractLanguage(String key, String name) {
        Preconditions.checkArgument((key.length() <= 20 ? 1 : 0) != 0, (Object)("The following language key exceeds 20 characters: '" + key + "'"));
        this.key = key.toLowerCase(Locale.ENGLISH);
        this.name = name;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Language)) {
            return false;
        }
        Language language = (Language)o;
        return !(this.key == null ? language.getKey() != null : !this.key.equals(language.getKey()));
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    public String toString() {
        return this.name;
    }
}

