/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.issue;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.api.issue.IssueComment;
import org.sonar.api.rule.RuleKey;

public interface Issue
extends Serializable {
    public static final int MESSAGE_MAX_SIZE = 4000;
    public static final String STATUS_OPEN = "OPEN";
    public static final String STATUS_CONFIRMED = "CONFIRMED";
    public static final String STATUS_REOPENED = "REOPENED";
    public static final String STATUS_RESOLVED = "RESOLVED";
    public static final String STATUS_CLOSED = "CLOSED";
    public static final String RESOLUTION_FIXED = "FIXED";
    public static final String RESOLUTION_FALSE_POSITIVE = "FALSE-POSITIVE";
    public static final String RESOLUTION_REMOVED = "REMOVED";
    public static final List<String> RESOLUTIONS = ImmutableList.of((Object)"FALSE-POSITIVE", (Object)"FIXED", (Object)"REMOVED");
    public static final List<String> STATUSES = ImmutableList.of((Object)"OPEN", (Object)"CONFIRMED", (Object)"REOPENED", (Object)"RESOLVED", (Object)"CLOSED");

    public String key();

    public String componentKey();

    public RuleKey ruleKey();

    public String severity();

    @CheckForNull
    public String message();

    @CheckForNull
    public Integer line();

    @CheckForNull
    public Double effortToFix();

    public String status();

    @CheckForNull
    public String resolution();

    @CheckForNull
    public String reporter();

    @CheckForNull
    public String assignee();

    public Date creationDate();

    public Date updateDate();

    @CheckForNull
    public Date closeDate();

    @CheckForNull
    public String attribute(String var1);

    public Map<String, String> attributes();

    @CheckForNull
    public String authorLogin();

    @CheckForNull
    public String actionPlanKey();

    public List<IssueComment> comments();

    public boolean isNew();
}

