/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule.internal;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.rule.internal.ActiveRulesBuilder;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.Severity;

public class NewActiveRule {
    final RuleKey ruleKey;
    String name;
    String severity = Severity.defaultSeverity();
    Map<String, String> params = new HashMap<String, String>();
    String internalKey;
    String language;
    String templateRuleKey;
    private final ActiveRulesBuilder builder;

    NewActiveRule(ActiveRulesBuilder builder, RuleKey ruleKey) {
        this.builder = builder;
        this.ruleKey = ruleKey;
    }

    public NewActiveRule setName(String name) {
        this.name = name;
        return this;
    }

    public NewActiveRule setSeverity(@Nullable String severity) {
        this.severity = StringUtils.defaultIfBlank((String)severity, (String)Severity.defaultSeverity());
        return this;
    }

    public NewActiveRule setInternalKey(@Nullable String internalKey) {
        this.internalKey = internalKey;
        return this;
    }

    public NewActiveRule setTemplateRuleKey(@Nullable String templateRuleKey) {
        this.templateRuleKey = templateRuleKey;
        return this;
    }

    public NewActiveRule setLanguage(@Nullable String language) {
        this.language = language;
        return this;
    }

    public NewActiveRule setParam(String key, @Nullable String value) {
        if (value == null) {
            this.params.remove(key);
        } else {
            this.params.put(key, value);
        }
        return this;
    }

    public Map<String, String> params() {
        return this.params;
    }

    public ActiveRulesBuilder activate() {
        this.builder.activate(this);
        return this.builder;
    }
}

