/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.msvc;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.msvc.AbstractMSVCEnvFactory;
import org.codehaus.mojo.natives.msvc.RegQuery;
import org.codehaus.mojo.natives.util.EnvUtil;

public class MSVC2008x86AMD64EnvFactory
extends AbstractMSVCEnvFactory {
    private static final String VS90COMNTOOLS_ENV_KEY = "VS90COMNTOOLS";

    protected Map<String, String> createEnvs() throws NativeBuildException {
        HashMap<String, String> envs = new HashMap<String, String>();
        File vsCommonToolDir = this.getCommonToolDirectory();
        File vsInstallDir = this.getVisualStudioInstallDirectory(vsCommonToolDir);
        if (!vsInstallDir.isDirectory()) {
            throw new NativeBuildException(vsInstallDir.getPath() + " is not a directory.");
        }
        envs.put("VSINSTALLDIR", vsInstallDir.getPath());
        File vcInstallDir = new File(vsInstallDir.getPath() + "\\VC");
        if (!vcInstallDir.isDirectory()) {
            throw new NativeBuildException(vcInstallDir.getPath() + " is not a directory.");
        }
        envs.put("VCINSTALLDIR", vcInstallDir.getPath());
        File frameworkDir = new File(MSVC2008x86AMD64EnvFactory.getSystemRoot() + "\\Microsoft.NET\\Framework");
        envs.put("FrameworkDir", frameworkDir.getPath());
        File windowsSDKDir = new File("C:\\Program Files\\Microsoft SDKs\\Windows\\v6.0A");
        String value = RegQuery.getValue("REG_SZ", "HKLM\\SOFTWARE\\Microsoft\\Microsoft SDKs\\Windows", "CurrentInstallFolder");
        if (value != null) {
            windowsSDKDir = new File(value);
        }
        envs.put("WindowsSdkDir", windowsSDKDir.getPath());
        String frameworkVersion = "v2.0.50727";
        envs.put("FrameworkVersion", frameworkVersion);
        String framework35Version = "v3.5";
        envs.put("Framework35Version", framework35Version);
        String devEnvDir = vsCommonToolDir + "\\..\\IDE";
        envs.put("DevEnvDir", devEnvDir);
        String currentPathEnv = System.getProperty("java.library.path");
        String newPathEnv = devEnvDir + ";" + vcInstallDir.getPath() + "\\bin\\x86_amd64;" + vcInstallDir.getPath() + "\\bin;" + vsCommonToolDir + ";" + frameworkDir + "\\" + framework35Version + ";" + frameworkDir + "\\" + frameworkVersion + ";" + vcInstallDir.getPath() + "\\VCPackages;" + windowsSDKDir.getPath() + "\\bin;" + currentPathEnv;
        envs.put("PATH", newPathEnv);
        String currentIncludeEnv = EnvUtil.getEnv((String)"INCLUDE");
        String newIncludeEnv = vcInstallDir.getPath() + "\\ATLMFC\\INCLUDE;" + vcInstallDir.getPath() + "\\INCLUDE;" + windowsSDKDir.getPath() + "\\include;" + currentIncludeEnv;
        envs.put("INCLUDE", newIncludeEnv);
        String currentLibEnv = EnvUtil.getEnv((String)"LIB");
        String newLibEnv = vcInstallDir.getPath() + "\\ATLMFC\\LIB\\amd64;" + vcInstallDir.getPath() + "\\LIB\\amd64;" + windowsSDKDir.getPath() + "\\LIB\\x64;" + currentLibEnv;
        envs.put("LIB", newLibEnv);
        String currentLibPathEnv = EnvUtil.getEnv((String)"LIBPATH");
        String newLibPathEnv = frameworkDir + "\\" + framework35Version + ";" + frameworkDir + "\\" + frameworkVersion + ";" + vcInstallDir.getPath() + "\\ATLMFC\\LIB\\amd64;" + vcInstallDir.getPath() + "\\LIB\\amd64;" + currentLibPathEnv;
        envs.put("LIBPATH", newLibPathEnv);
        return envs;
    }

    private File getCommonToolDirectory() throws NativeBuildException {
        String envValue = System.getenv(VS90COMNTOOLS_ENV_KEY);
        if (envValue == null) {
            throw new NativeBuildException("Environment variable: VS90COMNTOOLS not available.");
        }
        return new File(envValue);
    }

    private File getVisualStudioInstallDirectory(File commonToolDir) throws NativeBuildException {
        try {
            return new File(commonToolDir, "../..").getCanonicalFile();
        }
        catch (IOException e) {
            throw new NativeBuildException("Unable to contruct Visual Studio install directory using: " + commonToolDir, (Throwable)e);
        }
    }
}

