/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.msvc;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.msvc.EnvStreamConsumer;
import org.codehaus.mojo.natives.msvc.RegQuery;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

class AbstractMSVC2017CircaEnvFactoryHelper {
    AbstractMSVC2017CircaEnvFactoryHelper() {
    }

    protected File createEnvWrapperFile(File vsInstallDir, String platform) throws IOException {
        File tmpFile = File.createTempFile("msenv", ".bat");
        String buffer = "@echo off\r\ncall \"" + vsInstallDir + "\"\\VC\\Auxiliary\\Build\\vcvarsall.bat " + platform + "\r\necho " + "================================This is the beginning of env parsing================================" + "\r\nset\r\n";
        FileUtils.fileWrite((String)tmpFile.getAbsolutePath(), (String)buffer);
        return tmpFile;
    }

    protected Map<String, String> executeCommandLine(Commandline command) throws NativeBuildException {
        EnvStreamConsumer stdout = new EnvStreamConsumer();
        DefaultConsumer stderr = new DefaultConsumer();
        try {
            CommandLineUtils.executeCommandLine((Commandline)command, (StreamConsumer)stdout, (StreamConsumer)stderr);
        }
        catch (CommandLineException e) {
            throw new NativeBuildException("Failed to execute vcvarsall.bat");
        }
        return stdout.getParsedEnv();
    }

    protected String queryVSInstallPath(String version) {
        return RegQuery.getValue("REG_SZ", "HKLM\\SOFTWARE\\WOW6432Node\\Microsoft\\VisualStudio\\SxS\\VS7", version);
    }
}

