/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.util;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class FileSet {
    private File basedir;
    private File[] files;
    private static final File[] EMPTY_FILE_ARRAY = new File[0];

    public FileSet(File basedir) {
        this(basedir, EMPTY_FILE_ARRAY);
    }

    public FileSet(File basedir, File file) {
        this(basedir, new File[]{file});
    }

    public FileSet(File basedir, String includes, String excludes) throws IOException {
        this.basedir = basedir;
        excludes = this.trimCommaSeparateString(excludes);
        includes = this.trimCommaSeparateString(includes);
        this.files = FileUtils.getFiles((File)basedir, (String)includes, (String)excludes).toArray(EMPTY_FILE_ARRAY);
    }

    public FileSet(File basedir, File[] files) {
        if (basedir == null) {
            throw new NullPointerException("basedir must not be null");
        }
        if (files == null) {
            throw new NullPointerException("files must not be null");
        }
        this.basedir = basedir;
        this.files = files;
    }

    public File getBasedir() {
        return this.basedir;
    }

    public File[] getFiles() {
        return this.files;
    }

    public String toString() {
        return "basedir = " + this.basedir + "; files = " + Arrays.asList(this.files);
    }

    private String trimCommaSeparateString(String in) {
        if (in == null || in.trim().length() == 0) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        String[] tokens = StringUtils.split((String)in, (String)",");
        for (int i = 0; i < tokens.length; ++i) {
            if (i != 0) {
                out.append(",");
            }
            out.append(tokens[i].trim());
        }
        return out.toString();
    }
}

