/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.linker;

import java.io.File;
import java.util.List;
import org.codehaus.mojo.natives.linker.AbstractLinker;
import org.codehaus.mojo.natives.linker.LinkerConfiguration;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class ArchiveLinker
extends AbstractLinker {
    public static final String EXECUTABLE = "ar";

    @Override
    protected Commandline createLinkerCommandLine(List<File> objectFiles, LinkerConfiguration config) {
        int i;
        Commandline cl = new Commandline();
        cl.setWorkingDirectory(config.getWorkingDirectory().getPath());
        String executable = EXECUTABLE;
        if (!StringUtils.isBlank((String)config.getExecutable())) {
            executable = config.getExecutable();
        }
        cl.setExecutable(executable);
        for (i = 0; i < config.getStartOptions().length; ++i) {
            cl.createArg().setValue(config.getStartOptions()[i]);
        }
        for (i = 0; i < config.getMiddleOptions().length; ++i) {
            cl.createArg().setValue(config.getMiddleOptions()[i]);
        }
        for (i = 0; i < config.getEndOptions().length; ++i) {
            cl.createArg().setValue(config.getEndOptions()[i]);
        }
        cl.createArg().setFile(config.getOutputFile());
        for (File objFile : objectFiles) {
            cl.createArg().setValue(objFile.getPath());
        }
        return cl;
    }
}

