/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.mojo.natives.parser.Parser;

public class Dependency {
    private String source;
    private long lastModified = 0L;
    private List<Dependency> dependencies;
    private Parser parser;
    private File[] includePaths;
    Dependency parent;

    public Dependency(Dependency parent, File source, Parser parser, File[] includePaths) {
        this.init(parent, source, parser, includePaths);
    }

    public Dependency(File source, Parser parser, File[] includePaths) {
        this.init(null, source, parser, includePaths);
    }

    private void init(Dependency parent, File source, Parser parser, File[] includePaths) {
        this.parent = parent;
        this.source = source.getPath();
        this.lastModified = source.lastModified();
        this.parser = parser;
        this.includePaths = includePaths == null ? new File[0] : includePaths;
    }

    public void analyze() throws IOException {
        File[] resolvedIncludeFiles;
        String[] includeNames = this.getIncludeNames();
        for (File fileName : resolvedIncludeFiles = this.resolveIncludeNames(includeNames)) {
            Dependency depend = new Dependency(this, fileName, this.parser, this.includePaths);
            if (this.getRoot().contains(depend)) continue;
            this.addDependency(depend);
        }
        for (int i = 0; i < this.getDependencies().size(); ++i) {
            Dependency depend = this.getDependencies().get(i);
            depend.analyze();
        }
    }

    private Dependency getRoot() {
        Dependency root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    public Dependency getParent() {
        return this.parent;
    }

    public long getCompositeLastModified() {
        long currentLastModify = this.lastModified;
        for (Dependency dependency : this.getDependencies()) {
            long lastModified = dependency.getCompositeLastModified();
            if (lastModified <= currentLastModify) continue;
            currentLastModify = lastModified;
        }
        return currentLastModify;
    }

    private String[] getIncludeNames() throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.source));){
            this.parser.parse(reader);
            String[] stringArray = this.parser.getIncludes();
            return stringArray;
        }
    }

    private File[] resolveIncludeNames(String[] includeNames) throws IOException {
        ArrayList<File> resolvedIncludeFiles = new ArrayList<File>(includeNames.length);
        for (String includeName : includeNames) {
            File resolvedFile = this.resolveSingleIncludeName(includeName);
            if (resolvedFile == null) continue;
            resolvedIncludeFiles.add(resolvedFile);
        }
        File[] arrayResolvedIncludeFiles = new File[resolvedIncludeFiles.size()];
        for (int j = 0; j < arrayResolvedIncludeFiles.length; ++j) {
            arrayResolvedIncludeFiles[j] = (File)resolvedIncludeFiles.get(j);
        }
        return arrayResolvedIncludeFiles;
    }

    private File resolveSingleIncludeName(String includeName) throws IOException {
        File includeFile = null;
        File[] sourcePath = new File[]{new File(new File(this.source).getParent())};
        includeFile = this.resolveSingleIncludeNameFromPaths(includeName, sourcePath);
        if (includeFile == null) {
            includeFile = this.resolveSingleIncludeNameFromPaths(includeName, this.includePaths);
        }
        return includeFile;
    }

    private File resolveSingleIncludeNameFromPaths(String includeName, File[] includePath) {
        File includeFile = null;
        for (File file : includePath) {
            File tmpFile = new File(file, includeName);
            if (!tmpFile.exists() || !tmpFile.isFile()) continue;
            includeFile = tmpFile;
            break;
        }
        return includeFile;
    }

    public void addDependency(Dependency dependency) {
        this.getDependencies().add(dependency);
    }

    public List<Dependency> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<Dependency>();
        }
        return this.dependencies;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getSource() {
        return this.source;
    }

    boolean contains(Dependency dependent) {
        if (this.source.equals(dependent.getSource())) {
            return true;
        }
        for (int i = 0; i < this.getDependencies().size(); ++i) {
            Dependency node = this.getDependencies().get(i);
            if (!node.contains(dependent)) continue;
            return true;
        }
        return false;
    }

    int getDeepDependencyCount() {
        int ret = this.getDependencies().size();
        for (int i = 0; i < this.getDependencies().size(); ++i) {
            Dependency node = this.getDependencies().get(i);
            ret += node.getDeepDependencyCount();
        }
        return ret;
    }
}

