/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.idlj;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.idlj.AbstractTranslator;
import org.codehaus.mojo.idlj.CompilerTranslator;
import org.codehaus.mojo.idlj.Define;
import org.codehaus.mojo.idlj.PackagePrefix;
import org.codehaus.mojo.idlj.PackageTranslation;
import org.codehaus.mojo.idlj.Source;
import org.codehaus.plexus.util.StringUtils;

abstract class IdljTranslator
extends AbstractTranslator
implements CompilerTranslator {
    IdljTranslator() {
    }

    private static String fixSeparator(String filename) {
        return StringUtils.replace((String)filename, (char)'\\', (char)'/');
    }

    private static String getCanonicalPath(File file) throws MojoExecutionException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't canonicalize system path: " + file.getAbsolutePath(), (Exception)e);
        }
    }

    private static String toRelativeAndFixSeparator(File fromdir, File todir, boolean replaceSlashesWithDashes) throws MojoExecutionException {
        String relative;
        if (!todir.isAbsolute()) {
            todir = new File(fromdir, todir.getPath());
        }
        String basedirPath = IdljTranslator.getCanonicalPath(fromdir);
        String absolutePath = IdljTranslator.getCanonicalPath(todir);
        if (absolutePath.equals(basedirPath)) {
            relative = ".";
        } else if (absolutePath.startsWith(basedirPath)) {
            int length = basedirPath.length() + 1;
            if (basedirPath.endsWith("\\")) {
                --length;
            }
            relative = absolutePath.substring(length);
        } else {
            relative = absolutePath;
        }
        relative = IdljTranslator.fixSeparator(relative);
        if (replaceSlashesWithDashes) {
            relative = StringUtils.replace((String)relative, (char)'/', (char)'-');
            relative = StringUtils.replace((String)relative, (char)':', (char)'-');
        }
        return relative;
    }

    @Override
    public void invokeCompiler(String sourceDirectory, File[] includeDirs, String targetDirectory, String idlFile, Source source) throws MojoExecutionException {
        List<String> args = this.getArguments(sourceDirectory, includeDirs, targetDirectory, idlFile, source);
        this.invokeCompiler(args);
    }

    abstract void invokeCompiler(List<String> var1) throws MojoExecutionException;

    private List<String> getArguments(String sourceDirectory, File[] includeDirs, String targetDirectory, String idlFile, Source source) throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-i");
        args.add(sourceDirectory);
        if (includeDirs != null && includeDirs.length > 0) {
            for (File includeDir : includeDirs) {
                args.add("-i");
                args.add(includeDir.toString());
            }
        }
        args.add("-td");
        args.add(IdljTranslator.toRelativeAndFixSeparator(new File(System.getProperty("user.dir")), new File(targetDirectory), false));
        if (source.getPackagePrefix() != null) {
            throw new MojoExecutionException("idlj compiler does not support packagePrefix");
        }
        if (source.getPackagePrefixes() != null) {
            for (PackagePrefix prefix : source.getPackagePrefixes()) {
                args.add("-pkgPrefix");
                args.add(prefix.getType());
                args.add(prefix.getPrefix());
            }
        }
        if (source.getPackageTranslations() != null) {
            for (PackageTranslation translation : source.getPackageTranslations()) {
                args.add("-pkgTranslate");
                args.add(translation.getType());
                args.add(translation.getReplacementPackage());
            }
        }
        if (source.getDefines() != null) {
            for (Define define : source.getDefines()) {
                this.addSymbolDefinition(args, define);
            }
        }
        this.addEmitOption(args, source);
        if (this.isOptionEnabled(source.compatible())) {
            args.add("-oldImplBase");
        }
        if (source.getAdditionalArguments() != null) {
            for (String arg : source.getAdditionalArguments()) {
                args.add(arg);
            }
        }
        args.add(idlFile);
        return args;
    }

    private void addSymbolDefinition(List<String> args, Define define) throws MojoExecutionException {
        if (define.getValue() != null) {
            throw new MojoExecutionException("idlj compiler unable to define symbol values");
        }
        args.add("-d");
        args.add(define.getSymbol());
    }

    private void addEmitOption(List<String> args, Source source) {
        if (this.isOptionEnabled(source.emitStubs())) {
            args.add(source.emitSkeletons() != false ? "-fallTIE" : "-fclient");
        } else {
            args.add(this.isOptionEnabled(source.emitSkeletons()) ? "-fserver" : "-fserverTIE");
        }
    }

    private boolean isOptionEnabled(Boolean option) {
        return option != null && option != false;
    }

    void invokeCompiler(Class<?> compilerClass, List<String> args) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Current dir : " + System.getProperty("user.dir")));
        if (this.isDebug()) {
            args.add(0, "-verbose");
        }
        this.invokeCompilerInProcess(compilerClass, args);
    }

    @Override
    protected int runCompiler(Class<?> compilerClass, String ... arguments) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method compilerMainMethod = compilerClass.getMethod("main", String[].class);
        Object retVal = compilerMainMethod.invoke(compilerClass, new Object[]{arguments});
        this.getLog().debug((CharSequence)("Completed with code " + retVal));
        return retVal != null && retVal instanceof Integer ? (Integer)retVal : 0;
    }
}

