/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.compensable;

import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.bytesoft.compensable.CompensableInvocation;

public final class CompensableInvocationRegistry {
    static final CompensableInvocationRegistry instance = new CompensableInvocationRegistry();
    private Map<Thread, Stack<CompensableInvocation>> invocationMap = new ConcurrentHashMap<Thread, Stack<CompensableInvocation>>();

    private CompensableInvocationRegistry() {
    }

    public void register(CompensableInvocation invocation) {
        Thread current = Thread.currentThread();
        Stack<Object> stack = this.invocationMap.get(current);
        if (stack == null) {
            stack = new Stack();
            this.invocationMap.put(current, stack);
        }
        stack.push(invocation);
    }

    public CompensableInvocation getCurrent() {
        Thread current = Thread.currentThread();
        Stack<CompensableInvocation> stack = this.invocationMap.get(current);
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    public CompensableInvocation unRegister() {
        Thread current = Thread.currentThread();
        Stack<CompensableInvocation> stack = this.invocationMap.get(current);
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        CompensableInvocation invocation = stack.pop();
        if (stack.isEmpty()) {
            this.invocationMap.remove(current);
        }
        return invocation;
    }

    public static CompensableInvocationRegistry getInstance() {
        return instance;
    }
}

