/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc.logging.deserializer;

import java.io.Serializable;
import java.util.Arrays;
import javax.inject.Inject;
import javax.transaction.xa.Xid;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.common.utils.CommonUtils;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.CompensableInvocation;
import org.bytesoft.compensable.archive.CompensableArchive;
import org.bytesoft.compensable.aware.CompensableBeanFactoryAware;
import org.bytesoft.transaction.logging.ArchiveDeserializer;
import org.bytesoft.transaction.xa.TransactionXid;
import org.bytesoft.transaction.xa.XidFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompensableArchiveDeserializer
implements ArchiveDeserializer,
CompensableBeanFactoryAware {
    static final Logger logger = LoggerFactory.getLogger(CompensableArchiveDeserializer.class);
    static final int LENGTH_OF_XID = 40;
    @Inject
    private CompensableBeanFactory beanFactory;

    public byte[] serialize(TransactionXid xid, Object obj) {
        CompensableArchive archive = (CompensableArchive)obj;
        CompensableInvocation compensable = archive.getCompensable();
        byte[] byteArray = new byte[]{};
        try {
            byteArray = CommonUtils.serializeObject((Serializable)compensable);
        }
        catch (Exception ex) {
            if (compensable == null) {
                logger.error("Error occurred while serializing compensable: {}", (Object)compensable, (Object)ex);
            }
            logger.error("Error occurred while serializing args: {}", (Object)compensable.getArgs(), (Object)ex);
        }
        String transactionResourceKey = archive.getTransactionResourceKey();
        String compensableResourceKey = archive.getCompensableResourceKey();
        byte[] transactionResourceKeyByteArray = transactionResourceKey == null ? new byte[]{} : transactionResourceKey.getBytes();
        byte[] compensableResourceKeyByteArray = compensableResourceKey == null ? new byte[]{} : compensableResourceKey.getBytes();
        byte[] resultArray = new byte[123 + transactionResourceKeyByteArray.length + 2 + compensableResourceKeyByteArray.length + byteArray.length];
        Xid identifier = archive.getIdentifier();
        byte[] globalByteArray = identifier.getGlobalTransactionId();
        byte[] branchByteArray = identifier.getBranchQualifier();
        System.arraycopy(globalByteArray, 0, resultArray, 0, 20);
        System.arraycopy(branchByteArray, 0, resultArray, 20, 20);
        Xid transactionXid = archive.getTransactionXid();
        Xid compensableXid = archive.getCompensableXid();
        byte[] transactionGlobalTransactionId = null;
        byte[] transactionBranchQualifier = null;
        byte[] compensableGlobalTransactionId = null;
        byte[] compensableBranchQualifier = null;
        if (transactionXid == null) {
            transactionGlobalTransactionId = new byte[20];
            transactionBranchQualifier = new byte[20];
        } else {
            transactionGlobalTransactionId = transactionXid.getGlobalTransactionId();
            transactionBranchQualifier = transactionXid.getBranchQualifier();
        }
        System.arraycopy(transactionGlobalTransactionId, 0, resultArray, 40, 20);
        System.arraycopy(transactionBranchQualifier, 0, resultArray, 60, 20);
        if (compensableXid == null) {
            compensableGlobalTransactionId = new byte[20];
            compensableBranchQualifier = new byte[20];
        } else {
            compensableGlobalTransactionId = compensableXid.getGlobalTransactionId();
            compensableBranchQualifier = compensableXid.getBranchQualifier();
        }
        System.arraycopy(compensableGlobalTransactionId, 0, resultArray, 80, 20);
        System.arraycopy(compensableBranchQualifier, 0, resultArray, 100, 20);
        int value = archive.isCoordinator() ? 1 : 0;
        int triedValue = archive.isTried() ? 1 : 0;
        int confirmValue = archive.isConfirmed() ? 1 : 0;
        int cancelValue = archive.isCancelled() ? 1 : 0;
        value |= triedValue << 1;
        value |= confirmValue << 2;
        resultArray[120] = (byte)(value |= cancelValue << 3);
        byte[] lengthOfTransactionResourceKey = ByteUtils.shortToByteArray((short)((short)transactionResourceKeyByteArray.length));
        byte[] lengthOfCompensableResourceKey = ByteUtils.shortToByteArray((short)((short)compensableResourceKeyByteArray.length));
        int index = 121;
        System.arraycopy(lengthOfTransactionResourceKey, 0, resultArray, index, lengthOfTransactionResourceKey.length);
        System.arraycopy(transactionResourceKeyByteArray, 0, resultArray, index += lengthOfTransactionResourceKey.length, transactionResourceKeyByteArray.length);
        System.arraycopy(lengthOfCompensableResourceKey, 0, resultArray, index += transactionResourceKeyByteArray.length, lengthOfCompensableResourceKey.length);
        System.arraycopy(compensableResourceKeyByteArray, 0, resultArray, index += lengthOfCompensableResourceKey.length, compensableResourceKeyByteArray.length);
        System.arraycopy(byteArray, 0, resultArray, index += compensableResourceKeyByteArray.length, byteArray.length);
        return resultArray;
    }

    public Object deserialize(TransactionXid xid, byte[] array) {
        byte[] globalByteArray = new byte[20];
        byte[] branchByteArray = new byte[20];
        System.arraycopy(array, 0, globalByteArray, 0, globalByteArray.length);
        System.arraycopy(array, 20, branchByteArray, 0, branchByteArray.length);
        byte[] transactionGlobalTransactionId = new byte[20];
        byte[] transactionBranchQualifier = new byte[20];
        byte[] compensableGlobalTransactionId = new byte[20];
        byte[] compensableBranchQualifier = new byte[20];
        System.arraycopy(array, 40, transactionGlobalTransactionId, 0, transactionGlobalTransactionId.length);
        System.arraycopy(array, 60, transactionBranchQualifier, 0, transactionBranchQualifier.length);
        System.arraycopy(array, 80, compensableGlobalTransactionId, 0, compensableGlobalTransactionId.length);
        System.arraycopy(array, 100, compensableBranchQualifier, 0, compensableBranchQualifier.length);
        byte value = array[120];
        boolean coordinator = (value & 1) == 1;
        boolean tried = (value >>> 1 & 1) == 1;
        boolean confirmed = (value >>> 2 & 1) == 1;
        boolean cancelled = (value >>> 3 & 1) == 1;
        int index = 121;
        byte[] lengthOfTransactionResourceKey = new byte[2];
        System.arraycopy(array, index, lengthOfTransactionResourceKey, 0, lengthOfTransactionResourceKey.length);
        short transactionResourceKeySize = ByteUtils.byteArrayToShort((byte[])lengthOfTransactionResourceKey);
        byte[] transactionResourceKeyByteArray = new byte[transactionResourceKeySize];
        System.arraycopy(array, index += lengthOfTransactionResourceKey.length, transactionResourceKeyByteArray, 0, transactionResourceKeyByteArray.length);
        byte[] lengthOfCompensableResourceKey = new byte[2];
        System.arraycopy(array, index += transactionResourceKeyByteArray.length, lengthOfCompensableResourceKey, 0, lengthOfCompensableResourceKey.length);
        short compensableResourceKeySize = ByteUtils.byteArrayToShort((byte[])lengthOfCompensableResourceKey);
        byte[] compensableResourceKeyByteArray = new byte[compensableResourceKeySize];
        System.arraycopy(array, index += lengthOfCompensableResourceKey.length, compensableResourceKeyByteArray, 0, compensableResourceKeyByteArray.length);
        String transactionResourceKey = transactionResourceKeyByteArray.length == 0 ? null : new String(transactionResourceKeyByteArray);
        String compensableResourceKey = compensableResourceKeyByteArray.length == 0 ? null : new String(compensableResourceKeyByteArray);
        int usedSize = 123 + transactionResourceKeySize + 2 + compensableResourceKeySize;
        byte[] byteArray = new byte[array.length - usedSize];
        System.arraycopy(array, index += compensableResourceKeyByteArray.length, byteArray, 0, byteArray.length);
        CompensableInvocation compensable = null;
        try {
            compensable = (CompensableInvocation)CommonUtils.deserializeObject((byte[])byteArray);
        }
        catch (Exception ex) {
            logger.error("Error occurred while deserializing object: {}", (Object)byteArray, (Object)ex);
        }
        XidFactory xidFactory = this.beanFactory.getTransactionXidFactory();
        TransactionXid transactionXid = null;
        TransactionXid compensableXid = null;
        if (!Arrays.equals(transactionGlobalTransactionId, new byte[20])) {
            TransactionXid transactionGlobalXid = xidFactory.createGlobalXid(transactionGlobalTransactionId);
            transactionXid = xidFactory.createBranchXid(transactionGlobalXid, transactionBranchQualifier);
        }
        if (!Arrays.equals(compensableGlobalTransactionId, new byte[20])) {
            TransactionXid compensableGlobalXid = xidFactory.createGlobalXid(compensableGlobalTransactionId);
            compensableXid = xidFactory.createBranchXid(compensableGlobalXid, compensableBranchQualifier);
        }
        TransactionXid globalXid = xidFactory.createGlobalXid(globalByteArray);
        TransactionXid identifier = xidFactory.createBranchXid(globalXid, branchByteArray);
        CompensableArchive archive = new CompensableArchive();
        archive.setIdentifier((Xid)identifier);
        archive.setCoordinator(coordinator);
        archive.setTried(tried);
        archive.setConfirmed(confirmed);
        archive.setCancelled(cancelled);
        archive.setCompensable(compensable);
        archive.setTransactionXid((Xid)transactionXid);
        archive.setCompensableXid((Xid)compensableXid);
        archive.setTransactionResourceKey(transactionResourceKey);
        archive.setCompensableResourceKey(compensableResourceKey);
        return archive;
    }

    public void setBeanFactory(CompensableBeanFactory tbf) {
        this.beanFactory = tbf;
    }
}

