/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.commons.lang3.StringUtils;
import org.bytesoft.bytejta.supports.jdbc.RecoveredResource;
import org.bytesoft.bytejta.supports.resource.LocalXAResourceDescriptor;
import org.bytesoft.bytejta.supports.resource.RemoteResourceDescriptor;
import org.bytesoft.bytejta.supports.wire.RemoteCoordinator;
import org.bytesoft.bytetcc.CompensableCoordinator;
import org.bytesoft.bytetcc.CompensableTransactionImpl;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.common.utils.CommonUtils;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.CompensableManager;
import org.bytesoft.compensable.TransactionContext;
import org.bytesoft.compensable.archive.CompensableArchive;
import org.bytesoft.compensable.archive.TransactionArchive;
import org.bytesoft.compensable.aware.CompensableBeanFactoryAware;
import org.bytesoft.compensable.aware.CompensableEndpointAware;
import org.bytesoft.compensable.logging.CompensableLogger;
import org.bytesoft.transaction.CommitRequiredException;
import org.bytesoft.transaction.RollbackRequiredException;
import org.bytesoft.transaction.Transaction;
import org.bytesoft.transaction.TransactionLock;
import org.bytesoft.transaction.TransactionRecovery;
import org.bytesoft.transaction.TransactionRepository;
import org.bytesoft.transaction.archive.XAResourceArchive;
import org.bytesoft.transaction.recovery.TransactionRecoveryCallback;
import org.bytesoft.transaction.recovery.TransactionRecoveryListener;
import org.bytesoft.transaction.supports.resource.XAResourceDescriptor;
import org.bytesoft.transaction.supports.serialize.XAResourceDeserializer;
import org.bytesoft.transaction.xa.TransactionXid;
import org.bytesoft.transaction.xa.XidFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionRecoveryImpl
implements TransactionRecovery,
TransactionRecoveryListener,
CompensableBeanFactoryAware,
CompensableEndpointAware {
    static final Logger logger = LoggerFactory.getLogger(TransactionRecoveryImpl.class);
    @Inject
    private CompensableBeanFactory beanFactory;
    private String endpoint;
    private final Map<TransactionXid, Transaction> recovered = new HashMap<TransactionXid, Transaction>();

    public void onRecovery(Transaction transaction) {
        org.bytesoft.transaction.TransactionContext transactionContext = transaction.getTransactionContext();
        TransactionXid xid = transactionContext.getXid();
        XidFactory xidFactory = this.beanFactory.getCompensableXidFactory();
        TransactionXid globalXid = xidFactory.createGlobalXid(xid.getGlobalTransactionId());
        this.recovered.put(globalXid, transaction);
    }

    public void startRecovery() {
        this.fireTransactionStartRecovery();
        this.fireCompensableStartRecovery();
    }

    private void fireTransactionStartRecovery() {
        TransactionRecovery transactionRecovery = this.beanFactory.getTransactionRecovery();
        transactionRecovery.startRecovery();
    }

    private void fireCompensableStartRecovery() {
        final TransactionRepository transactionRepository = this.beanFactory.getCompensableRepository();
        CompensableLogger compensableLogger = this.beanFactory.getCompensableLogger();
        compensableLogger.recover(new TransactionRecoveryCallback(){

            public void recover(org.bytesoft.transaction.archive.TransactionArchive archive) {
                this.recover((TransactionArchive)archive);
            }

            public void recover(TransactionArchive archive) {
                XidFactory transactionXidFactory = TransactionRecoveryImpl.this.beanFactory.getTransactionXidFactory();
                CompensableTransactionImpl transaction = TransactionRecoveryImpl.this.reconstructTransaction(archive);
                TransactionContext transactionContext = transaction.getTransactionContext();
                TransactionXid compensableXid = transactionContext.getXid();
                if (!transactionContext.isCompensable()) {
                    TransactionXid transactionXid = transactionXidFactory.createGlobalXid(compensableXid.getGlobalTransactionId());
                    Transaction tx = (Transaction)TransactionRecoveryImpl.this.recovered.get(transactionXid);
                    if (tx != null) {
                        tx.setTransactionalExtra((Object)transaction);
                        transaction.setTransactionalExtra(tx);
                    }
                } else {
                    TransactionRecoveryImpl.this.recoverStatusIfNecessary(transaction);
                }
                transactionRepository.putTransaction(compensableXid, (Transaction)transaction);
                transactionRepository.putErrorTransaction(compensableXid, (Transaction)transaction);
            }
        });
        CompensableCoordinator compensableCoordinator = (CompensableCoordinator)this.beanFactory.getCompensableCoordinator();
        compensableCoordinator.markParticipantReady();
    }

    public CompensableTransactionImpl reconstructTransaction(org.bytesoft.transaction.archive.TransactionArchive transactionArchive) {
        XidFactory xidFactory = this.beanFactory.getCompensableXidFactory();
        TransactionArchive archive = (TransactionArchive)transactionArchive;
        TransactionContext transactionContext = new TransactionContext();
        transactionContext.setCompensable(true);
        transactionContext.setCoordinator(archive.isCoordinator());
        transactionContext.setPropagated(archive.isPropagated());
        transactionContext.setCompensating(!archive.isPropagated());
        transactionContext.setRecoveried(true);
        transactionContext.setXid(xidFactory.createGlobalXid(archive.getXid().getGlobalTransactionId()));
        transactionContext.setPropagatedBy(transactionArchive.getPropagatedBy());
        CompensableTransactionImpl transaction = new CompensableTransactionImpl(transactionContext);
        transaction.setBeanFactory(this.beanFactory);
        transaction.setTransactionVote(archive.getVote());
        transaction.setTransactionStatus(archive.getCompensableStatus());
        transaction.setVariables(archive.getVariables());
        List participantList = archive.getRemoteResources();
        for (int i = 0; i < participantList.size(); ++i) {
            XAResourceArchive participantArchive = (XAResourceArchive)participantList.get(i);
            XAResourceDescriptor descriptor = participantArchive.getDescriptor();
            String identifier = descriptor.getIdentifier();
            transaction.getParticipantArchiveList().add(participantArchive);
            if (RemoteResourceDescriptor.class.isInstance(descriptor)) {
                RemoteResourceDescriptor resourceDescriptor = (RemoteResourceDescriptor)descriptor;
                RemoteCoordinator remoteCoordinator = resourceDescriptor.getDelegate();
                String application = remoteCoordinator.getApplication();
                transaction.getApplicationArchiveMap().put(application, participantArchive);
            }
            transaction.getParticipantArchiveMap().put(identifier, participantArchive);
        }
        List<CompensableArchive> compensableList = archive.getCompensableResourceList();
        for (int i = 0; i < compensableList.size(); ++i) {
            CompensableArchive compensableArchive = compensableList.get(i);
            transaction.getCompensableArchiveList().add(compensableArchive);
        }
        return transaction;
    }

    public void recoverStatusIfNecessary(Transaction transaction) {
        org.bytesoft.transaction.TransactionContext transactionContext = transaction.getTransactionContext();
        CompensableTransactionImpl compensable = (CompensableTransactionImpl)transaction;
        List<CompensableArchive> archiveList = compensable.getCompensableArchiveList();
        CompensableLogger compensableLogger = this.beanFactory.getCompensableLogger();
        HashMap<TransactionBranchKey, Boolean> triedMap = new HashMap<TransactionBranchKey, Boolean>();
        int triedNumber = 0;
        int unTriedNumber = 0;
        int unknownNumber = 0;
        for (int i = 0; i < archiveList.size(); ++i) {
            Boolean tried;
            CompensableArchive archive = archiveList.get(i);
            TransactionBranchKey recordKey = new TransactionBranchKey();
            recordKey.xid = archive.getTransactionXid();
            recordKey.resource = archive.getTransactionResourceKey();
            if (archive.isTried()) {
                ++triedNumber;
                triedMap.put(recordKey, Boolean.TRUE);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)recordKey.resource)) {
                ++unknownNumber;
                logger.warn("There is no valid resource participated in the trying branch transaction, the status of the branch transaction is unknown!");
                continue;
            }
            if (triedMap.containsKey(recordKey)) {
                tried = (Boolean)triedMap.get(recordKey);
                if (Boolean.TRUE.equals(tried)) {
                    archive.setTried(true);
                    ++triedNumber;
                    compensableLogger.updateCompensable(archive);
                    continue;
                }
                ++unTriedNumber;
                continue;
            }
            tried = this.calculateCompensableTried(recordKey);
            if (Boolean.TRUE.equals(tried)) {
                archive.setTried(true);
                ++triedNumber;
                triedMap.put(recordKey, Boolean.TRUE);
                compensableLogger.updateCompensable(archive);
                continue;
            }
            ++unTriedNumber;
            triedMap.put(recordKey, tried);
        }
        if (transactionContext.isCoordinator()) {
            if (triedNumber > 0 && unTriedNumber > 0) {
                transaction.setTransactionStatus(7);
                compensableLogger.updateTransaction(compensable.getTransactionArchive());
            } else if (triedNumber > 0 && unknownNumber > 0) {
                switch (transaction.getTransactionStatus()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 8: 
                    case 9: {
                        break;
                    }
                    default: {
                        transaction.setTransactionStatus(7);
                        compensableLogger.updateTransaction(compensable.getTransactionArchive());
                        break;
                    }
                }
            } else if (triedNumber > 0 && !transactionContext.isPropagated()) {
                transaction.setTransactionStatus(2);
                compensableLogger.updateTransaction(compensable.getTransactionArchive());
            }
        }
    }

    private Boolean calculateCompensableTried(TransactionBranchKey recordKey) {
        if (StringUtils.isBlank((CharSequence)recordKey.resource)) {
            logger.warn("There is no valid resource participated in the trying branch transaction, the status of the branch transaction is unknown!");
            return null;
        }
        XAResourceDeserializer resourceDeserializer = this.beanFactory.getResourceDeserializer();
        Xid transactionXid = recordKey.xid;
        try {
            LocalXAResourceDescriptor descriptor = (LocalXAResourceDescriptor)resourceDeserializer.deserialize(recordKey.resource);
            RecoveredResource resource = (RecoveredResource)descriptor.getDelegate();
            resource.recoverable(transactionXid);
            return true;
        }
        catch (XAException xaex) {
            switch (xaex.errorCode) {
                case -4: {
                    return false;
                }
                case -3: {
                    logger.warn("The database table 'bytejta' cannot found, the status of the trying branch transaction is unknown!");
                    break;
                }
                case -7: {
                    logger.error("Error occurred while recovering the branch transaction service: {}", (Object)ByteUtils.byteArrayToString((byte[])transactionXid.getGlobalTransactionId()), (Object)xaex);
                    break;
                }
                default: {
                    logger.error("Illegal state, the status of the trying branch transaction is unknown!");
                    break;
                }
            }
        }
        catch (RuntimeException rex) {
            logger.error("Illegal resources, the status of the trying branch transaction is unknown!");
        }
        return null;
    }

    public synchronized void timingRecover() {
        TransactionRepository transactionRepository = this.beanFactory.getCompensableRepository();
        List transactions = transactionRepository.getErrorTransactionList();
        int total = transactions == null ? 0 : transactions.size();
        int value = 0;
        for (int i = 0; transactions != null && i < transactions.size(); ++i) {
            Transaction transaction = (Transaction)transactions.get(i);
            org.bytesoft.transaction.TransactionContext transactionContext = transaction.getTransactionContext();
            TransactionXid xid = transactionContext.getXid();
            try {
                this.recoverTransaction(transaction);
                continue;
            }
            catch (CommitRequiredException ex) {
                logger.debug("{}| recover: branch={}, message= commit-required", (Object)ByteUtils.byteArrayToString((byte[])xid.getGlobalTransactionId()), (Object)ByteUtils.byteArrayToString((byte[])xid.getBranchQualifier()));
                continue;
            }
            catch (RollbackRequiredException ex) {
                logger.debug("{}| recover: branch={}, message= rollback-required", (Object)ByteUtils.byteArrayToString((byte[])xid.getGlobalTransactionId()), (Object)ByteUtils.byteArrayToString((byte[])xid.getBranchQualifier()));
                continue;
            }
            catch (SystemException ex) {
                logger.debug("{}| recover: branch={}, message= {}", new Object[]{ByteUtils.byteArrayToString((byte[])xid.getGlobalTransactionId()), ByteUtils.byteArrayToString((byte[])xid.getBranchQualifier()), ex.getMessage()});
                continue;
            }
            catch (RuntimeException ex) {
                logger.debug("{}| recover: branch={}, message= {}", new Object[]{ByteUtils.byteArrayToString((byte[])xid.getGlobalTransactionId()), ByteUtils.byteArrayToString((byte[])xid.getBranchQualifier()), ex.getMessage()});
            }
        }
        logger.debug("transaction-recovery: total= {}, success= {}", (Object)total, (Object)value);
    }

    public void recoverTransaction(Transaction transaction) throws CommitRequiredException, RollbackRequiredException, SystemException {
        org.bytesoft.transaction.TransactionContext transactionContext = transaction.getTransactionContext();
        if (transactionContext.isCoordinator()) {
            transaction.recover();
            this.recoverCoordinator(transaction);
        } else {
            transaction.recover();
            this.recoverParticipant(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void recoverCoordinator(Transaction transaction) throws CommitRequiredException, RollbackRequiredException, SystemException {
        CompensableManager compensableManager = this.beanFactory.getCompensableManager();
        TransactionLock compensableLock = this.beanFactory.getCompensableLock();
        org.bytesoft.transaction.TransactionContext transactionContext = transaction.getTransactionContext();
        TransactionXid xid = transactionContext.getXid();
        boolean forgetRequired = false;
        boolean locked = false;
        try {
            compensableManager.associateThread(transaction);
            switch (transaction.getTransactionStatus()) {
                case 0: 
                case 1: 
                case 5: 
                case 7: {
                    if (transactionContext.isPropagated()) return;
                    locked = compensableLock.lockTransaction(xid, this.endpoint);
                    if (!locked) {
                        throw new SystemException();
                    }
                    transaction.recoveryRollback();
                    forgetRequired = true;
                    return;
                }
                case 9: {
                    locked = compensableLock.lockTransaction(xid, this.endpoint);
                    if (!locked) {
                        throw new SystemException();
                    }
                    transaction.recoveryRollback();
                    forgetRequired = true;
                    return;
                }
                case 2: 
                case 8: {
                    locked = compensableLock.lockTransaction(xid, this.endpoint);
                    if (!locked) {
                        throw new SystemException();
                    }
                    transaction.recoveryCommit();
                    forgetRequired = true;
                    return;
                }
                case 3: 
                case 4: {
                    forgetRequired = true;
                    return;
                }
            }
            return;
        }
        finally {
            compensableManager.desociateThread();
            if (locked) {
                compensableLock.unlockTransaction(xid, this.endpoint);
            }
            if (forgetRequired) {
                transaction.forgetQuietly();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void recoverParticipant(Transaction transaction) throws CommitRequiredException, RollbackRequiredException, SystemException {
        CompensableManager compensableManager = this.beanFactory.getCompensableManager();
        try {
            compensableManager.associateThread(transaction);
            switch (transaction.getTransactionStatus()) {
                case 3: 
                case 4: {
                    transaction.forgetQuietly();
                    return;
                }
            }
            return;
        }
        finally {
            compensableManager.desociateThread();
        }
    }

    public void setEndpoint(String identifier) {
        this.endpoint = identifier;
    }

    public void setBeanFactory(CompensableBeanFactory tbf) {
        this.beanFactory = tbf;
    }

    private static class TransactionBranchKey {
        public Xid xid;
        public String resource;

        private TransactionBranchKey() {
        }

        public int hashCode() {
            int hash = 3;
            hash += 7 * (this.xid == null ? 0 : this.xid.hashCode());
            return hash += 11 * (this.resource == null ? 0 : this.resource.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!TransactionBranchKey.class.isInstance(obj)) {
                return false;
            }
            TransactionBranchKey that = (TransactionBranchKey)obj;
            boolean xidEquals = CommonUtils.equals((Object)this.xid, (Object)that.xid);
            boolean resEquals = StringUtils.equals((CharSequence)this.resource, (CharSequence)that.resource);
            return xidEquals && resEquals;
        }
    }
}

