/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.bytesoft.bytejta.supports.wire.RemoteCoordinator;
import org.bytesoft.bytetcc.CompensableTransactionImpl;
import org.bytesoft.bytetcc.supports.CompensableSynchronization;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.CompensableManager;
import org.bytesoft.compensable.CompensableTransaction;
import org.bytesoft.compensable.TransactionContext;
import org.bytesoft.compensable.aware.CompensableBeanFactoryAware;
import org.bytesoft.compensable.aware.CompensableEndpointAware;
import org.bytesoft.compensable.logging.CompensableLogger;
import org.bytesoft.transaction.TransactionLock;
import org.bytesoft.transaction.TransactionManager;
import org.bytesoft.transaction.TransactionRepository;
import org.bytesoft.transaction.supports.TransactionListener;
import org.bytesoft.transaction.supports.TransactionResourceListener;
import org.bytesoft.transaction.xa.TransactionXid;
import org.bytesoft.transaction.xa.XidFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompensableManagerImpl
implements CompensableManager,
CompensableBeanFactoryAware,
CompensableEndpointAware {
    static final Logger logger = LoggerFactory.getLogger(CompensableManagerImpl.class);
    @Inject
    private CompensableBeanFactory beanFactory;
    private String endpoint;
    private final Map<Thread, org.bytesoft.transaction.Transaction> compensableMap = new ConcurrentHashMap<Thread, org.bytesoft.transaction.Transaction>();

    public void associateThread(org.bytesoft.transaction.Transaction transaction) {
        this.compensableMap.put(Thread.currentThread(), (CompensableTransaction)transaction);
    }

    public CompensableTransaction desociateThread() {
        return (CompensableTransaction)this.compensableMap.remove(Thread.currentThread());
    }

    public int getStatus() throws SystemException {
        org.bytesoft.transaction.Transaction transaction = this.getTransactionQuietly();
        return transaction == null ? 6 : transaction.getStatus();
    }

    public org.bytesoft.transaction.Transaction getTransaction(Thread thread) {
        CompensableTransaction transaction = this.getCompensableTransaction(thread);
        return transaction == null ? null : transaction.getTransaction();
    }

    public org.bytesoft.transaction.Transaction getTransactionQuietly() {
        CompensableTransaction transaction = this.getCompensableTransactionQuietly();
        return transaction == null ? null : transaction.getTransaction();
    }

    public org.bytesoft.transaction.Transaction getTransaction() throws SystemException {
        CompensableTransaction transaction = this.getCompensableTransactionQuietly();
        return transaction == null ? null : transaction.getTransaction();
    }

    public CompensableTransaction getCompensableTransactionQuietly() {
        return (CompensableTransaction)this.compensableMap.get(Thread.currentThread());
    }

    public CompensableTransaction getCompensableTransaction(Thread thread) {
        return (CompensableTransaction)this.compensableMap.get(thread);
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (!org.bytesoft.transaction.Transaction.class.isInstance(tobj)) {
            throw new InvalidTransactionException();
        }
        TransactionManager transactionManager = this.beanFactory.getTransactionManager();
        org.bytesoft.transaction.Transaction transaction = (org.bytesoft.transaction.Transaction)tobj;
        CompensableTransaction compensable = (CompensableTransaction)transaction.getTransactionalExtra();
        compensable.setTransactionalExtra(transaction);
        compensable.resume();
        TransactionContext compensableContext = compensable.getTransactionContext();
        compensableContext.setPropagationLevel(compensableContext.getPropagationLevel() - 1);
        transactionManager.resume((Transaction)transaction);
    }

    public org.bytesoft.transaction.Transaction suspend() throws SystemException {
        CompensableTransaction compensable = (CompensableTransaction)this.compensableMap.get(Thread.currentThread());
        if (compensable == null) {
            throw new SystemException();
        }
        TransactionManager transactionManager = this.beanFactory.getTransactionManager();
        org.bytesoft.transaction.Transaction transaction = transactionManager.suspend();
        TransactionContext compensableContext = compensable.getTransactionContext();
        compensableContext.setPropagationLevel(compensableContext.getPropagationLevel() + 1);
        compensable.suspend();
        compensable.setTransactionalExtra(null);
        return transaction;
    }

    public void begin() throws NotSupportedException, SystemException {
        CompensableTransaction compensable = this.getCompensableTransactionQuietly();
        if (compensable == null || compensable.getTransaction() != null) {
            throw new SystemException();
        }
        TransactionContext compensableContext = compensable.getTransactionContext();
        XidFactory transactionXidFactory = this.beanFactory.getTransactionXidFactory();
        TransactionXid transactionXid = transactionXidFactory.createGlobalXid();
        TransactionContext transactionContext = compensableContext.clone();
        transactionContext.setXid(transactionXid);
        this.invokeBegin(transactionContext, false);
    }

    protected void invokeBegin(TransactionContext transactionContext, boolean createFlag) throws NotSupportedException, SystemException {
        RemoteCoordinator transactionCoordinator = this.beanFactory.getTransactionCoordinator();
        CompensableTransaction compensable = this.getCompensableTransactionQuietly();
        TransactionContext compensableContext = compensable.getTransactionContext();
        TransactionXid compensableXid = compensableContext.getXid();
        TransactionXid transactionXid = transactionContext.getXid();
        try {
            org.bytesoft.transaction.Transaction transaction = transactionCoordinator.start((org.bytesoft.transaction.TransactionContext)transactionContext, 0);
            transaction.setTransactionalExtra((Object)compensable);
            compensable.setTransactionalExtra(transaction);
            transaction.registerTransactionResourceListener((TransactionResourceListener)compensable);
            transaction.registerTransactionListener((TransactionListener)compensable);
            CompensableSynchronization synchronization = this.beanFactory.getCompensableSynchronization();
            synchronization.afterBegin(compensable.getTransaction(), createFlag);
        }
        catch (XAException tex) {
            logger.info("[{}] begin-transaction: error occurred while starting jta-transaction: {}", new Object[]{ByteUtils.byteArrayToString((byte[])compensableXid.getGlobalTransactionId()), ByteUtils.byteArrayToString((byte[])transactionXid.getGlobalTransactionId()), tex});
            try {
                transactionCoordinator.end((org.bytesoft.transaction.TransactionContext)transactionContext, 0x20000000);
                throw new SystemException("Error occurred while beginning a compensable-transaction!");
            }
            catch (XAException ignore) {
                throw new SystemException("Error occurred while beginning a compensable-transaction!");
            }
        }
    }

    protected void invokeRollbackInBegin(TransactionContext transactionContext) throws NotSupportedException, SystemException {
        RemoteCoordinator transactionCoordinator = this.beanFactory.getTransactionCoordinator();
        CompensableTransaction compensable = this.getCompensableTransactionQuietly();
        TransactionContext compensableContext = compensable.getTransactionContext();
        TransactionXid compensableXid = compensableContext.getXid();
        TransactionXid transactionXid = transactionContext.getXid();
        try {
            transactionCoordinator.end((org.bytesoft.transaction.TransactionContext)transactionContext, 0x20000000);
            transactionCoordinator.rollback((Xid)transactionXid);
        }
        catch (XAException tex) {
            logger.info("[{}] begin-transaction: error occurred while starting jta-transaction: {}", new Object[]{ByteUtils.byteArrayToString((byte[])compensableXid.getGlobalTransactionId()), ByteUtils.byteArrayToString((byte[])transactionXid.getGlobalTransactionId()), tex});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compensableBegin() throws NotSupportedException, SystemException {
        if (this.getCompensableTransactionQuietly() != null) {
            throw new NotSupportedException();
        }
        CompensableLogger compensableLogger = this.beanFactory.getCompensableLogger();
        TransactionLock compensableLock = this.beanFactory.getCompensableLock();
        TransactionRepository compensableRepository = this.beanFactory.getCompensableRepository();
        RemoteCoordinator compensableCoordinator = this.beanFactory.getCompensableCoordinator();
        XidFactory transactionXidFactory = this.beanFactory.getTransactionXidFactory();
        XidFactory compensableXidFactory = this.beanFactory.getCompensableXidFactory();
        TransactionXid compensableXid = compensableXidFactory.createGlobalXid();
        TransactionXid transactionXid = transactionXidFactory.createGlobalXid(compensableXid.getGlobalTransactionId());
        TransactionContext compensableContext = new TransactionContext();
        compensableContext.setCoordinator(true);
        compensableContext.setCompensable(true);
        compensableContext.setXid(compensableXid);
        compensableContext.setPropagatedBy(compensableCoordinator.getIdentifier());
        CompensableTransactionImpl compensable = new CompensableTransactionImpl(compensableContext);
        compensable.setBeanFactory(this.beanFactory);
        this.associateThread(compensable);
        TransactionContext transactionContext = new TransactionContext();
        transactionContext.setXid(transactionXid);
        boolean failure = true;
        try {
            this.invokeBegin(transactionContext, true);
            failure = false;
        }
        finally {
            if (failure) {
                this.desociateThread();
            }
        }
        compensableRepository.putTransaction(compensableXid, (org.bytesoft.transaction.Transaction)compensable);
        compensableLogger.createTransaction(compensable.getTransactionArchive());
        boolean locked = compensableLock.lockTransaction(compensableXid, this.endpoint);
        if (!locked) {
            this.invokeRollbackInBegin(transactionContext);
            compensableLogger.deleteTransaction(compensable.getTransactionArchive());
            this.desociateThread();
            compensableRepository.removeTransaction(compensableXid);
            throw new SystemException();
        }
        logger.info("{}| compensable transaction begin!", (Object)ByteUtils.byteArrayToString((byte[])compensableXid.getGlobalTransactionId()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        CompensableTransaction transaction = this.getCompensableTransactionQuietly();
        if (transaction == null) {
            throw new IllegalStateException();
        }
        TransactionContext transactionContext = transaction.getTransactionContext();
        boolean coordinator = transactionContext.isCoordinator();
        boolean propagated = transactionContext.isPropagated();
        boolean compensable = transactionContext.isCompensable();
        boolean compensating = transactionContext.isCompensating();
        int propagatedLevel = transactionContext.getPropagationLevel();
        if (!compensable) {
            throw new IllegalStateException();
        }
        if (compensating) {
            this.invokeTransactionCommit(transaction);
            return;
        } else if (coordinator) {
            if (propagated) {
                this.invokeTransactionCommit(transaction);
                return;
            } else {
                if (propagatedLevel <= 0) throw new IllegalStateException();
                this.invokeTransactionCommit(transaction);
            }
            return;
        } else {
            this.invokeTransactionCommit(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeTransactionCommit(CompensableTransaction compensable) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        org.bytesoft.transaction.Transaction transaction = compensable.getTransaction();
        boolean isLocalTransaction = transaction.isLocalTransaction();
        try {
            if (isLocalTransaction) {
                this.invokeTransactionCommitIfLocalTransaction(compensable);
            } else {
                this.invokeTransactionCommitIfNotLocalTransaction(compensable);
            }
        }
        finally {
            compensable.setTransactionalExtra(null);
        }
    }

    protected void invokeTransactionCommitIfLocalTransaction(CompensableTransaction compensable) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        org.bytesoft.transaction.Transaction transaction = compensable.getTransaction();
        org.bytesoft.transaction.TransactionContext transactionContext = transaction.getTransactionContext();
        RemoteCoordinator transactionCoordinator = this.beanFactory.getTransactionCoordinator();
        TransactionXid transactionXid = transactionContext.getXid();
        try {
            transactionCoordinator.end(transactionContext, 0x4000000);
            transactionCoordinator.commit((Xid)transactionXid, true);
        }
        catch (XAException xaEx) {
            switch (xaEx.errorCode) {
                case 7: {
                    transactionCoordinator.forgetQuietly((Xid)transactionXid);
                    break;
                }
                case 6: {
                    transactionCoordinator.forgetQuietly((Xid)transactionXid);
                    HeuristicRollbackException hrex = new HeuristicRollbackException();
                    hrex.initCause((Throwable)xaEx);
                    throw hrex;
                }
                case 5: {
                    transactionCoordinator.forgetQuietly((Xid)transactionXid);
                    HeuristicMixedException hmex = new HeuristicMixedException();
                    hmex.initCause((Throwable)xaEx);
                    throw hmex;
                }
                default: {
                    transactionCoordinator.forgetQuietly((Xid)transactionXid);
                    SystemException sysEx = new SystemException();
                    sysEx.initCause((Throwable)xaEx);
                    throw sysEx;
                }
            }
        }
    }

    protected void invokeTransactionCommitIfNotLocalTransaction(CompensableTransaction compensable) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        org.bytesoft.transaction.Transaction transaction = compensable.getTransaction();
        org.bytesoft.transaction.TransactionContext transactionContext = transaction.getTransactionContext();
        RemoteCoordinator transactionCoordinator = this.beanFactory.getTransactionCoordinator();
        TransactionXid transactionXid = transactionContext.getXid();
        try {
            transactionCoordinator.end(transactionContext, 0x4000000);
            TransactionContext compensableContext = compensable.getTransactionContext();
            logger.error("[{}] jta-transaction in try-phase cannot be xa transaction.", (Object)ByteUtils.byteArrayToString((byte[])compensableContext.getXid().getGlobalTransactionId()));
            transactionCoordinator.rollback((Xid)transactionXid);
            throw new HeuristicRollbackException();
        }
        catch (XAException xaEx) {
            transactionCoordinator.forgetQuietly((Xid)transactionXid);
            SystemException sysEx = new SystemException();
            sysEx.initCause((Throwable)xaEx);
            throw sysEx;
        }
    }

    public void fireCompensableCommit(CompensableTransaction transaction) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        try {
            this.associateThread(transaction);
            transaction.commit();
        }
        finally {
            this.desociateThread();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        CompensableTransaction transaction = this.getCompensableTransactionQuietly();
        if (transaction == null) {
            throw new IllegalStateException();
        }
        TransactionContext transactionContext = transaction.getTransactionContext();
        boolean coordinator = transactionContext.isCoordinator();
        boolean propagated = transactionContext.isPropagated();
        boolean compensable = transactionContext.isCompensable();
        int propagatedLevel = transactionContext.getPropagationLevel();
        if (!compensable) {
            throw new IllegalStateException();
        }
        if (coordinator) {
            if (propagated) {
                this.invokeTransactionRollback(transaction);
                return;
            } else {
                if (propagatedLevel <= 0) throw new IllegalStateException();
                this.invokeTransactionRollback(transaction);
            }
            return;
        } else {
            this.invokeTransactionRollback(transaction);
        }
    }

    protected void invokeTransactionRollback(CompensableTransaction compensable) throws IllegalStateException, SecurityException, SystemException {
        org.bytesoft.transaction.Transaction transaction = compensable.getTransaction();
        org.bytesoft.transaction.TransactionContext transactionContext = transaction.getTransactionContext();
        RemoteCoordinator transactionCoordinator = this.beanFactory.getTransactionCoordinator();
        TransactionXid transactionXid = transactionContext.getXid();
        try {
            transactionCoordinator.end(transactionContext, 0x4000000);
            transactionCoordinator.rollback((Xid)transactionXid);
        }
        catch (XAException xaEx) {
            transactionCoordinator.forgetQuietly((Xid)transactionXid);
            SystemException sysEx = new SystemException();
            sysEx.initCause((Throwable)xaEx);
            throw sysEx;
        }
        finally {
            compensable.setTransactionalExtra(null);
        }
    }

    public void fireCompensableRollback(CompensableTransaction transaction) throws IllegalStateException, SecurityException, SystemException {
        try {
            this.associateThread(transaction);
            transaction.rollback();
        }
        finally {
            this.desociateThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compensableCommit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        CompensableTransaction transaction = this.getCompensableTransactionQuietly();
        if (transaction == null) {
            throw new IllegalStateException();
        }
        if (transaction.getTransaction() == null) {
            throw new IllegalStateException();
        }
        TransactionContext transactionContext = transaction.getTransactionContext();
        boolean coordinator = transactionContext.isCoordinator();
        boolean compensable = transactionContext.isCompensable();
        boolean compensating = transactionContext.isCompensating();
        if (!compensable) {
            throw new IllegalStateException();
        }
        if (!coordinator) {
            throw new IllegalStateException();
        }
        if (compensating) {
            throw new IllegalStateException();
        }
        TransactionLock compensableLock = this.beanFactory.getCompensableLock();
        TransactionXid xid = transactionContext.getXid();
        boolean success = false;
        try {
            this.desociateThread();
            this.invokeCompensableCommit(transaction);
            success = true;
        }
        finally {
            compensableLock.unlockTransaction(xid, this.endpoint);
            if (success) {
                transaction.forgetQuietly();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeCompensableCommit(CompensableTransaction compensable) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        TransactionRepository compensableRepository = this.beanFactory.getCompensableRepository();
        org.bytesoft.transaction.Transaction transaction = compensable.getTransaction();
        TransactionContext compensableContext = compensable.getTransactionContext();
        boolean commitExists = false;
        boolean rollbackExists = false;
        boolean errorExists = false;
        boolean isLocalTransaction = transaction.isLocalTransaction();
        try {
            if (isLocalTransaction) {
                this.invokeCompensableCommitIfLocalTransaction(compensable);
                commitExists = true;
            } else {
                this.invokeCompensableCommitIfNotLocalTransaction(compensable);
            }
        }
        catch (HeuristicRollbackException ex) {
            logger.info("Transaction in try-phase has already been rolled back heuristically.", (Throwable)ex);
            rollbackExists = true;
        }
        catch (SystemException ex) {
            logger.info("Error occurred while committing transaction in try-phase.", (Throwable)ex);
            errorExists = true;
        }
        catch (RuntimeException ex) {
            logger.info("Error occurred while committing transaction in try-phase.", (Throwable)ex);
            errorExists = true;
        }
        finally {
            compensable.setTransactionalExtra(null);
        }
        boolean failure = true;
        try {
            if (errorExists) {
                this.fireCompensableRollback(compensable);
                failure = false;
            } else if (commitExists) {
                this.fireCompensableCommit(compensable);
                failure = false;
            } else {
                if (rollbackExists) {
                    this.fireCompensableRollback(compensable);
                    failure = false;
                    throw new HeuristicRollbackException();
                }
                failure = false;
            }
        }
        finally {
            TransactionXid xid = compensableContext.getXid();
            if (failure) {
                compensableRepository.putErrorTransaction(xid, (org.bytesoft.transaction.Transaction)compensable);
            }
        }
    }

    protected void invokeCompensableCommitIfLocalTransaction(CompensableTransaction compensable) throws HeuristicRollbackException, SystemException {
        RemoteCoordinator transactionCoordinator = this.beanFactory.getTransactionCoordinator();
        org.bytesoft.transaction.Transaction transaction = compensable.getTransaction();
        org.bytesoft.transaction.TransactionContext transactionContext = transaction.getTransactionContext();
        TransactionXid transactionXid = transactionContext.getXid();
        try {
            transactionCoordinator.end(transactionContext, 0x4000000);
            transactionCoordinator.commit((Xid)transactionXid, true);
        }
        catch (XAException xaex) {
            switch (xaex.errorCode) {
                case 7: {
                    transactionCoordinator.forgetQuietly((Xid)transactionXid);
                    break;
                }
                case 6: {
                    transactionCoordinator.forgetQuietly((Xid)transactionXid);
                    HeuristicRollbackException hrex = new HeuristicRollbackException();
                    hrex.initCause((Throwable)xaex);
                    throw hrex;
                }
                default: {
                    transactionCoordinator.forgetQuietly((Xid)transactionXid);
                    SystemException sysEx = new SystemException();
                    sysEx.initCause((Throwable)xaex);
                    throw sysEx;
                }
            }
        }
    }

    protected void invokeCompensableCommitIfNotLocalTransaction(CompensableTransaction compensable) throws HeuristicRollbackException, SystemException {
        RemoteCoordinator transactionCoordinator = this.beanFactory.getTransactionCoordinator();
        org.bytesoft.transaction.Transaction transaction = compensable.getTransaction();
        org.bytesoft.transaction.TransactionContext transactionContext = transaction.getTransactionContext();
        TransactionXid transactionXid = transactionContext.getXid();
        try {
            transactionCoordinator.end(transactionContext, 0x4000000);
            TransactionContext compensableContext = compensable.getTransactionContext();
            logger.error("{}| jta-transaction in compensating-phase cannot be xa transaction.", (Object)ByteUtils.byteArrayToString((byte[])compensableContext.getXid().getGlobalTransactionId()));
            transactionCoordinator.rollback((Xid)transactionXid);
            throw new HeuristicRollbackException();
        }
        catch (XAException xaex) {
            transactionCoordinator.forgetQuietly((Xid)transactionXid);
            SystemException sysEx = new SystemException();
            sysEx.initCause((Throwable)xaex);
            throw sysEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compensableRollback() throws IllegalStateException, SecurityException, SystemException {
        CompensableTransaction transaction = this.getCompensableTransactionQuietly();
        if (transaction == null) {
            throw new IllegalStateException();
        }
        TransactionContext transactionContext = transaction.getTransactionContext();
        boolean coordinator = transactionContext.isCoordinator();
        boolean compensable = transactionContext.isCompensable();
        boolean compensating = transactionContext.isCompensating();
        if (!compensable) {
            throw new IllegalStateException();
        }
        if (!coordinator) {
            throw new IllegalStateException();
        }
        if (compensating) {
            throw new IllegalStateException();
        }
        TransactionLock compensableLock = this.beanFactory.getCompensableLock();
        TransactionXid xid = transactionContext.getXid();
        boolean success = false;
        try {
            this.desociateThread();
            this.invokeCompensableRollback(transaction);
            success = true;
        }
        finally {
            compensableLock.unlockTransaction(xid, this.endpoint);
            if (success) {
                transaction.forgetQuietly();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeCompensableRollback(CompensableTransaction compensable) throws IllegalStateException, SecurityException, SystemException {
        TransactionRepository compensableRepository = this.beanFactory.getCompensableRepository();
        RemoteCoordinator transactionCoordinator = this.beanFactory.getTransactionCoordinator();
        org.bytesoft.transaction.Transaction transaction = compensable.getTransaction();
        TransactionContext compensableContext = compensable.getTransactionContext();
        org.bytesoft.transaction.TransactionContext transactionContext = transaction.getTransactionContext();
        TransactionXid transactionXid = transactionContext.getXid();
        try {
            transactionCoordinator.end(transactionContext, 0x4000000);
            transactionCoordinator.rollback((Xid)transactionXid);
        }
        catch (XAException ex) {
            transactionCoordinator.forgetQuietly((Xid)transactionXid);
            logger.error("Error occurred while rolling back transaction in try phase!", (Throwable)ex);
        }
        finally {
            compensable.setTransactionalExtra(null);
        }
        boolean failure = true;
        try {
            this.fireCompensableRollback(compensable);
            failure = false;
        }
        finally {
            TransactionXid xid = compensableContext.getXid();
            if (failure) {
                compensableRepository.putErrorTransaction(xid, (org.bytesoft.transaction.Transaction)compensable);
            }
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
    }

    public int getTimeoutSeconds() {
        return 0;
    }

    public void setTimeoutSeconds(int timeoutSeconds) {
    }

    public void setBeanFactory(CompensableBeanFactory tbf) {
        this.beanFactory = tbf;
    }

    public void setEndpoint(String identifier) {
        this.endpoint = identifier;
    }
}

