/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.bytetcc;

import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.bytesoft.bytejta.supports.wire.RemoteCoordinator;
import org.bytesoft.bytetcc.CompensableTransactionImpl;
import org.bytesoft.common.utils.ByteUtils;
import org.bytesoft.compensable.CompensableBeanFactory;
import org.bytesoft.compensable.CompensableManager;
import org.bytesoft.compensable.CompensableTransaction;
import org.bytesoft.compensable.TransactionContext;
import org.bytesoft.compensable.aware.CompensableBeanFactoryAware;
import org.bytesoft.compensable.aware.CompensableEndpointAware;
import org.bytesoft.compensable.logging.CompensableLogger;
import org.bytesoft.transaction.Transaction;
import org.bytesoft.transaction.TransactionLock;
import org.bytesoft.transaction.TransactionRepository;
import org.bytesoft.transaction.xa.TransactionXid;
import org.bytesoft.transaction.xa.XidFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompensableCoordinator
implements RemoteCoordinator,
CompensableBeanFactoryAware,
CompensableEndpointAware {
    static final Logger logger = LoggerFactory.getLogger(CompensableCoordinator.class);
    @Inject
    private CompensableBeanFactory beanFactory;
    private String endpoint;
    private transient boolean ready = false;
    private final Lock lock = new ReentrantLock();

    public Transaction getTransactionQuietly() {
        CompensableManager transactionManager = this.beanFactory.getCompensableManager();
        return transactionManager.getTransactionQuietly();
    }

    public Transaction start(org.bytesoft.transaction.TransactionContext transactionContext, int flags) throws XAException {
        CompensableManager compensableManager = this.beanFactory.getCompensableManager();
        CompensableLogger compensableLogger = this.beanFactory.getCompensableLogger();
        TransactionRepository compensableRepository = this.beanFactory.getCompensableRepository();
        TransactionLock compensableLock = this.beanFactory.getCompensableLock();
        if (compensableManager.getTransactionQuietly() != null) {
            throw new XAException(-6);
        }
        TransactionXid globalXid = transactionContext.getXid();
        Transaction transaction = compensableRepository.getTransaction(globalXid);
        if (transaction == null) {
            transaction = new CompensableTransactionImpl((TransactionContext)transactionContext);
            ((CompensableTransactionImpl)transaction).setBeanFactory(this.beanFactory);
            compensableRepository.putTransaction(globalXid, transaction);
            compensableLogger.createTransaction(((CompensableTransactionImpl)transaction).getTransactionArchive());
            logger.info("{}| compensable transaction begin!", (Object)ByteUtils.byteArrayToString((byte[])globalXid.getGlobalTransactionId()));
        } else if (transaction.getTransactionStatus() != 0) {
            throw new XAException(-6);
        }
        boolean locked = compensableLock.lockTransaction(globalXid, this.endpoint);
        if (!locked) {
            throw new XAException(-6);
        }
        if (!((CompensableTransactionImpl)transaction).lock(true)) {
            throw new XAException(-6);
        }
        TransactionContext compensableContext = (TransactionContext)transaction.getTransactionContext();
        int propagationLevel = compensableContext.getPropagationLevel();
        compensableContext.setPropagationLevel(propagationLevel + 1);
        compensableManager.associateThread(transaction);
        return transaction;
    }

    public Transaction end(org.bytesoft.transaction.TransactionContext transactionContext, int flags) throws XAException {
        CompensableManager compensableManager = this.beanFactory.getCompensableManager();
        TransactionLock compensableLock = this.beanFactory.getCompensableLock();
        CompensableTransaction transaction = compensableManager.getCompensableTransactionQuietly();
        if (transaction == null) {
            throw new XAException(-6);
        }
        compensableManager.desociateThread();
        ((CompensableTransactionImpl)transaction).release();
        TransactionContext compensableContext = transaction.getTransactionContext();
        int propagationLevel = compensableContext.getPropagationLevel();
        compensableContext.setPropagationLevel(propagationLevel - 1);
        compensableLock.unlockTransaction(transactionContext.getXid(), this.endpoint);
        return transaction;
    }

    public void start(Xid xid, int flags) throws XAException {
        throw new XAException(-3);
    }

    public void end(Xid xid, int flags) throws XAException {
        throw new XAException(-3);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.checkParticipantReadyIfNecessary();
        if (xid == null) {
            throw new XAException(-5);
        }
        if (!onePhase) {
            throw new XAException(-3);
        }
        XidFactory xidFactory = this.beanFactory.getCompensableXidFactory();
        TransactionLock compensableLock = this.beanFactory.getCompensableLock();
        TransactionXid globalXid = xidFactory.createGlobalXid(xid.getGlobalTransactionId());
        CompensableTransaction transaction = null;
        boolean success = false;
        boolean locked = false;
        try {
            locked = compensableLock.lockTransaction(globalXid, this.endpoint);
            if (!locked) {
                throw new XAException(-3);
            }
            transaction = this.invokeCommit((Xid)globalXid, onePhase);
            success = true;
        }
        catch (XAException xaex) {
            logger.error("Error occurred while committing transaction: {}.", (Object)ByteUtils.byteArrayToString((byte[])xid.getGlobalTransactionId()), (Object)xaex);
            switch (xaex.errorCode) {
                case 5: 
                case 6: 
                case 7: {
                    success = true;
                }
            }
            throw xaex;
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while committing transaction: {}.", (Object)ByteUtils.byteArrayToString((byte[])xid.getGlobalTransactionId()), (Object)rex);
            throw new XAException(-3);
        }
        finally {
            if (locked) {
                compensableLock.unlockTransaction(globalXid, this.endpoint);
            }
            if (success) {
                transaction.forgetQuietly();
            }
        }
    }

    private CompensableTransaction invokeCommit(Xid xid, boolean onePhase) throws XAException {
        TransactionRepository compensableRepository = this.beanFactory.getCompensableRepository();
        XidFactory xidFactory = this.beanFactory.getCompensableXidFactory();
        CompensableManager compensableManager = this.beanFactory.getCompensableManager();
        TransactionXid globalXid = xidFactory.createGlobalXid(xid.getGlobalTransactionId());
        CompensableTransaction transaction = (CompensableTransaction)compensableRepository.getTransaction(globalXid);
        if (transaction == null) {
            throw new XAException(-4);
        }
        try {
            ((CompensableTransactionImpl)transaction).lock(false);
            compensableManager.associateThread(transaction);
            transaction.participantCommit(onePhase);
        }
        catch (SecurityException ex) {
            compensableRepository.putErrorTransaction(globalXid, (Transaction)transaction);
            throw new XAException(-3);
        }
        catch (IllegalStateException ex) {
            compensableRepository.putErrorTransaction(globalXid, (Transaction)transaction);
            throw new XAException(-3);
        }
        catch (RollbackException ex) {
            throw new XAException(6);
        }
        catch (HeuristicMixedException ex) {
            throw new XAException(5);
        }
        catch (HeuristicRollbackException ex) {
            throw new XAException(6);
        }
        catch (SystemException ex) {
            compensableRepository.putErrorTransaction(globalXid, (Transaction)transaction);
            throw new XAException(-3);
        }
        catch (RuntimeException ex) {
            compensableRepository.putErrorTransaction(globalXid, (Transaction)transaction);
            throw new XAException(-3);
        }
        finally {
            compensableManager.desociateThread();
            ((CompensableTransactionImpl)transaction).release();
        }
        return transaction;
    }

    public void forget(Xid xid) throws XAException {
        XidFactory xidFactory;
        TransactionXid globalXid;
        this.checkParticipantReadyIfNecessary();
        if (xid == null) {
            throw new XAException(-5);
        }
        TransactionRepository compensableRepository = this.beanFactory.getCompensableRepository();
        CompensableTransaction transaction = (CompensableTransaction)compensableRepository.getTransaction(globalXid = (xidFactory = this.beanFactory.getCompensableXidFactory()).createGlobalXid(xid.getGlobalTransactionId()));
        if (transaction == null) {
            throw new XAException(-4);
        }
        try {
            transaction.forget();
        }
        catch (SystemException ex) {
            logger.error("Error occurred while forgetting transaction: {}.", (Object)ByteUtils.byteArrayToString((byte[])xid.getGlobalTransactionId()), (Object)ex);
            throw new XAException(-3);
        }
        catch (RuntimeException rex) {
            logger.error("Error occurred while forgetting transaction: {}.", (Object)ByteUtils.byteArrayToString((byte[])xid.getGlobalTransactionId()), (Object)rex);
            throw new XAException(-3);
        }
    }

    public void forgetQuietly(Xid xid) {
        try {
            this.forget(xid);
        }
        catch (XAException ex) {
            switch (ex.errorCode) {
                case -4: {
                    break;
                }
                default: {
                    logger.error("{}| Error occurred while forgeting remote coordinator.", (Object)ByteUtils.byteArrayToString((byte[])xid.getGlobalTransactionId()), (Object)ex);
                    break;
                }
            }
        }
        catch (RuntimeException ex) {
            logger.error("{}| Error occurred while forgeting remote coordinator.", (Object)ByteUtils.byteArrayToString((byte[])xid.getGlobalTransactionId()), (Object)ex);
        }
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        throw new XAException(-3);
    }

    public int prepare(Xid xid) throws XAException {
        throw new XAException(-3);
    }

    public Xid[] recover(int flag) throws XAException {
        this.checkParticipantReadyIfNecessary();
        TransactionRepository repository = this.beanFactory.getTransactionRepository();
        List transactionList = repository.getActiveTransactionList();
        TransactionXid[] xidArray = new TransactionXid[transactionList.size()];
        for (int i = 0; i < transactionList.size(); ++i) {
            Transaction transaction = (Transaction)transactionList.get(i);
            xidArray[i] = transaction.getTransactionContext().getXid();
        }
        return xidArray;
    }

    public void rollback(Xid xid) throws XAException {
        this.checkParticipantReadyIfNecessary();
        if (xid == null) {
            throw new XAException(-5);
        }
        XidFactory xidFactory = this.beanFactory.getCompensableXidFactory();
        TransactionLock compensableLock = this.beanFactory.getCompensableLock();
        TransactionXid globalXid = xidFactory.createGlobalXid(xid.getGlobalTransactionId());
        CompensableTransaction transaction = null;
        boolean success = false;
        boolean locked = false;
        try {
            locked = compensableLock.lockTransaction(globalXid, this.endpoint);
            if (!locked) {
                throw new XAException(-3);
            }
            transaction = this.invokeRollback((Xid)globalXid);
            success = true;
        }
        catch (RuntimeException ex) {
            logger.error("Error occurred while rolling back transaction: {}.", (Object)ByteUtils.byteArrayToString((byte[])xid.getGlobalTransactionId()), (Object)ex);
            throw new XAException(-3);
        }
        finally {
            if (locked) {
                compensableLock.unlockTransaction(globalXid, this.endpoint);
            }
            if (success) {
                transaction.forgetQuietly();
            }
        }
    }

    private CompensableTransaction invokeRollback(Xid xid) throws XAException {
        TransactionRepository compensableRepository = this.beanFactory.getCompensableRepository();
        XidFactory xidFactory = this.beanFactory.getCompensableXidFactory();
        CompensableManager compensableManager = this.beanFactory.getCompensableManager();
        TransactionXid globalXid = xidFactory.createGlobalXid(xid.getGlobalTransactionId());
        CompensableTransaction transaction = (CompensableTransaction)compensableRepository.getTransaction(globalXid);
        if (transaction == null) {
            throw new XAException(-4);
        }
        try {
            compensableManager.associateThread(transaction);
            transaction.participantRollback();
        }
        catch (IllegalStateException ex) {
            compensableRepository.putErrorTransaction(globalXid, (Transaction)transaction);
            throw new XAException(-3);
        }
        catch (SystemException ex) {
            compensableRepository.putErrorTransaction(globalXid, (Transaction)transaction);
            throw new XAException(-3);
        }
        catch (RuntimeException ex) {
            compensableRepository.putErrorTransaction(globalXid, (Transaction)transaction);
            throw new XAException(-3);
        }
        finally {
            compensableManager.desociateThread();
        }
        return transaction;
    }

    public void markParticipantReady() {
        try {
            this.lock.lock();
            this.ready = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkParticipantReadyIfNecessary() throws XAException {
        if (!this.ready) {
            this.checkParticipantReady();
        }
    }

    private void checkParticipantReady() throws XAException {
        try {
            this.lock.lock();
            if (!this.ready) {
                throw new XAException(-7);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    public void setEndpoint(String identifier) {
        this.endpoint = identifier;
    }

    public String getIdentifier() {
        return this.endpoint;
    }

    public String getApplication() {
        return this.endpoint;
    }

    public void setBeanFactory(CompensableBeanFactory tbf) {
        this.beanFactory = tbf;
    }
}

