/*
 * Decompiled with CFR 0.152.
 */
package org.bytesoft.transaction.xa;

import java.io.Serializable;
import java.util.Arrays;
import javax.transaction.xa.Xid;
import org.bytesoft.common.utils.ByteUtils;

public class TransactionXid
implements Xid,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private int formatId;
    private byte[] globalTransactionId;
    private byte[] branchQualifier;

    public TransactionXid() {
    }

    public TransactionXid(int formatId, byte[] global) {
        this(formatId, global, new byte[0]);
    }

    public TransactionXid(int formatId, byte[] global, byte[] branch) {
        if (global == null) {
            throw new IllegalArgumentException("globalTransactionId cannot be null.");
        }
        if (global.length > 64) {
            throw new IllegalArgumentException("length of globalTransactionId cannot exceed 64 bytes.");
        }
        if (branch == null) {
            throw new IllegalArgumentException("branchQualifier cannot be null.");
        }
        if (branch.length > 64) {
            throw new IllegalArgumentException("length of branchQualifier cannot exceed 64 bytes.");
        }
        this.globalTransactionId = new byte[global.length];
        this.branchQualifier = new byte[branch.length];
        System.arraycopy(global, 0, this.globalTransactionId, 0, global.length);
        System.arraycopy(branch, 0, this.branchQualifier, 0, branch.length);
        this.formatId = formatId;
        this.globalTransactionId = global;
        this.branchQualifier = branch;
    }

    public TransactionXid clone() {
        TransactionXid that = new TransactionXid();
        that.setFormatId(this.formatId);
        byte[] global = new byte[this.globalTransactionId.length];
        byte[] branch = new byte[this.branchQualifier.length];
        System.arraycopy(this.globalTransactionId, 0, global, 0, this.globalTransactionId.length);
        System.arraycopy(this.branchQualifier, 0, branch, 0, this.branchQualifier.length);
        that.setGlobalTransactionId(global);
        that.setBranchQualifier(branch);
        return that;
    }

    public int getFormatId() {
        return this.formatId;
    }

    public int hashCode() {
        int hash = 23;
        hash += 29 * this.getFormatId();
        hash += 31 * Arrays.hashCode(this.branchQualifier);
        return hash += 37 * Arrays.hashCode(this.globalTransactionId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransactionXid other = (TransactionXid)obj;
        if (this.formatId != other.formatId) {
            return false;
        }
        if (!Arrays.equals(this.branchQualifier, other.branchQualifier)) {
            return false;
        }
        return Arrays.equals(this.globalTransactionId, other.globalTransactionId);
    }

    public String toString() {
        String global = this.globalTransactionId == null ? null : ByteUtils.byteArrayToString(this.globalTransactionId);
        String branch = this.branchQualifier == null ? null : ByteUtils.byteArrayToString(this.branchQualifier);
        return String.format("%s-%s-%s", this.getFormatId(), global, branch);
    }

    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    public void setGlobalTransactionId(byte[] globalTransactionId) {
        this.globalTransactionId = globalTransactionId;
    }

    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    public void setBranchQualifier(byte[] branchQualifier) {
        this.branchQualifier = branchQualifier;
    }

    public void setFormatId(int formatId) {
        this.formatId = formatId;
    }
}

